import QtQuick 2.3

import AdaptDemoSystem 1.0

Group {
    property string name: "GodRay"


    property real godRayX: 0.0
    property real godRayY: 0.0

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Blit {
        textureRT: "godRays"
        blitRT: 1
    }

    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRays"
    }
    Shader {
        file: "godrayOld"
        ShaderParam {
            paramName: "rayX"
            paramValue: sync("godray.x")+godRayX
        }
        ShaderParam {
            paramName: "rayY"
            paramValue: sync("godray.y")+godRayY
        }
//        uniform float lightZ = 2.0;
//        float g_intensity = 1.0;
//        float g_specRounds = 2.0;
//        float g_specWeight = 1.5;
        ShaderParam {
            paramName: "lightZ"
            paramValue: sync("godray.lightZ")+1.0
        }
        ShaderParam {
            paramName: "g_intensity"
            paramValue: sync("godray.intensity")
        }
        ShaderParam {
            paramName: "g_specRounds"
            paramValue: sync("godray.specRounds")
        }
        ShaderParam {
            paramName: "g_specWeight"
            paramValue: sync("godray.specWeight")
        }
        ShaderParam {
            paramName: "g_length"
            paramValue: sync("godray.length")
        }
        ShaderParam {
            paramName: "g_vignette"
            paramValue: sync("vignette")
        }
        ShaderParam {
            paramName: "g_vignRad"
            paramValue: sync("vignRad")
        }
        ShaderParam {
            paramName: "g_preBright"
            paramValue: sync("preBright")
        }
        ShaderParam {
            paramName: "g_postBright"
            paramValue: sync("postBright")
        }
        ShaderParam {
            paramName: "g_exp"
            paramValue: sync("exp")
        }

        ShaderParam {
            paramName: "g_rotateAmp"
            paramValue: sync("rotateAmp")
        }
        ShaderParam {
            paramName: "g_rotatePrim"
            paramValue: sync("rotatePrim")
        }
        ShaderParam {
            paramName: "g_rotateSinAmp"
            paramValue: sync("rotateSinAmp")
        }
        ShaderParam {
            paramName: "g_rotateSinFreq"
            paramValue: sync("rotateSinFreq")
        }
        /*
        uniform float g_rotateAmp = 1.0;
        uniform float g_rotatePrim = 0.45;
        uniform float g_rotateSinAmp = 3.2;
        uniform float g_rotateSinFreq = 10.0;
        */

    }
//    uniform float g_vignRad = 0.70;
//    uniform float g_preBright = 3.50;
//    uniform float g_postBright = 1.50;
//    uniform float g_exp = 2.0;




    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false

    }
}

