import QtQuick 2.0
import AdaptDemoSystem 1.0

Effect {
    // background ball with smokey etc textures
    id: bgBall
    name: "bgBall"
    effectName: "BgBall"
    enabled: syncRoot(bgBall.name+".ON", 0)
    Shader {
        property int shaderIndex: sync(bgBall.name+".shaderIndex", 0.0)
        file: {
            if (shaderIndex === 0) return "smBg";
            if (shaderIndex === 1) return "smBg2";
            return "smBg";
        }
    }

    property real swipeFFT: sync(bgBall.name+".swipeFFT", 0.0)


    TextureSel { textureUnit: 0; name: parent.name }

   // Texture { textureUnit: 0; texImage: getTexImageFFT(bgBall.name+".bright") }

    Texture {
        textureUnit: 6;
        texImage: getTexImageFFT(bgBall.name+".bright")
    //    textureRT: getFFTDelayTex(swipeFFT)
    }

    property bool depthEnabled: sync(bgBall.name+".depthEnabled", 1.0) > 0.5




    DrawMesh {
        file: meshSel(bgBall.name);
        enabled: true; smoothNormals: true; normalSmoothAngle: 80;
        blendMode: "off"
        depthTest: depthEnabled; depthWrite: depthEnabled;
        Pos { x: 0.0; y: 0.0; z: 0.0}
        Rot { d: sync(bgBall.name+".trans.rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(bgBall.name+".trans.rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync(bgBall.name+".trans.rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(bgBall.name+".sca", 400.0); x: 1.0; y: sync(bgBall.name+".trans.scaY", 1.0); z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: sync(bgBall.name+".uvScale", 1.0)}
        ShaderParam { paramName: "g_uv2Scale"; paramValue: sync(bgBall.name+".uv2Scale", 1.0)}
        ShaderParam { paramName: "g_uvScaleY"; paramValue: sync(bgBall.name+".uvScaleY", 1.0)}
        ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(bgBall.name+".uvOfsY") }
        ShaderParam { paramName: "g_bump"; paramValue: 0.650}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 1.0 }
        ShaderParam { paramName: "g_texAmbient"; paramValue:  sync(bgBall.name+".ambient") }
        ShaderParam { paramName: "g_color"; paramValueVec4: sync(bgBall.name+".colorR", 1.0)+","+sync(bgBall.name+".colorG", 1.0)+","+sync(bgBall.name+".colorB", 1.0)+",1.0"}
        ShaderParam { paramName: "g_ambColor"; paramValueVec4: sync(bgBall.name+".ambColorR", 0.0)+","+sync(bgBall.name+".ambColorG", 0.0)+","+sync(bgBall.name+".ambColorB", 0.0)+",1.0"}
        ShaderParam { paramName: "g_fadeColor"; paramValueVec4: sync(bgBall.name+".fadeColR", 0.0)+","+sync(bgBall.name+".fadeColG", 0.0)+","+sync(bgBall.name+".fadeColB", 0.0)+","+sync(bgBall.name+".fadeAmp", 1.0)}
        ShaderParam { paramName: "g_bright"; paramValue: syncFFT(bgBall.name+".bright", 1.0)}

        ShaderParam { paramName: "brightFFT_yOfsMul"; syncName: ns("bright.fft.yOfs.mul"); syncDefault: 1.0 }
        ShaderParam { paramName: "brightFFT_yOfsPow"; syncName: ns("bright.fft.yOfs.pow"); syncDefault: 1.0 }

        ShaderParam { paramName: "brightFFT_base"; syncName: ns("bright.fft.base"); syncDefault: 1.0 }
        ShaderParam { paramName: "brightFFT_yMul"; syncName: ns("bright.fft.yMul"); syncDefault: 0.0 }
        ShaderParam { paramName: "brightFFT_yPow"; syncName: ns("bright.fft.yPow"); syncDefault: 1.0 }


        ShaderParam { paramName: "g_baseBright"; paramValue: sync(bgBall.name+".brightBase", 0.50)}
        ShaderParam { paramName: "g_fadeBright"; paramValue: sync(bgBall.name+".brightFade", 0.50)}
        ShaderParam { paramName: "g_fadeEnds"; paramValue: sync(bgBall.name+".fadeEnds", 0.10)}

//        ShaderParam { paramName: "g_swipePos"; paramValue: syncOscFFT(bgBall.name+".swipePos")}
//        ShaderParam { paramName: "g_swipeAmp"; paramValue: sync(bgBall.name+".swipeAmp")}
//        ShaderParam { paramName: "g_swipePow"; paramValue: sync(bgBall.name+".swipePow", 1.0)}

//        ShaderParam { paramName: "g_swipeWidth"; paramValue: sync(bgBall.name+".swipeWidth")}
//        ShaderParam { paramName: "g_swipeFFT"; paramValue: swipeFFT}
//        ShaderParam { paramName: "g_swipeFFTFreq"; paramValue: sync(bgBall.name+".swipeFFTFreq")}
//        ShaderParam { paramName: "g_swipeFFTSpeed"; paramValue: sync(bgBall.name+".swipeFFTSpeed")}
//        ShaderParam { paramName: "g_swipeFFTThr"; paramValue: sync(bgBall.name+".swipeFFTThr")}

//        ShaderParam { paramName: "g_swipeBlend"; paramValue: sync(bgBall.name+".swipeBlend")}
//        ShaderParam { paramName: "g_swipeAmbient"; paramValue: sync(bgBall.name+".swipeAmbient")}

        drawBuffers: 3
    }
 //   Blit {  textureRT: "bgBlur" }
}

