#version 430


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 48) out;

in vec4 origPos[3];
in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];

out vec3 posG;
out vec3 normalG;
out vec2 uvG;
out vec3 tangentG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;


uniform float g_quadsPerRow = 32.0;
uniform float g_texW = 1280;
uniform float g_texH = 720;


uniform float g_emit = 1.0;

layout(binding=0) uniform sampler2D tex;

void emitTriangleStraight(vec4 p0, vec4 p1, vec4 p2, vec3 n0, vec3 n1, vec3 n2) {
    vec3 edge0 = p1.xyz-p0.xyz;
    vec3 edge1 = p2.xyz-p1.xyz;
    vec3 edge2 = p0.xyz-p2.xyz;

    edge0 = normalize(edge0);
    edge1 = normalize(edge1);
    edge2 = normalize(edge2);

    float e0d = abs(dot(-edge0, edge1));
    float e1d = abs(dot(-edge1, edge2));
    float e2d = abs(dot(-edge2, edge0));

    if (e0d <= e1d && e0d <= e2d)  {
        posG = p1.xyz; normalG = n1; uvG = uv[1]; tangentG = tangent[1]; EmitVertex();
        posG = p2.xyz; normalG = n2; uvG = uv[2]; tangentG = tangent[2]; EmitVertex();
        posG = p0.xyz; normalG = n0; uvG = uv[0]; tangentG = tangent[0]; EmitVertex();
        EndPrimitive();
    }
    if (e1d < e0d && e1d <= e2d)  {
        posG = p2.xyz; normalG = n2; uvG = uv[2]; tangentG = tangent[2]; EmitVertex();
        posG = p0.xyz; normalG = n0; uvG = uv[0]; tangentG = tangent[0]; EmitVertex();
        posG = p1.xyz; normalG = n1; uvG = uv[1]; tangentG = tangent[1]; EmitVertex();
        EndPrimitive();
    }
    if (e2d < e0d && e2d < e1d)  {
        posG = p0.xyz; normalG = n0; uvG = uv[0]; tangentG = tangent[0]; EmitVertex();
        posG = p1.xyz; normalG = n1; uvG = uv[1]; tangentG = tangent[1]; EmitVertex();
        posG = p2.xyz; normalG = n2; uvG = uv[2]; tangentG = tangent[2]; EmitVertex();
        EndPrimitive();
    }


}

// layout(binding=0, offset=0) uniform atomic_uint ac;
void emitFourSplit(int pi0, int pi1, int pi2) {
    int pi[3];
    pi[0] = pi0;
    pi[1] = pi1;
    pi[2] = pi2;

    vec4 mp0 = (origPos[pi0]+origPos[pi1])*0.5;
    vec4 mp1 = (origPos[pi1]+origPos[pi2])*0.5;
    vec4 mp2 = (origPos[pi2]+origPos[pi0])*0.5;

    vec3 mn0 = (normal[pi0]+normal[pi1])*0.5;
    vec3 mn1 = (normal[pi1]+normal[pi2])*0.5;
    vec3 mn2 = (normal[pi2]+normal[pi0])*0.5;

//    normalG = normal[pi0]; uvG = uv[pi0]; tangentG = tangent[pi0]; posG = origPos[pi0].xyz; EmitVertex();
//    normalG = normal[pi1]; uvG = uv[pi1]; tangentG = tangent[pi1]; posG = origPos[pi1].xyz; EmitVertex();
//    normalG = normal[pi2]; uvG = uv[pi2]; tangentG = tangent[pi2]; posG = origPos[pi2].xyz; EmitVertex();

    // 0, m0, m2
    // m1, m2, m0
    // m0, 1, m1
    // m2, m1, 2

    normalG = normal[pi0]; uvG = uv[pi0]; tangentG = tangent[pi0]; posG = origPos[pi0].xyz; EmitVertex();
    normalG = mn0; uvG = uv[pi1]; tangentG = tangent[pi1]; posG = mp0.xyz; EmitVertex();
    normalG = mn2; uvG = uv[pi2]; tangentG = tangent[pi2]; posG = mp2.xyz; EmitVertex();
    EndPrimitive();

    normalG = mn1; uvG = uv[pi1]; tangentG = tangent[pi1]; posG = mp1.xyz; EmitVertex();
    normalG = mn2; uvG = uv[pi2]; tangentG = tangent[pi2]; posG = mp2.xyz; EmitVertex();
    normalG = mn0; uvG = uv[pi1]; tangentG = tangent[pi1]; posG = mp0.xyz; EmitVertex();
    EndPrimitive();

    normalG = mn0; uvG = uv[pi1]; tangentG = tangent[pi1]; posG = mp0.xyz; EmitVertex();
    normalG = normal[pi1]; uvG = uv[pi1]; tangentG = tangent[pi1]; posG = origPos[pi1].xyz; EmitVertex();
    normalG = mn1; uvG = uv[pi1]; tangentG = tangent[pi1]; posG = mp1.xyz; EmitVertex();
    EndPrimitive();

    normalG = mn2; uvG = uv[pi2]; tangentG = tangent[pi2]; posG = mp2.xyz; EmitVertex();
    normalG = mn1; uvG = uv[pi1]; tangentG = tangent[pi1]; posG = mp1.xyz; EmitVertex();
    normalG = normal[pi2]; uvG = uv[pi2]; tangentG = tangent[pi2]; posG = origPos[pi2].xyz; EmitVertex();
    EndPrimitive();

}

uniform float recLimit;
// 0, m0, m2
// m1, m2, m0
// m0, 1, m1
// m2, m1, 2

void emitFourSplitRec3(int rec, vec4 p0, vec4 p1, vec4 p2, vec3 n0, vec3 n1, vec3 n2) { // max rec
      emitTriangleStraight(p0, p1, p2, n0, n1, n2);
}

//void emitFourSplitRec3(int rec, vec4 p0, vec4 p1, vec4 p2, vec3 n0, vec3 n1, vec3 n2) {
//    if (rec>=recLimit-1) {
//      emitTriangleStraight(p0, p1, p2, n0, n1, n2);
//      return;
//    }
//    vec4 mp0 = (p0+p1)*0.5; vec4 mp1 = (p1+p2)*0.5; vec4 mp2 = (p2+p0)*0.5;
//    vec3 mn0 = (n0+n1)*0.5; vec3 mn1 = (n1+n2)*0.5; vec3 mn2 = (n2+n0)*0.5;
//    rec++;
//    emitFourSplitRec4(rec, p0, mp0, mp2, n0, mn0, mn2);
//    emitFourSplitRec4(rec, mp1, mp2, mp0, mn1, mn2, mn0);
//    emitFourSplitRec4(rec, mp0, p1, mp1, mn0, n1, mn1);
//    emitFourSplitRec4(rec, mp2, mp1, p2, mn2, mn1, n2);
//}

void emitFourSplitRec2(int rec, vec4 p0, vec4 p1, vec4 p2, vec3 n0, vec3 n1, vec3 n2) {
    if (rec>=int(recLimit)) {
      emitTriangleStraight(p0, p1, p2, n0, n1, n2);
      return;
    }
    vec4 mp0 = (p0+p1)*0.5; vec4 mp1 = (p1+p2)*0.5; vec4 mp2 = (p2+p0)*0.5;
    vec3 mn0 = (n0+n1)*0.5; vec3 mn1 = (n1+n2)*0.5; vec3 mn2 = (n2+n0)*0.5;
    rec++;
    emitFourSplitRec3(rec, p0, mp0, mp2, n0, mn0, mn2);
    emitFourSplitRec3(rec, mp1, mp2, mp0, mn1, mn2, mn0);
    emitFourSplitRec3(rec, mp0, p1, mp1, mn0, n1, mn1);
    emitFourSplitRec3(rec, mp2, mp1, p2, mn2, mn1, n2);
}

void emitFourSplitRec(int rec, vec4 p0, vec4 p1, vec4 p2, vec3 n0, vec3 n1, vec3 n2) {
    if (rec>=int(recLimit)) {
      emitTriangleStraight(p0, p1, p2, n0, n1, n2);
      return;
    }
    vec4 mp0 = (p0+p1)*0.5; vec4 mp1 = (p1+p2)*0.5; vec4 mp2 = (p2+p0)*0.5;
    vec3 mn0 = (n0+n1)*0.5; vec3 mn1 = (n1+n2)*0.5; vec3 mn2 = (n2+n0)*0.5;
    rec++;
    emitFourSplitRec2(rec, p0, mp0, mp2, n0, mn0, mn2);
    emitFourSplitRec2(rec, mp1, mp2, mp0, mn1, mn2, mn0);
    emitFourSplitRec2(rec, mp0, p1, mp1, mn0, n1, mn1);
    emitFourSplitRec2(rec, mp2, mp1, p2, mn2, mn1, n2);
}


void main(void) {

    if (g_emit < 0.5) {
        return;
    }


    emitFourSplitRec(0, origPos[0], origPos[1], origPos[2], normal[0], normal[1], normal[2]);
//        for (int i = 0; i < gl_in.length(); ++i) {
//           //     gl_Position = gl_in[i].gl_Position;
//                posG = origPos[i].xyz;
//                normalG = normal[i];
//                uvG = uv[i];
//                tangentG = tangent[i];
//                EmitVertex();
//        }
    // facePos /= 3.0;



}
