import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
    id: motionBlur
    name: "timeLapse"
    effectName: "TimeLapse"
    enabled: syncRoot(motionBlur.name+".ON")

    property int frameIndex: 0
    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;
        }
    }

    property int effectWidth: 1280
    property int effectHeight: 720

    RenderTarget { RenderTargetLayer { textureRT: "velBufFeed1"; format: "RGBA16F"; width: effectWidth; height: effectHeight } }
    RenderTarget { RenderTargetLayer { textureRT: "velBufFeed2"; format: "RGBA16F"; width: effectWidth; height: effectHeight } }

    function getCurrentVelBuf() {
        return ((frameIndex&1)===0) ? "velBufFeed1" : "velBufFeed2";
    }

    RenderTarget {
        RenderTargetLayer { textureRT: getCurrentVelBuf(); format: "RGBA16F"; width: effectWidth; height: effectHeight }
        Texture { textureUnit: 0; textureRT: "emitBuf"; textureWrap: "clamp" }
        Texture { textureUnit: 1; textureRT: ((frameIndex&1)===0) ? "velBufFeed2" : "velBufFeed1"; textureWrap: "clamp" }
        Shader {
            file: "velBufFeed2"
            ShaderParam { paramName: "g_feed"; paramValue: sync(motionBlur.name+".feedback") }
            ShaderParam { paramName: "g_newVel"; paramValue: syncOsc(motionBlur.name+".newVel") }
            ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
            ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            drawBuffers: 1
        }
    }


    Blit { textureRT: "screenBuffer"; blitRT: 0 }
  //  Texture { textureUnit: 0; imageUnit: 0; textureRT: getCurrentVelBuf() }
    Texture { textureUnit: 0; textureRT: "screenBuffer"; textureWrap: "clamp" }
    Texture { textureUnit: 1; textureRT:  getCurrentVelBuf(); textureWrap: "clamp" }
    Shader {
        file: "motionBlur"
        ShaderParam { paramName: "g_amp"; paramValue: sync(motionBlur.name+".amp") }
        ShaderParam { paramName: "g_chroma"; paramValue: syncOsc(motionBlur.name+".chroma") }
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }
}
