;CHROME REVENGE by Abaddon
;the DOS 1k intro for Assembly 2020

;code: TomCat
;music: ern0

maxvol EQU 0
times EQU 0

Divider EQU 68

RESX EQU 640
RESY EQU 480
maxlevel EQU 3

;Sphere data
Radius EQU 16
Center EQU 0
Color EQU 32

;XMM0: temp0
;XMM1: temp1
;XMM2: color
;XMM3: reflect
;XMM4: normal
;XMM5: direction
;XMM6: point
;XMM7: collect

ORG 256
 INC AX                 ; 0.5028877
 MOV BP,3F00H
 PUSH AX                ; 0.39081812
 SBB AX,CX
 DS
 MOV BX,112H            ; -8260.683
 DB 0C6H,0C4H,04FH      ; MOV AH,4FH
 INT 10H

if times=1
 PUSHAD
 MOV    EAX,08000H
 CDQ
 MOV    FS,AX
 MOV    [FS:0],EAX
 MOV    GS,DX
 MOV    EAX,[GS:046CH]
 MOV    [FS:4],EAX
 RDTSC
 MOV    [FS:8],EAX
 MOV    [FS:12],EDX
 POPAD
end if

if maxvol=1
 PUSHA
 MOV BX,08000H
 MOV FS,BX
 MOV [FS:BX],BX
 POPA
end if

 MOV AX,3508H
 INT 21H
 MOV [BP-4],BX
 MOV [BP+DI],ES

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 ADD AL,Divider-90H     ; carry flag means turn on the speaker
 CALL init

 PUSH 0A000H
 POP ES
nextframe:
 MOV AX,RESY/2
 CWD

 PUSHA
 MOV BX,BP
 MOV DI,Sugar2
 MOV CX,16
 MOV BP,Spheres-3

 TEST BYTE [DI-Sugar2+IRQ.COUNTER+2],CL
 JZ part1
part3:
 FILD WORD [DI-Sugar2+Phase0]
 FILD DWORD [DI-Sugar2+IRQ.COUNTER]; frame
 FMUL DWORD [DI-Sugar2+Speed1-2]
 FLD ST1                ; phase frame phase0

 MOV DL,3
.1:
 SUB BX,SI

 FLD ST0                ; phase phase frame
 FMUL ST0,ST2           ; phase*frame phase frame
 FSINCOS                ; cos sin phase frame
 FABS                   ; |cos| sin phase frame
 FIMUL WORD [DI-Sugar2+Sy]; r*|cos| sin phase frame

 FILD WORD [DI-Sugar2+Sy10]
 FMUL ST0,ST3
 FISUB WORD [DI-Sugar2+Sy550]
 FSUBR ST1,ST0
 FADD ST0,ST0
 FSTP DWORD [BX+Center+8]; Y0 sin phase frame
 FSTP DWORD [BX+Center+4]; sin phase frame

 FILD WORD [DI-Sugar2+Sx]; Sx sin phase frame
 FSUB ST0,ST2           ; Sx-phase sin phase frame
 FMULP                  ; X0 phase frame

 CALL SetXCR

 FLD1                   ; 1 phase frame
 FADDP                  ; 1+phase frame
 LOOP .1

 JMP part1.3

part1:
 FLD DWORD [DI-Sugar2+Rad45-2]
 FLDZ                   ; 0 45'
 LOOP .skip0
.skip0:

 MOV DI,Sugar1
 MOV DL,3
 MOV CL,7
 FIADD DWORD [DI-Sugar1+IRQ.COUNTER]
 FMUL DWORD [DI-Sugar1+SpeedA-2]
 FST ST1                ; ang frame
 FMUL DWORD [DI-Sugar1+SpeedG-2]

.0:
 FILD DWORD [DI+2]      ; r0 ang frame
.1:
 SUB BX,SI

 FLDZ                   ; 0 r0 ang frame
 FLDZ                   ; 0 0 r0 ang frame
 JCXZ .2

 FIADD WORD [DI]        ; S 0 r0 ang frame
 FADD ST1,ST0           ; S S r0 ang frame
 FLD ST3                ; ang S S r0 ang frame
 FADD DWORD [Rad24-2]   ; ang+24' S S r0 ang frame
 FST ST4                ; ang S S r0 ang frame
 FSINCOS                ; cos sin S S r0 ang frame
 FMULP ST2,ST0          ; sin X0 S r0 ang frame
 FMULP ST2,ST0          ; X0 Y0 r0 ang frame

.2:
 FLD ST4                ; alpha X0 Y0 r0 ang frame
 FSINCOS                ; cos sin X0 Y0 r0 ang frame
 FMUL ST0,ST3           ; Y2 sin X0 Y0 r0 ang frame
 FSTP DWORD [BX+Center+4]; sin X0 Y0 r0 ang frame
 FMULP ST2,ST0          ; X0 Y0*sin r0 ang frame
 FLD ST0                ; X0 X0 Y0*sin r0 ang frame
 FILD DWORD [IRQ.COUNTER]
 FMUL DWORD [DI-Sugar1+SpeedB-2]; beta X0 X0 Y0*sin r0 ang frame
 FSINCOS                ; cos sin X0 X0 Y0*sin r0 ang frame
 FMUL ST2,ST0           ; cos sin X0*cos X0 Y0*sin r0 ang frame
 FMUL ST0,ST4           ; cos*Y0*sin sin X0*cos X0 Y0*sin r0 ang frame
 FXCH                   ; sin cos*Y0*sin X0*cos X0 Y0*sin r0 ang frame
 FMUL ST3,ST0           ; sin cos*Y0*sin X0*cos X0*sin Y0*sin r0 ang frame
 FMULP ST4,ST0          ; cos*Y0*sin X0*cos X0*sin sin*Y0*sin r0 ang frame
 FSUBRP ST2,ST0         ; X0*cos Z2 sin*Y0*sin r0 ang frame
 FADDP ST2,ST0          ; Z2 X2 r0 ang frame
 FSTP DWORD [BX+Center+8]; X2 r0 ang frame

 CALL SetXCR

 DEC CX
 JNS .1

 JMP .5
.skip4:

 INC CX

 FILD WORD [DI-Sugar2+CoordY]
 CALL SetXYCR
 SUB BX,SI
 FLDZ
.3:
 FSTP DWORD [BX+Center+8]
 FILD WORD [DI-Sugar2+CoordY]
 FCHS
 CALL SetXYCR
 JMP .5

.4:
 FSIN
 FIMUL WORD [DI-Sugar1+Spheres+11]
 FST DWORD [BX+Center]  ; ang frame

.5:
 FUCOMPP                ; -
 MOV [Trace.1-2],BX
 POPA

 MOV DI,-16
nextline:
 MOV CX,-RESX/2+4
nextpixel:
 PUSHA                  ; -20:DI SI BP SP BX DX CX AX 1 0
 SUB BX,BX
 ADD CX,BP              ; CX > 0
 MOV [BP+SI],SI

;XMM2: Color = Black
 XORPS XMM2,XMM2

;XMM6: P = x,y,1,0
 PMOVSXWD XMM6,[BX-8]
 CVTDQ2PS XMM6,XMM6
 MOVAPS XMM5,XMM6
 MULPS XMM6,[SI]        ; * Aspect
;XMM5: D = 0,0,1,0
 SHUFPS XMM5,XMM5,11101111B

 FLDZ                   ; 0
 FLDLG2                 ; level 0
 FILD DWORD [SI]        ; bignum level 0
 CALL Trace
 POPA
 FUCOMPP                ; -

 CVTPS2DQ XMM2,XMM2
 PACKSSDW XMM2,XMM2
 PACKUSWB XMM2,XMM2

blur:

 TEST CL,3
 JNZ .1
 SHUFPS XMM7,XMM7,11111111B
 MOV BH,[BP+SI]
;MULPS XMM2,[SI]
;XORPS XMM2,XMM2
.1:
 INSERTPS XMM7,XMM2,00110000B

.2:
 SHUFPS XMM7,XMM7,10010011B
 PAVGB XMM2,XMM7
;MULPS XMM2,[SI]
 MOVSS XMM7,XMM2
 CMP [BP+SI],BL
 LOOPNZ .3
 TEST CL,3
 JNZ .2
.3:

 TEST CL,3
 JZ putpixel

back:
 CMP CX,RESX/2+4
 JNE nextpixel

 DEC AX
 CMP AX,-RESY/2
 JG nextline

if times=1
 JZ Exit
end if

 IN AL,60H              ; check for keypress
 DAS                    ; if not pressed
 JC nextframe           ; then go to next frame

Exit:
 POP AX
 LDS DX,[BP-4]
 SALC

if times=1
 PUSH   0
 POP    GS
 MOV    EAX,[GS:046CH]
 MOV    [FS:16],EAX
 RDTSC
 MOV    [FS:20],EAX
 MOV    [FS:24],EDX
end if

init:
 OUT 40H,AL
 MOV AL,0
 OUT 40H,AL
 SALC
 OUT 61H,AL
 MOV AX,2508H
 INT 21H
RETN

putpixel:
 ADD DI,16
 JNZ .4
 PUSHA
 SUB BX,BX
 MOV AX,4F05H
 INT 10H
 POPA
 INC DX
.4:
 MOVAPS [ES:DI],XMM7
 ADD CX,8
 MOV BL,BH
JMP back

Intersection:

 MOV BX,DX              ; found sphere
 XOR [BP+SI],BH

;XMM6: I = P+min*D
 MOVAPS XMM0,[DI]
 SHUFPS XMM0,XMM0,0
 MULPS XMM0,XMM5
 ADDPS XMM6,XMM0

;XMM4: N = -sqrt2/r*(C-I)
 MOVAPS XMM4,[BX+Center]
 SUBPS XMM4,XMM6
 MULPS XMM4,[BX+Radius]

;XMM3: R = D-2*N.D*N
 MOVAPS XMM3,XMM5
 DPPS XMM5,XMM4,01110111B
 MULPS XMM5,XMM4
 SUBPS XMM3,XMM5

 XORPS XMM0,XMM0
 CALL Lights
 PCMPEQD XMM0,XMM0

Lights:

 SUB CX,CX

;XMM5: S = L-I
 PCMPEQD XMM5,XMM5
 PMOVZXBD XMM5,XMM5
 XORPS XMM5,XMM0
 CVTDQ2PS XMM5,XMM5
 SUBPS XMM5,XMM6

 FLDLN2                 ; Ambient level 0

Trace0:

;XMM5: D = VNORM
 MOVAPS XMM0,XMM5
 DPPS XMM0,XMM0,01111111B
 RSQRTPS XMM0,XMM0      ; SQRTPS XMM0,XMM0
 MULPS XMM5,XMM0        ; DIVPS XMM5,XMM0

Trace:
 XCHG AX,BX             ; AX: last sphere
 CWD                    ; DX: 0
 MOV BX,Spheres
.1:
 MOV DI,BP;Base16
nextsphere:
 CMP BX,AX
 JE selftest

;XMM1: V = C-P
 MOVAPS XMM1,[BX+Center]
 SUBPS XMM1,XMM6

;XMM0: b = V.D
 MOVAPS XMM0,XMM1
 DPPS XMM0,XMM5,01110001B
 MOVAPS [DI],XMM0
 FLD DWORD [DI]         ; b min level 0
 FUCOMI ST0,ST3         ; b min level 0
 JBE nosphere

 FMUL ST0,ST0           ; b2 min level 0
 FIADD WORD [BX+Radius] ; b2+r2 min level 0
;XMM1: V.V
 DPPS XMM1,XMM1,01110001B
 MOVAPS [BP+DI],XMM1
 FSUB DWORD [BP+DI]     ; b2+r2-V.V min level 0
 FUCOMI ST0,ST3         ; b2+r2-V.V min level 0
 JBE nosphere
 JCXZ shaded            ; shadow ray

 FSQRT                  ; d min level 0
 FSUBR DWORD [DI]       ; b-d min level 0
 FUCOMI ST0,ST1
 JAE nosphere
 FXCH ST1
 MOV DX,BX
nosphere:
 FSTP ST0               ; min level 0
selftest:
 ADD BX,SI
 CMP BX,BP
 JNZ nextsphere
 JCXZ Shading           ; shadow ray

 FSTP DWORD [DI]        ; level 0
 TEST DX,DX
 JZ Ground

 CALL Intersection

 CMP SP,-22-2*maxlevel  ; Max recursion level = 3
 LOOPE Tquit

 MOVAPS XMM5,XMM3
 FMUL DWORD [SI]        ; level/2 0
 FILD DWORD [SI]        ; big number for min
 CALL Trace0
Tquit:

Ground:
RETN

Shading:

;XMM1: N.S
 MOVAPS XMM1,XMM4
 DPPS XMM1,XMM5,01110001B
 MOVAPS [DI],XMM1

 CMP [DI+3],CH
 JLE @F                 ; Ambient level 0
 FADD DWORD [DI]        ; Ambient+Diffuse level 0
@@:

;XMM5: R.S
 DPPS XMM5,XMM3,01110001B
 MOVAPS [DI],XMM5
 FLD1
 FADD DWORD [DI]        ; Specular Ambient+Diffuse level 0
@@:
 FMUL ST0,ST0
 INC CX
 JPO @B                 ; loop x3

;XMM2: Color+level*Specular
 FMUL ST0,ST2           ; level*Specular Ambient+Diffuse level 0
 FST DWORD [DI]
 MOVAPS XMM0,[DI]
 SHUFPS XMM0,XMM0,0
 ADDPS XMM2,XMM0

 ADD [BP+SI],SP

shaded:
 FSTP ST0               ; Ambient+Diffuse level 0

 XCHG BX,AX             ; BX: last hit

 FMUL ST0,ST1           ; level*(Ambient+Diffuse) level 0
 FSTP DWORD [DI]        ; level 0

;XMM1: intensity
 MOVAPS XMM1,[DI]
 SHUFPS XMM1,XMM1,0

;XMM2: Color+texture*intensity
 MULPS XMM1,[BX+Color]
 ADDPS XMM2,XMM1

RETN

SetXYCR:
 FSTP DWORD [BX+Center+4]
 FILD DWORD [DI+2]      ; r0 ang frame
 FLDZ                   ; 0 r0 ang frame
 MOV BP,BX
SetXCR:
 ADD BP,DX
 FSTP DWORD [BX+Center] ; r0 ang frame
 JCXZ .1
 FILD DWORD [DI+8]      ; r1 r0 ang frame
.1:
 PMOVZXBD XMM1,[BP+0]
 CVTDQ2PS XMM1,XMM1
 MOVAPS [BX+Color],XMM1
 FIST DWORD [BX+Radius]
 FIST DWORD [BX+Radius+4]
 FISTP DWORD [BX+Radius+8]
RETN

 DB 127,10           ; B,G,R/sqrt2
Spheres:
 DB 0,0,91              ; 0800000H maroon
 DB 24,98,13            ; 0228B22H forestgreen
 DB 0,49,180            ; 0FF4500H orangered
 DB 92,0,51             ; 04B0082H indiogo
 DB 0,0,180             ; 0FF0000H red
 DB 180,0,0             ; 00000FFH blue
 DB 0,152,180           ; 0FFD700H gold
 DB 180,127,3           ; B,G,R/sqrt2

Phase0 = (Spheres+11)   ; DW 51
Speed1 DW 03648H        ; x0.000002984

Sy = (Spheres+5)        ; DW 13
Sy10 = (Spheres-1)      ; DW 10

CoordY DW 181+30+13-2
Rad45 DW 03F49H
Sy550 DW 550
Rad24 DW 03ED6H
Sx DW 145

Sugar1:
 DW 80
 DW 3919,0BCB9H
SpeedB DW 0387BH        ; x0.00006
 DW 198,0BDCEH          ; r2,-sqrt2/r
SpeedG DW 03FA0H        ; x0.00010/0.00008
Sugar2:
 DW 43
 DW 32641,0BC00H        ; r2,-sqrt2/r
SpeedA DW 038A7H        ; x0.00008
 DW 169,0BDDFH

; --------------------------- music please ! -------------------------------
INCLUDE "NOTES.INC"

NOTES:
 DB A_3,B_3,D_4,Fs4
 DB B_3,D_4,E_4,Gs4

 DB B_3,D_4,Fs4,B_4
 DB B_3,Cs4,E_4,Gs4

 DB Cs4,E_4,Fs4,A_4

IRQ:
 PUSHA
 MOV AL,2
.SAMPLE:

 SHR AL,1              ; zero means pause (no sound)
 JZ @F
 OUT 42H,AL             ; out the 6bit sample
@@:

 DB 66H,68H             ; PUSH DWORD 0FF000001H
.COUNTER:
 DB 0,16,0              ; timer counter (default 4096)
;DB 0,0,13              ; for debug 0D0000H
 DB 0                   ; sample sum (default 0)
 POP SI                 ; SI=timer counter
 POP BX                 ; BL=pattern, BH=volume

 MOV BP,NOTES
 INC DWORD [BP-NOTES+IRQ.COUNTER]

 MOV AX,BX
 CMP AL,2
 JB DRUMS

 MOV BYTE [BP-NOTES+part1.skip0-1],part1.0-part1.skip0
 MOV [BP-NOTES+part1.skip4-1],BH

 PUSH DI
 MOV CX,3
 MOV DI,4*4
 SHR AL,1
 JC @F
 TEST SI,1111000000000000B
 JZ SKIP
 MOV CH,128
 MOV DI,AX
 SHLD DI,SI,CL
 AND DI,3*4
@@:
 DEC AX
 SHR AL,1
 AND CL,AL

CHORDS:
 SALC
 MOV AH,[BP+DI]         ; pitch F#,...
 MUL SI
 AND DX,1FH             ; wave saw

 ADD BH,DL

 INC DI
 TEST DI,3
 JNZ CHORDS

 IMUL AX,SI,-16
 OR AL,111B
 ROR AX,CL
 MUL BX                 ; tone env

 IMUL AX,SI,-1          ; volume env
 OR AH,CH
 MUL DX                 ; sample (6 bits [0..63])

 MOV BH,DH

SKIP:
 INC BX
 INC BX
 POP DI
 AND BL,3*4
 JZ DONE

 MOV BYTE [BP-NOTES+part1.skip0-1],0
 MOV BYTE [BP-NOTES+part1.skip4-1],part1.4-part1.skip4

DRUMS:
 SUB SI,1000000000000B

HIHAT:
 XCHG AX,DI
 MUL SI
 XCHG AX,DX
 AND AX,32
 SHRD CX,SI,16+6+1
 TEST CL,32
 JZ SNARE
 AND CX,31
 INC CX
 CWD
 DIV CX
 JMP KICKDRUM.1

SNARE:
 XCHG CX,AX
 MOV AH,0D0H
 OR AX,SI
 IMUL AX
 TEST DH,DH
 JNZ .1
 XCHG AX,CX
 MUL DL
 ADD BH,AH
.1:

KICKDRUM:
 MOV AX,16128
 CWD
 MOV CX,8191
 AND CX,SI
 INC CX
 DIV CX
 AND AL,64
.1:
 ADD BH,AL

 MOV AL,180             ; vol 181 -> vol 127
 MUL BH                 ; mastering
 XCHG BX,AX
DONE:
 MOV [BP-NOTES+IRQ.SAMPLE-1],BH

if maxvol=1
 CMP [FS:8000H],BH
 JAE @F
 MOV [FS:8000H],BH
@@:
end if

 MOV  AL,20H
 OUT  20H,AL
 POPA
IRET
