/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PShader;

public class demo
extends PApplet {
    Minim minim;
    AudioPlayer music;
    FFT fft;
    float[] musicAnalysis;
    long musicStart = 0L;
    Intro intro = new Intro();
    Opening opening = new Opening();
    Shaders shaders = new Shaders();
    Pipes pipes = new Pipes();
    Credits credits = new Credits();
    Scene[] scenes = new Scene[]{this.intro, this.opening, this.shaders, this.pipes, this.credits};
    int sceneIndex = 0;

    public void setup() {
        this.width = 1920;
        this.height = 1080;
        this.noCursor();
        int i = 0;
        while (i < this.scenes.length) {
            this.scenes[i].init();
            ++i;
        }
        this.minim = new Minim((Object)this);
        this.music = this.minim.loadFile("music.mp3");
        this.music.play();
        this.fft = new FFT(this.music.bufferSize(), this.music.sampleRate());
        this.fft.logAverages(22, 3);
        this.musicAnalysis = new float[this.fft.avgSize()];
        i = 0;
        while (i < this.musicAnalysis.length) {
            this.musicAnalysis[i] = 0.0f;
            ++i;
        }
    }

    public void draw() {
        if (this.musicStart == 0L && this.music.isPlaying()) {
            this.musicStart = this.millis();
        }
        this.fft.forward(this.music.mix);
        this.scenes[this.sceneIndex].draw();
        if (this.scenes[this.sceneIndex].done()) {
            ++this.sceneIndex;
            if (this.sceneIndex == this.scenes.length) {
                this.exit();
            }
        }
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"demo"};
        if (passedArgs != null) {
            PApplet.main((String[])demo.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Credits
    implements Scene {
        boolean done;
        String[] credits = new String[]{"Music:\nExit the Premises by Kevin MacLeod\nLink: https://incompetech.filmmusic.io/song/3728-exit-the-premises\nLicense: http://creativecommons.org/licenses/by/4.0/", "Code:\nNanohenry", "Models:\nNanohenry", "Models created with:\nBlender", "Demo created with:\nProcessing 3", "Thanks for watching!"};
        long startTime;

        Credits() {
        }

        @Override
        public void init() {
        }

        @Override
        public void draw() {
            if (this.startTime == 0L) {
                this.startTime = demo.this.millis();
            }
            demo.this.background(0);
            demo.this.fill(255);
            demo.this.textSize(32.0f);
            demo.this.textAlign(3);
            int cIndex = PApplet.parseInt((float)((long)demo.this.millis() - this.startTime)) / 1000;
            if (cIndex < this.credits.length) {
                demo.this.text(this.credits[cIndex], demo.this.width / 2, demo.this.height / 2);
            } else {
                this.done = true;
            }
        }

        @Override
        public boolean done() {
            return this.done;
        }
    }

    class Intro
    implements Scene {
        boolean done;
        PFont font;

        Intro() {
        }

        @Override
        public void init() {
            this.font = demo.this.loadFont("intro-font.vlw");
            demo.this.textFont(this.font);
        }

        @Override
        public void draw() {
            demo.this.background(0);
            if ((long)demo.this.millis() - demo.this.musicStart < 1400L) {
                return;
            }
            if ((long)demo.this.millis() - demo.this.musicStart < 3400L) {
                demo.this.fill(255);
                demo.this.textSize(64.0f);
                demo.this.textAlign(37);
                demo.this.text("On 12.10.2020", 100.0f, demo.this.height - 170);
            } else if ((long)demo.this.millis() - demo.this.musicStart < 5200L) {
                demo.this.fill(255);
                demo.this.textSize(64.0f);
                demo.this.textAlign(37);
                demo.this.text("On 12.10.2020, at 17:13", 100.0f, demo.this.height - 170);
            } else if ((long)demo.this.millis() - demo.this.musicStart < 7200L) {
                demo.this.fill(255);
                demo.this.textSize(64.0f);
                demo.this.textAlign(37);
                demo.this.text("On 12.10.2020, at 17:13", 100.0f, demo.this.height - 170);
                demo.this.text("It was a peaceful afternoon, until...", 100.0f, demo.this.height - 100);
            } else {
                this.done = true;
            }
        }

        @Override
        public boolean done() {
            return this.done;
        }
    }

    class Opening
    implements Scene {
        boolean done;
        ArrayList<PShape> objects;
        PGraphics canvas;
        PVector[][] camPaths = new PVector[][]{{new PVector(-100.0f, 400.0f, 400.0f), new PVector(100.0f, 400.0f, 400.0f), new PVector(-100.0f, 400.0f, 600.0f), new PVector(100.0f, 400.0f, 600.0f)}, {new PVector(300.0f, 400.0f, 300.0f), new PVector(-300.0f, 400.0f, 400.0f), new PVector(-400.0f, 450.0f, -400.0f), new PVector(10.0f, 0.0f, -10.0f)}, {new PVector(-300.0f, 400.0f, 400.0f), new PVector(-300.0f, 400.0f, 200.0f), new PVector(10.0f, 0.0f, -10.0f), new PVector(10.0f, 0.0f, -10.0f)}, {new PVector(-300.0f, 400.0f, 200.0f), new PVector(-10.0f, 250.0f, 10.0f), new PVector(10.0f, 0.0f, -10.0f), new PVector(10.0f, 0.0f, -10.0f)}, {new PVector(-10.0f, 250.0f, 10.0f), new PVector(-10.0f, 250.0f, 10.0f), new PVector(10.0f, 0.0f, -10.0f), new PVector(10.0f, 0.0f, -10.0f)}, {new PVector(-10.0f, 250.0f, 10.0f), new PVector(-100.0f, 250.0f, -150.0f), new PVector(10.0f, 0.0f, -10.0f), new PVector(0.0f, 190.0f, -150.0f)}, {new PVector(-100.0f, 250.0f, -150.0f), new PVector(-100.0f, 250.0f, -150.0f), new PVector(0.0f, 190.0f, -150.0f), new PVector(0.0f, 190.0f, -150.0f)}, {new PVector(-100.0f, 250.0f, -150.0f), new PVector(-100.0f, 250.0f, -150.0f), new PVector(0.0f, 190.0f, -150.0f), new PVector(0.0f, 190.0f, -150.0f)}};
        long[] camPathDurations = new long[]{4000L, 1500L, 500L, 3000L, 3000L, 3000L, 4000L, 1000L};
        int camPathIndex = 0;
        long lastCamPathChange = 0L;
        PGraphics phone;
        PGraphics laptop;
        boolean laptopOpen = false;
        float laptopAngle = 0.0f;

        Opening() {
        }

        @Override
        public void init() {
            this.canvas = demo.this.createGraphics(demo.this.width, demo.this.height, "processing.opengl.PGraphics3D");
            this.objects = new ArrayList();
            PShape table = demo.this.loadShape("assets/table.obj");
            table.setFill(demo.this.color(133, 94, 66));
            table.scale(100.0f);
            this.objects.add(table);
            PShape floor = demo.this.createShape(41, new float[]{1200.0f, 1.0f, 1500.0f});
            floor.setFill(demo.this.color(127));
            floor.setStroke(false);
            floor.translate(0.0f, 0.0f, 0.0f);
            this.objects.add(floor);
            PShape walls = demo.this.createShape(41, new float[]{1200.0f, 600.0f, 1500.0f});
            walls.setFill(demo.this.color(92, 217, 255));
            walls.setStroke(false);
            walls.translate(0.0f, 300.0f, 0.0f);
            this.objects.add(walls);
            PShape sofa = demo.this.loadShape("assets/sofa.obj");
            sofa.setFill(demo.this.color(133, 94, 66));
            sofa.scale(100.0f);
            sofa.translate(-500.0f, 0.0f, 0.0f);
            this.objects.add(sofa);
            PShape tvTable = demo.this.createShape(41, new float[]{200.0f, 100.0f, 400.0f});
            tvTable.setFill(demo.this.color(77));
            tvTable.setStroke(false);
            tvTable.translate(500.0f, 50.0f, 0.0f);
            this.objects.add(tvTable);
            PShape tv = demo.this.loadShape("assets/tv.obj");
            tv.setFill(demo.this.color(10));
            tv.scale(100.0f);
            tv.translate(550.0f, 100.0f, 0.0f);
            this.objects.add(tv);
            PShape clockFace = demo.this.createShape(41, new float[]{80.0f, 80.0f, 10.0f});
            clockFace.setFill(demo.this.color(255));
            clockFace.setStroke(false);
            clockFace.translate(0.0f, 400.0f, 600.0f);
            this.objects.add(clockFace);
            PShape clockRing = demo.this.createShape(41, new float[]{90.0f, 90.0f, 10.0f});
            clockRing.setFill(demo.this.color(0));
            clockRing.setStroke(false);
            clockRing.translate(0.0f, 400.0f, 605.0f);
            this.objects.add(clockRing);
            PShape lamp = demo.this.loadShape("assets/lamp.obj");
            lamp.setFill(demo.this.color(127));
            lamp.scale(60.0f);
            lamp.translate(500.0f, 0.0f, -600.0f);
            this.objects.add(lamp);
            this.phone = demo.this.createGraphics(200, 400, "processing.opengl.PGraphics2D");
            this.laptop = demo.this.createGraphics(300, 200, "processing.opengl.PGraphics2D");
            this.canvas.perspective(1.0471976f, (float)demo.this.width / (float)demo.this.height, 1.0E-5f, 10000.0f);
        }

        @Override
        public void draw() {
            this.phone.beginDraw();
            if (this.camPathIndex > 3 || this.camPathIndex == 3 && demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)0.0f, (float)1.0f) > 0.5f) {
                this.phone.background(255);
                this.phone.fill(10.0f, 150.0f, 255.0f);
                this.phone.noStroke();
                this.phone.rect(0.0f, 45.0f, 170.0f, 70.0f);
                this.phone.fill(0);
                this.phone.textSize(20.0f);
                this.phone.textAlign(37);
                this.phone.text("Yo, Assembly is", 15.0f, 70.0f);
                this.phone.text("in two days!", 15.0f, 100.0f);
                if (this.camPathIndex > 4 || this.camPathIndex == 4 && (long)demo.this.millis() - this.lastCamPathChange > 1000L) {
                    this.phone.fill(0.0f, 255.0f, 0.0f);
                    this.phone.noStroke();
                    this.phone.rect(100.0f, 140.0f, 100.0f, 50.0f);
                    this.phone.fill(0);
                    this.phone.textSize(20.0f);
                    this.phone.textAlign(39);
                    this.phone.text("Oh shit!", 185.0f, 170.0f);
                }
                if (this.camPathIndex > 4 || this.camPathIndex == 4 && (long)demo.this.millis() - this.lastCamPathChange > 1600L) {
                    this.phone.fill(0.0f, 255.0f, 0.0f);
                    this.phone.noStroke();
                    this.phone.rect(30.0f, 200.0f, 180.0f, 50.0f);
                    this.phone.fill(0);
                    this.phone.textSize(20.0f);
                    this.phone.textAlign(39);
                    this.phone.text("Be right back!", 185.0f, 230.0f);
                }
            } else {
                this.phone.background(32);
            }
            this.phone.endDraw();
            this.laptop.beginDraw();
            this.laptop.background(255);
            if (this.camPathIndex == 5) {
                this.laptop.fill(0);
                this.laptop.textSize(18.0f);
                this.laptop.textAlign(3);
                this.laptop.text("Coding...", 150.0f, 100.0f);
            } else if ((long)demo.this.millis() - this.lastCamPathChange <= 1000L) {
                this.laptop.fill(0);
                this.laptop.textSize(18.0f);
                this.laptop.textAlign(3);
                this.laptop.text("Coding some more...", 150.0f, 100.0f);
            } else if ((long)demo.this.millis() - this.lastCamPathChange <= 2000L) {
                this.laptop.fill(0);
                this.laptop.textSize(18.0f);
                this.laptop.textAlign(3);
                this.laptop.text("Partying in advance...", 150.0f, 100.0f);
            } else if ((long)demo.this.millis() - this.lastCamPathChange <= 3000L) {
                this.laptop.fill(0);
                this.laptop.textSize(18.0f);
                this.laptop.textAlign(3);
                this.laptop.text("Cleaning up...", 150.0f, 100.0f);
            } else if ((long)demo.this.millis() - this.lastCamPathChange <= 4000L) {
                this.laptop.fill(0);
                this.laptop.textSize(18.0f);
                this.laptop.textAlign(3);
                this.laptop.text("Done!", 150.0f, 100.0f);
            }
            this.laptop.endDraw();
            if (this.camPathIndex == 5 && demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)0.0f, (float)1.0f) > 0.5f) {
                this.laptopOpen = true;
            }
            if (this.laptopOpen) {
                this.laptopAngle += (120.0f - this.laptopAngle) * 0.07f;
            }
            this.canvas.beginDraw();
            PVector[] currentPath = this.camPaths[this.camPathIndex];
            float camX = demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)currentPath[0].x, (float)currentPath[1].x);
            float camY = demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)currentPath[0].y, (float)currentPath[1].y);
            float camZ = demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)currentPath[0].z, (float)currentPath[1].z);
            float lookX = demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)currentPath[2].x, (float)currentPath[3].x);
            float lookY = demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)currentPath[2].y, (float)currentPath[3].y);
            float lookZ = demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)currentPath[2].z, (float)currentPath[3].z);
            this.canvas.camera(camX, camY, camZ, lookX, lookY, lookZ, 0.0f, -1.0f, 0.0f);
            this.canvas.pointLight(255.0f, 255.0f, 255.0f, 0.0f, 500.0f, 0.0f);
            this.canvas.ambientLight(32.0f, 32.0f, 32.0f);
            this.canvas.background(0);
            int i = 0;
            while (i < this.objects.size()) {
                this.canvas.shape(this.objects.get(i), 0.0f, 0.0f);
                ++i;
            }
            this.canvas.noStroke();
            this.canvas.fill(0);
            float i2 = 0.0f;
            while (i2 < 12.0f) {
                this.canvas.translate(demo.cos((float)demo.radians((float)(-(i2 / 12.0f) * 360.0f + 90.0f))) * 35.0f, 400.0f + demo.sin((float)demo.radians((float)(-(i2 / 12.0f) * 360.0f + 90.0f))) * 35.0f, 593.0f);
                this.canvas.ellipse(0.0f, 0.0f, 5.0f, 5.0f);
                this.canvas.translate(-demo.cos((float)demo.radians((float)(-(i2 / 12.0f) * 360.0f + 90.0f))) * 35.0f, -400.0f - demo.sin((float)demo.radians((float)(-(i2 / 12.0f) * 360.0f + 90.0f))) * 35.0f, -593.0f);
                i2 += 1.0f;
            }
            this.canvas.stroke(0);
            this.canvas.strokeWeight(10.0f);
            float m = 12.0f;
            if (demo.map((float)((long)demo.this.millis() - this.lastCamPathChange), (float)0.0f, (float)this.camPathDurations[this.camPathIndex], (float)0.0f, (float)1.0f) > 0.5f) {
                m += 1.0f;
            }
            this.canvas.line(0.0f, 400.0f, 593.0f, demo.cos((float)demo.radians((float)(-(0.41666666f + m / 3600.0f) * 360.0f + 90.0f))) * 15.0f, 400.0f + demo.sin((float)demo.radians((float)(-(0.41666666f + m / 3600.0f) * 360.0f + 90.0f))) * 15.0f, 593.0f);
            this.canvas.line(0.0f, 400.0f, 593.0f, demo.cos((float)demo.radians((float)(-(m / 60.0f) * 360.0f + 90.0f))) * 30.0f, 400.0f + demo.sin((float)demo.radians((float)(-(m / 60.0f) * 360.0f + 90.0f))) * 30.0f, 593.0f);
            this.canvas.translate(0.0f, 150.0f, 0.0f);
            this.canvas.rotateY(-0.7853982f);
            this.canvas.fill(0);
            this.canvas.noStroke();
            this.canvas.box(22.0f, 2.0f, 42.0f);
            this.canvas.beginShape(16);
            this.canvas.texture((PImage)this.phone);
            this.canvas.vertex(-10.0f, 1.1f, -20.0f, 200.0f, 0.0f);
            this.canvas.vertex(10.0f, 1.1f, -20.0f, 0.0f, 0.0f);
            this.canvas.vertex(10.0f, 1.1f, 20.0f, 0.0f, 400.0f);
            this.canvas.vertex(-10.0f, 1.1f, 20.0f, 200.0f, 400.0f);
            this.canvas.endShape(2);
            this.canvas.rotateY(0.7853982f);
            this.canvas.translate(0.0f, -150.0f, 0.0f);
            this.canvas.translate(0.0f, 150.0f, -150.0f);
            this.canvas.box(60.0f, 2.0f, 90.0f);
            this.canvas.translate(30.0f, 0.0f, 0.0f);
            this.canvas.rotateZ(demo.radians((float)(-this.laptopAngle)));
            this.canvas.translate(-30.0f, 0.0f, 0.0f);
            this.canvas.box(60.0f, 2.0f, 90.0f);
            this.canvas.noLights();
            this.canvas.beginShape(16);
            this.canvas.texture((PImage)this.laptop);
            this.canvas.vertex(29.0f, -1.1f, 44.0f, 0.0f, 200.0f);
            this.canvas.vertex(-29.0f, -1.1f, 44.0f, 0.0f, 0.0f);
            this.canvas.vertex(-29.0f, -1.1f, -44.0f, 300.0f, 0.0f);
            this.canvas.vertex(29.0f, -1.1f, -44.0f, 300.0f, 200.0f);
            this.canvas.endShape(2);
            this.canvas.endDraw();
            if (this.lastCamPathChange != 0L && (long)demo.this.millis() - this.lastCamPathChange > this.camPathDurations[this.camPathIndex]) {
                ++this.camPathIndex;
                if (this.camPathIndex == this.camPaths.length) {
                    --this.camPathIndex;
                    this.done = true;
                } else {
                    this.lastCamPathChange = demo.this.millis();
                }
            }
            if (this.camPathIndex < 7) {
                demo.this.image((PImage)this.canvas, 0.0f, 0.0f);
                if ((long)demo.this.millis() - demo.this.musicStart >= 8000L) {
                    if (this.lastCamPathChange == 0L) {
                        this.lastCamPathChange = demo.this.millis();
                    }
                    demo.this.fill(0, 255.0f - demo.min((float)255.0f, (float)(((long)demo.this.millis() - demo.this.musicStart - 8000L) / 4L)));
                } else {
                    demo.this.fill(0);
                }
                demo.this.noStroke();
                demo.this.rect(0.0f, 0.0f, demo.this.width, demo.this.height);
            } else {
                float z = (float)((long)demo.this.millis() - this.lastCamPathChange) / (float)this.camPathDurations[this.camPathIndex];
                demo.this.image((PImage)this.canvas, z * (float)(-(demo.this.width / 2)), z * (float)(-(demo.this.height / 2)), (float)demo.this.width * (z + 1.0f), (float)demo.this.height * (z + 1.0f));
                demo.this.fill(255, demo.min((float)(z * 300.0f), (float)255.0f));
                demo.this.rect(0.0f, 0.0f, demo.this.width, demo.this.height);
            }
        }

        @Override
        public boolean done() {
            return this.done;
        }
    }

    class Pipes
    implements Scene {
        boolean done;
        PGraphics render;
        PImage[] textures;
        PGraphics spiralTexture;
        int spiralSize = PApplet.parseInt((float)16.875f);
        float twist;
        long start;

        Pipes() {
        }

        @Override
        public void init() {
            this.textures = new PImage[3];
            int i = 0;
            while (i < this.textures.length) {
                this.textures[i] = demo.this.createImage(100, 100, 1);
                int y = 0;
                while (y < 100) {
                    int x = 0;
                    while (x < 100) {
                        this.textures[i].pixels[x + y * 100] = y < 5 || y > 95 ? demo.this.color(0) : demo.this.color(PApplet.parseInt((i == 0 ? 1 : 0) != 0) * 255, PApplet.parseInt((i == 1 ? 1 : 0) != 0) * 255, PApplet.parseInt((i == 2 ? 1 : 0) != 0) * 255);
                        ++x;
                    }
                    ++y;
                }
                ++i;
            }
            this.render = demo.this.createGraphics(demo.this.width, demo.this.height, "processing.opengl.PGraphics3D");
            this.render.noSmooth();
            this.render.beginDraw();
            this.render.perspective(demo.radians((float)120.0f), (float)demo.this.width / (float)demo.this.height, 1.0f, 100000.0f);
            this.render.textureMode(1);
            this.render.endDraw();
            this.spiralTexture = demo.this.createGraphics(400, this.spiralSize, "processing.opengl.PGraphics2D");
            this.spiralTexture.beginDraw();
            this.spiralTexture.background(255);
            this.spiralTexture.noStroke();
            int x = 0;
            while (x < 400) {
                this.spiralTexture.fill(255.0f, (float)(PApplet.parseInt((x / this.spiralSize % 2 != 0 ? 1 : 0) != 0) * 255), (float)(PApplet.parseInt((x / this.spiralSize % 2 != 0 ? 1 : 0) != 0) * 255));
                this.spiralTexture.rect((float)x, 0.0f, (float)this.spiralSize, (float)this.spiralSize);
                x += this.spiralSize;
            }
            this.spiralTexture.endDraw();
        }

        public void tunnel(PGraphics c) {
            float angleStep = 30.0f;
            float distStep = 50.0f;
            int z = -1500;
            while (z <= 1500) {
                float t = 0.0f;
                while (t < 360.0f) {
                    c.beginShape(16);
                    int texture = (int)(t / angleStep % (float)this.textures.length);
                    c.texture(this.textures[texture]);
                    c.vertex(demo.sin((float)demo.radians((float)(t + (float)((z + 10000) / 10)))) * 300.0f, demo.cos((float)demo.radians((float)(t + (float)((z + 10000) / 10)))) * 300.0f, (float)z, 0.0f, 0.0f);
                    c.vertex(demo.sin((float)demo.radians((float)(t + ((float)(z + 10000) + distStep) / 10.0f))) * 300.0f, demo.cos((float)demo.radians((float)(t + ((float)(z + 10000) + distStep) / 10.0f))) * 300.0f, (float)z + distStep, 1.0f, 0.0f);
                    c.vertex(demo.sin((float)demo.radians((float)(t + angleStep + ((float)(z + 10000) + distStep) / 10.0f))) * 300.0f, demo.cos((float)demo.radians((float)(t + angleStep + ((float)(z + 10000) + distStep) / 10.0f))) * 300.0f, (float)z + distStep, 1.0f, 1.0f);
                    c.vertex(demo.sin((float)demo.radians((float)(t + angleStep + (float)((z + 10000) / 10)))) * 300.0f, demo.cos((float)demo.radians((float)(t + angleStep + (float)((z + 10000) / 10)))) * 300.0f, (float)z, 0.0f, 1.0f);
                    c.endShape(2);
                    t += angleStep;
                }
                z = (int)((float)z + distStep);
            }
        }

        @Override
        public void draw() {
            if (this.start == 0L) {
                this.start = demo.this.millis();
            }
            this.render.beginDraw();
            this.render.camera(100.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            this.render.background(255);
            this.render.noStroke();
            this.render.rotateX((float)demo.this.frameCount / 90.0f);
            this.render.rotateZ((float)demo.this.frameCount / 30.0f);
            this.tunnel(this.render);
            this.render.rotateZ((float)demo.this.frameCount / -30.0f);
            this.render.rotateX((float)demo.this.frameCount / -90.0f);
            this.render.endDraw();
            demo.this.tint(demo.sin((float)((float)demo.this.frameCount / 20.0f)) * 100.0f + 155.0f, demo.sin((float)(2.0943952f + (float)demo.this.frameCount / 20.0f)) * 100.0f + 155.0f, demo.sin((float)(4.1887903f + (float)demo.this.frameCount / 20.0f)) * 100.0f + 155.0f, 100.0f);
            demo.this.image((PImage)this.render, 0.0f, 0.0f, demo.this.width, demo.this.height);
            int i = 0;
            while (i < demo.this.height) {
                int j = 0;
                while (j < 360) {
                    float rot = demo.sin((float)(this.twist + (float)Math.PI * ((float)i / (float)demo.this.height))) * 50.0f;
                    int x1 = (int)(demo.sin((float)demo.radians((float)((float)(0 + j) + rot))) * 200.0f);
                    int x2 = (int)(demo.sin((float)demo.radians((float)((float)(90 + j) + rot))) * 200.0f);
                    if (x2 > x1) {
                        float c = (rot + (float)j + 45.0f) % 360.0f;
                        if (c > 180.0f) {
                            c = 360.0f - c;
                        }
                        demo.this.noStroke();
                        demo.this.beginShape(16);
                        demo.this.tint(255.0f - c * 2.0f);
                        demo.this.texture((PImage)this.spiralTexture);
                        float h = -500.0f;
                        if (i / this.spiralSize % 2 == 0) {
                            demo.this.vertex((float)(demo.this.width / 2 + x1) + h, i, 0.0f, 0.0f);
                            demo.this.vertex((float)(demo.this.width / 2 + x2) + h, i, 400.0f, 0.0f);
                            demo.this.vertex((float)(demo.this.width / 2 + x2) + h, i + this.spiralSize, 400.0f, this.spiralSize);
                            demo.this.vertex((float)(demo.this.width / 2 + x1) + h, i + this.spiralSize, 0.0f, this.spiralSize);
                        } else {
                            demo.this.vertex((float)(demo.this.width / 2 + x1) + h, i, 0.0f, 0.0f);
                            demo.this.vertex((float)(demo.this.width / 2 + x2) + h, i, 400.0f, 0.0f);
                            demo.this.vertex((float)(demo.this.width / 2 + x2) + h, i + this.spiralSize, 400.0f, this.spiralSize);
                            demo.this.vertex((float)(demo.this.width / 2 + x1) + h, i + this.spiralSize, 0.0f, this.spiralSize);
                        }
                        demo.this.endShape();
                        demo.this.tint(255);
                    }
                    j += 90;
                }
                i += this.spiralSize;
            }
            demo.this.fill(255);
            demo.this.textSize(128.0f);
            demo.this.textAlign(3);
            String t = "Greetings, hope you enjoyed! Cheers to friends and family in Finland and Luxembourg!";
            int i2 = 0;
            while (i2 < t.length()) {
                demo.this.text(t.charAt(i2), (float)(demo.this.width + 100) - (float)((long)demo.this.millis() - this.start) / 3.0f + (float)(i2 * 80), (float)(demo.this.height / 2) + demo.sin((float)((float)demo.this.frameCount / 10.0f - (float)i2 / 2.0f)) * 100.0f);
                ++i2;
            }
            i2 = 0;
            while (i2 < demo.this.height) {
                int j = 0;
                while (j < 360) {
                    float rot = demo.sin((float)(this.twist + (float)Math.PI * ((float)i2 / (float)demo.this.height))) * 50.0f;
                    int x1 = (int)(demo.sin((float)demo.radians((float)((float)(0 + j) + rot))) * 200.0f);
                    int x2 = (int)(demo.sin((float)demo.radians((float)((float)(90 + j) + rot))) * 200.0f);
                    if (x2 > x1) {
                        float c = (rot + (float)j + 45.0f) % 360.0f;
                        if (c > 180.0f) {
                            c = 360.0f - c;
                        }
                        demo.this.noStroke();
                        demo.this.beginShape(16);
                        demo.this.tint(255.0f - c * 2.0f);
                        demo.this.texture((PImage)this.spiralTexture);
                        float h = 500.0f;
                        if (i2 / this.spiralSize % 2 == 0) {
                            demo.this.vertex((float)(demo.this.width / 2 + x1) + h, i2, 0.0f, 0.0f);
                            demo.this.vertex((float)(demo.this.width / 2 + x2) + h, i2, 400.0f, 0.0f);
                            demo.this.vertex((float)(demo.this.width / 2 + x2) + h, i2 + this.spiralSize, 400.0f, this.spiralSize);
                            demo.this.vertex((float)(demo.this.width / 2 + x1) + h, i2 + this.spiralSize, 0.0f, this.spiralSize);
                        } else {
                            demo.this.vertex((float)(demo.this.width / 2 + x1) + h, i2, 0.0f, 0.0f);
                            demo.this.vertex((float)(demo.this.width / 2 + x2) + h, i2, 400.0f, 0.0f);
                            demo.this.vertex((float)(demo.this.width / 2 + x2) + h, i2 + this.spiralSize, 400.0f, this.spiralSize);
                            demo.this.vertex((float)(demo.this.width / 2 + x1) + h, i2 + this.spiralSize, 0.0f, this.spiralSize);
                        }
                        demo.this.endShape();
                        demo.this.tint(255);
                    }
                    j += 90;
                }
                i2 += this.spiralSize;
            }
            this.twist -= 0.05f;
            if ((long)demo.this.millis() - this.start >= 26000L) {
                demo.this.fill(0, demo.min((float)demo.map((float)((long)demo.this.millis() - this.start - 26000L), (float)0.0f, (float)1000.0f, (float)0.0f, (float)255.0f), (float)255.0f));
                demo.this.rect(0.0f, 0.0f, demo.this.width, demo.this.height);
                if ((long)demo.this.millis() - this.start >= 27000L) {
                    this.done = true;
                }
            }
        }

        @Override
        public boolean done() {
            return this.done;
        }
    }

    static interface Scene {
        public void init();

        public void draw();

        public boolean done();
    }

    class Shaders
    implements Scene {
        boolean done;
        int bg;
        PShader rc;
        PGraphics canvas;
        float camDist;
        int spinStartFrame;
        long spinStartTime;

        Shaders() {
        }

        @Override
        public void init() {
            this.bg = 255;
            this.rc = demo.this.loadShader("raycaster.glsl");
            this.canvas = demo.this.createGraphics(demo.this.width, demo.this.height, "processing.opengl.PGraphics3D");
            this.canvas.shader(this.rc);
            this.rc.set("resolution", (float)demo.this.width, (float)demo.this.height);
            this.camDist = 800.0f;
        }

        @Override
        public void draw() {
            if (this.camDist >= 500.0f) {
                this.spinStartFrame = demo.this.frameCount;
                this.spinStartTime = demo.this.millis();
            }
            this.canvas.beginDraw();
            this.canvas.background(107.0f, 156.0f, 255.0f);
            this.rc.set("lightLocation", demo.sin((float)((float)demo.this.frameCount / 240.0f)) * 10.0f, 9.0f, -20.0f);
            this.rc.set("sphereLocation1", demo.sin((float)((float)demo.this.frameCount / 120.0f)) * 7.0f, -2.0f + demo.abs((float)demo.sin((float)((float)demo.this.frameCount / 10.0f))) * 2.0f, -20.0f + demo.cos((float)((float)demo.this.frameCount / 120.0f)) * 7.0f);
            this.rc.set("sphereLocation2", demo.sin((float)((float)demo.this.frameCount / 120.0f)) * -7.0f, -2.0f + demo.abs((float)demo.sin((float)((float)demo.this.frameCount / 10.0f + 0.7853982f))) * 2.0f, -20.0f + demo.cos((float)((float)demo.this.frameCount / 120.0f)) * -7.0f);
            this.rc.set("cubeLocation", 0.0f, demo.sin((float)((float)demo.this.frameCount / 10.0f)) * 2.0f + 0.5f, -20.0f);
            this.rc.set("sphereRadius1", 3.0f);
            this.rc.set("sphereRadius2", 3.0f);
            this.rc.set("cubeSize", 2.0f, 2.0f, 2.0f);
            this.rc.set("cubeOrientation", (float)demo.this.frameCount / 60.0f, (float)demo.this.frameCount / 52.7f, 0.0f);
            this.canvas.translate((float)(demo.this.width / 2), (float)(demo.this.height / 2), this.camDist);
            if ((long)demo.this.millis() - this.spinStartTime > 18000L) {
                this.canvas.translate(0.0f, (float)((long)demo.this.millis() - this.spinStartTime - 18000L), 0.0f);
                if ((long)demo.this.millis() - this.spinStartTime > 20000L) {
                    this.done = true;
                }
            }
            this.canvas.fill(255);
            if (this.camDist < 500.0f) {
                this.canvas.stroke(0);
                this.canvas.strokeWeight(3.0f);
            } else {
                this.canvas.noStroke();
            }
            this.canvas.rotateX((float)(demo.this.frameCount - this.spinStartFrame) / 84.3f);
            this.canvas.rotateY((float)(demo.this.frameCount - this.spinStartFrame) / 54.8f);
            this.canvas.rotateZ((float)(demo.this.frameCount - this.spinStartFrame) / 75.7f);
            this.canvas.box(500.0f);
            this.canvas.rotateX((float)(demo.this.frameCount - this.spinStartFrame) / -84.3f);
            this.canvas.rotateY((float)(demo.this.frameCount - this.spinStartFrame) / -54.8f);
            this.canvas.rotateZ((float)(demo.this.frameCount - this.spinStartFrame) / -75.7f);
            if (demo.this.frameCount - this.spinStartFrame > 180) {
                this.canvas.translate(demo.sin((float)((float)(demo.this.frameCount - this.spinStartFrame - 180) / 60.0f)) * 600.0f, 0.0f, demo.cos((float)((float)(demo.this.frameCount - this.spinStartFrame - 180) / 60.0f)) * -660.0f);
                this.canvas.rotateX((float)(demo.this.frameCount - this.spinStartFrame) / -53.3f);
                this.canvas.rotateY((float)(demo.this.frameCount - this.spinStartFrame) / 54.8f);
                this.canvas.rotateZ((float)(demo.this.frameCount - this.spinStartFrame) / 75.7f);
                this.canvas.box(300.0f);
                this.canvas.rotateX((float)(demo.this.frameCount - this.spinStartFrame) / 53.3f);
                this.canvas.rotateY((float)(demo.this.frameCount - this.spinStartFrame) / -54.8f);
                this.canvas.rotateZ((float)(demo.this.frameCount - this.spinStartFrame) / -75.7f);
            }
            this.canvas.endDraw();
            demo.this.image((PImage)this.canvas, 0.0f, 0.0f);
            int i = 0;
            while (i < demo.this.fft.avgSize()) {
                int n = i;
                demo.this.musicAnalysis[n] = demo.this.musicAnalysis[n] + (demo.this.fft.getAvg(i) - demo.this.musicAnalysis[i]) * 0.3f;
                float h = demo.this.musicAnalysis[i] * 4.0f;
                float w = demo.this.width / demo.this.fft.avgSize();
                demo.this.fill(demo.this.lerpColor(demo.this.color(0, 255, 0), demo.this.color(255, 128, 0), demo.this.musicAnalysis[i] / 100.0f));
                demo.this.noStroke();
                demo.this.rect((float)i * w, (float)demo.this.height - h, w - 10.0f, h);
                ++i;
            }
            if (this.camDist > -200.0f) {
                this.camDist += demo.max((float)(-this.camDist - 150.0f), (float)-2.0f);
            }
            if (this.bg > 0) {
                demo.this.fill(255, this.bg);
                demo.this.rect(0.0f, 0.0f, demo.this.width, demo.this.height);
                this.bg -= demo.min((int)this.bg, (int)2);
            }
        }

        @Override
        public boolean done() {
            return this.done;
        }
    }
}

