#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 9) out;


in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in float bright[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out float brightG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float furLength = 1.0;

// uniform float makkara;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D tex2;

uniform float g_uvScaleVoro = 1.0;
uniform float g_uvScaleYVoro = 1.0;
uniform float g_voroLift = 0.0;
uniform float g_voroValCutOff = 0.5;

uniform float g_voroUvOfsX = 0.0;
uniform float g_voroUvOfsY = 0.0;

float getBr(vec3 c) {
    return dot(vec3(1.0), c);
}

vec3 clampVoro(vec3 v) {
    v = clamp(v-g_voroValCutOff, 0.0, 1.0)/(1.0-g_voroValCutOff);
    v = floor(v*5.0)/5.0;     // discretize

    return v;
}

float getVal(vec3 v) {
    return max(max(v.x, v.y), v.z);
}

uniform float g_distToZW = 1.0;
uniform float g_distToZPow = 1.0;
uniform float g_voroDispYM = 0.5;
uniform float g_voroDispYOfs = 0.2;

void main(void) {
        vec3 controlBase = vec3(0.0);
		
        float times = g_time*0.1;
        vec3 faceNormal = vec3(0.0);
        vec4 facePos = vec4(0.0);

        vec2 muv[3];
        muv[0] = uv[0];
        muv[1] = uv[1];
        muv[2] = uv[2];

        muv[0].y *= g_uvScaleYVoro;
        muv[1].y *= g_uvScaleYVoro;
        muv[2].y *= g_uvScaleYVoro;

        muv[0].xy += vec2(g_voroUvOfsX, g_voroUvOfsY);
        muv[1].xy += vec2(g_voroUvOfsX, g_voroUvOfsY);
        muv[2].xy += vec2(g_voroUvOfsX, g_voroUvOfsY);


       // vec4 voroPat1 = texelFetch(tex2, ivec2(muv[0]*g_uvScaleVoro*1024.0), 0);
       // vec4 voroPat2 = texture2D(tex2, ivec2(muv[1]*g_uvScaleVoro*1024.0), 0);
       // vec4 voroPat3 = texture2D(tex2, ivec2(muv[2]*g_uvScaleVoro*1024.0), 0);
        vec4 voroPat1 = texture2D(tex2, muv[0]*g_uvScaleVoro);
        vec4 voroPat2 = texture2D(tex2, muv[1]*g_uvScaleVoro);
        vec4 voroPat3 = texture2D(tex2, muv[2]*g_uvScaleVoro);

//        vec3 voroValV1 = clampVoro(vec3(voroPat1.r, voroPat2.r, voroPat3.r));
//        vec3 voroValV2 = clampVoro(vec3(voroPat1.g, voroPat2.g, voroPat3.g));
//        vec3 voroValV3 = clampVoro(vec3(voroPat1.b, voroPat2.b, voroPat3.b));
//        vec3 voroValV = clampVoro(vec3(getVal(voroPat1.xyz), getVal(voroPat2.xyz), getVal(voroPat3.xyz)));

        float voroVal = getVal(clampVoro(vec3(voroPat1.g, voroPat2.g, voroPat3.g)));

        float voroAng1 = floor(voroVal/0.30)*0.30;
        float voroAng2 = floor(voroVal/0.720)*0.720;

        for (int i = 0; i < gl_in.length(); ++i) {
                gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);
                posW = modelMatrix*gl_Position;

                float distToZM = pow(dot(posW.xy, posW.xy)*g_distToZW, g_distToZPow);

                float zmulle = 1.0/(clamp((distToZM), 0.0, 1000000.0)+1.0);
                //zmulle = -1.0f;

                vec3 kolps = normal[i];
                kolps = rotateXZ3(kolps, voroAng1*voroVal*10.0);
                kolps.yzx = rotateXZ3(kolps, voroAng2*voroVal*8.0).yzx;
                kolps.y *= g_voroDispYM;
                kolps.y += g_voroDispYOfs;
                gl_Position.xyz -= kolps*voroVal*g_voroLift*zmulle;
                facePos += origPos[i];
                // gl_Position.xyz -= normal[i]*1.5;
                posW = modelMatrix*gl_Position;
                gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
                normalG = normal[i];
                colorG = vec3(1.90, 0.92, 0.9925)*0.01*float(gl_PrimitiveIDIn%100);

                if (gl_Position.x > 1.0) return;


                vec4 jk = (modelMatrix * vec4(normalG, 0.0));
                normalWSG = jk.xyz;
                normalG = (modelMatrix * vec4(normalG, 0.0)).xyz;

                brightG = bright[i];

                posG = gl_Position;
             //   controlG = controlBase;
             //   controlG.r = 0.1;
                faceNormal += normal[i];
                uvG = uv[i];
                tangentG = tangent[i];
                EmitVertex();
        }
        facePos /= 3.0;

        EndPrimitive();


}
