import QtQuick 2.8

import Qt.WebSockets 1.1

import "keyValue.js" as KeyValue
import "common.js" as Common

Item {

    property int clientId: 0
    property bool clientIdSet: false

    WebSocket {
        id: socket
        url: "ws://127.0.0.1:7788"
        active: true

        onTextMessageReceived: {
            var kv = KeyValue.makeKeyValue(message);
            var cid;
            if (message.indexOf("P:") === 0) {
                cid = parseInt(kv["P"]);
            } else if (message.indexOf("B;") === 0) {
                var xyr = kv["xyr"];
                var xyra = xyr.split(",");
                var i3=0;
            } else if (message.indexOf("PS:") === 0) {
                cid = parseInt(kv["PS"]);
            } else if (message.indexOf("H:") === 0) {
                cid = parseInt(kv["H"]);
            } else if (message.indexOf("V:") === 0) {
                cid = parseInt(kv["V"]);
                var x = kv["x"];
                var y = kv["y"];
                rocket.markUpdateFrequent();
                //rocket.setTrackTempValue("stir.part.emitMesh.x", x);
                //rocket.setTrackTempValue("stir.part.emitMesh.y", y);

                rocket.setTrackTempValue("testOverlay.mesh1.posX", x);
                rocket.setTrackTempValue("testOverlay.mesh1.posY", y);
            } else if (message.indexOf("RESP;") === 0) {
                console.log("RESP message:"+kv.toString());
                var s = kv["id"];
                if (s.length && !clientIdSet) {
                    clientId = parseInt(s);
                    console.log("cliendId set to "+clientId);
                    clientIdSet = true;
                }
            } else {
                console.log("Received message: \n" + message);
            }
        }
        onStatusChanged: if (socket.status === WebSocket.Error) {
                             console.log("Error: " + socket.errorString)
                         } else if (socket.status === WebSocket.Open) {
                             socketConnectRetry.stop();
                             socket.sendTextMessage("Hello this is the freshly connected client.");
                         } else if (socket.status === WebSocket.Closed) {
                             console.log("Socket closed\n");
                             active = false;
                             socketConnectRetry.start();
                         }
    }

    Timer {
        id: socketConnectRetry
        interval: 1000
        repeat: true
        onTriggered: {
            socket.active = true;
        }
    }
}
