import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class conspiracy extends PApplet {



final float FPS = 60;
final float SPEED = 120;
final String[] icons = {"forssa.png","illuminati.png","atomi.png","kallo.png","keso.png","recy.png","soon.png"};
final String[] texts = {"Hello people at Vortex IV!",
                        "There is this place called Forssa.",
                        "A lump about the size of Luxemburg.",
                        "Even right now people there",
                        "are talking s**t about us.",
                        "So lets shake things up a bit!",
                        "We invite all of you to",
                        "a brand new demoparty!",
                        "Conspiracy Forssa 2020",
                        "1-2 May 2020 at Työväentalo, Forssa",
                        "Compos","Vappu Brunch","Tinfoil hats","Live music","LaserDisc karaoke!!!!",
                        "In reality we all live in Forssa.","Forssa is conspiracy, confirmed.",
                        "Come celebrate työväenjuhla."};
final String[] greets = {"WIDE LOAD","PARAGUAY","BYTERAPERS","ADAPT","CNCD","FAIRLIGHT","ASD","QUADTRIP","DEKADENCE","DAMONES","JUMALAUTA","TEKOTUOTANTO","WAMMA","PWP","SCENESAT","In reality we all live in Forssa.","Forssa is conspiracy, confirmed!","1-2 May 2020"};

float now = 0.0f;
float CANVAS_WIDTH = 1920;
float CANVAS_HEIGHT = 1080;

Moonlander moonlander;

PFont font;
PImage overlay1;
PImage[] iconImages = new PImage[icons.length];
PGraphics bg;

PShader postShader;
PShader mainShader;

public void settings() {
  boolean fullscreen = true;
  
  if (fullscreen) {
    fullScreen(P3D);
  } else {
    size((int)CANVAS_WIDTH,(int)CANVAS_HEIGHT, P3D);
  }
}

public void setup() {
  font = createFont("RussoOne-Regular.ttf",100);
    for (int i = 0; i < iconImages.length; i++)
  {
    iconImages[i] = loadImage(icons[i]);
  }
  bg = createGraphics((int)CANVAS_WIDTH,(int)CANVAS_HEIGHT);
  postShader = loadShader("glitch.glsl");
  postShader.set("iResolution",(float)CANVAS_WIDTH, (float)CANVAS_HEIGHT);
  mainShader = loadShader("beams.glsl");
  mainShader.set("iResolution",(float)CANVAS_WIDTH, (float)CANVAS_HEIGHT);
  noCursor();
  
  int bpm = 120;
  int rowsPerBeat = 4;
  shader(postShader);
  resetShader();
  shader(mainShader);
  moonlander = Moonlander.initWithSoundtrack(this, "salaliitto_m.mp3", bpm, rowsPerBeat);
  //moonlander = new Moonlander(this, new TimeController(bpm/60*rowsPerBeat));
  moonlander.start();
  int fps = (int)FPS;
  frameRate(fps);
}

int x,y,z;
String msg = "";
public void drawText()
{
  pushMatrix();
  fill(255,255,255);
  textFont(font);
  msg = texts[(int)moonlander.getValue("text:i")];
  int x = -(int)(textWidth(msg)/2) + (int)moonlander.getValue("text:x");
  int y = (int)moonlander.getValue("text:y");
  int z = (int)moonlander.getValue("text:z");
  for (int i = 0; i < msg.length(); i++) {
    text(msg.charAt(i),x,y,z + 10*sin(i+QUARTER_PI*(float)moonlander.getCurrentTime()));
    x += textWidth(msg.charAt(i));
  }
  popMatrix();
}

public void drawGreets(int idx)
{
  shearX((float)moonlander.getValue("greet:s")*QUARTER_PI);
  pushMatrix();
  fill(255,255,255);
  textFont(font);
  String m;
  int g = (int)moonlander.getValue("greet:z");
  if (g > 14) m = greets[g];
  else m = "Is " +greets[g] + " conspiracy?";
  x = (int)moonlander.getValue("greet:x");
    for (int i = 0; i < m.length(); i++) {
    text(m.charAt(i),x,(int)moonlander.getValue("greet:y"),10*sin(i+QUARTER_PI*(float)moonlander.getCurrentTime()));
    x += textWidth(m.charAt(i));
  }
  popMatrix();
}

public void drawIconCentered()
{
  pushMatrix();
  translate(0,0);
  int i = (int)moonlander.getValue("scene:icon");
  image(iconImages[i],-iconImages[i].width/2,-iconImages[i].height/2);
  popMatrix();
}

public void drawSolidColorBGWithAlpha()
{
  bg.beginDraw();
  bg.background((float)moonlander.getValue("bg:r"),(float)moonlander.getValue("bg:g"),(float)moonlander.getValue("bg:b"),(float)moonlander.getValue("bg:a"));
  bg.endDraw();
  image(bg,-bg.width/2,-bg.height/2);
}

public void draw() { 
  moonlander.update();
  now = (float)moonlander.getCurrentTime();
  if (now > 65.0f) {
    exit();
  }
      hint(DISABLE_DEPTH_TEST);
      noLights();
      shader(mainShader);
      mainShader.set("iTime",(float)moonlander.getCurrentTime());
      mainShader.set("alpha",(float)moonlander.getValue("bg:a"));
      mainShader.set("curve",(float)moonlander.getValue("bg:r"));
      rect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
      resetShader();
      translate(width/2, height/2, 0);
      scale(width/CANVAS_WIDTH,height/CANVAS_HEIGHT,width/CANVAS_WIDTH);
      drawIconCentered();
      drawText();
      if ((int)moonlander.getValue("scene:scene") == 1) drawGreets(0);
      postShader.set("iTime",(float)moonlander.getCurrentTime());
      filter(postShader);
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "conspiracy" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
