MSHADERS = {  
  mvertex: [
    "varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"
  ].join("\n"),

  bgFragment: [
    "uniform vec2 resolution;",
    "uniform float time;",
    //"uniform int circleMode;",

    "vec3 bg(vec2 uv, float aspect) {",
      "float x2 = (uv.x-0.5)*aspect*sin((time)*6.2);",
      "float x = (uv.x-0.5)*aspect;",
      "float y = uv.y-0.5;",

      "float v1 = x/y*tan(time);",
      "float v2 = y/(x-y)*tan(time*0.3);",

      //"float v3 = (y/x+0.5)*(tan(time*0.3)+0.2);",
      "float xgr = mod(x/(y+0.3)*10.0*sin(time*0.3), 2.0);",
      "float ygr = mod(y/(y+0.5)*12.0, 2.0);",


      "float cc = sqrt(x*x + y*y)*tan(time)*-0.5;",

      "if((cc < 0.15 && cc > 0.14) || (cc < 0.19 && cc > 0.17)) {",
        "return vec3(0.4, 0.1, 0.7);",
      "}",

      "if(v1 < 0.2 && v1 > 0.1 && (ygr < 0.3 || ygr > 0.4)) {",

        "return vec3(0.6, 0.9, 0.5);",
      "}",


      "if (v2 < 0.2 && v2 > 0.1 && (xgr < 0.2 || xgr > 0.6)) {",
        "return vec3(0.0, 0.5, 0.6);",
      "}",

      "return vec3(0.0, 0.0, 0.0);",
    "}",

    "void main() {",
      "vec2 uv = gl_FragCoord.xy / resolution.xy;",
      "float aspect = resolution.x/resolution.y;",
      
      "vec3 color = bg(uv, aspect);",
      "vec3 corColor = smoothstep(0.1, 1.0, color);",
      "gl_FragColor = vec4(corColor, 1.0);",

      //"gl_FragColor = vec4(color, 1.0);",
    "}"  
  ].join("\n"),

  circlesFragment: [
    "uniform vec2 resolution;",
    "uniform float time;",
    "uniform float gtime;",
    "uniform int bgpart;",
    "uniform float circleTime;",
    "uniform float circleTime2;",
    "uniform int circlesOn;",
    

    "vec3 bg2() {",
      "return vec3(0.4, 0.0, 0.6);",
    "}",
    

    "vec3 circles2(vec2 u, float aspect) {",
      "float x = (u.x-0.5)*aspect;",
      "float y = u.y-0.5;",
      "float cc = sqrt(x*x + y*y)*tan(circleTime)*-0.5;",
      "float cc2 = sqrt(x*x + y*y)*tan(circleTime2)*-1.6;",

      "if (cc < 0.2 && cc > 0.1)", 
        "return vec3(0.4, 0.0, 0.6);",

      "else return vec3(0.0, 0.0, 0.0);",    

    "}",


    "void main() {",
      "vec2 uv = gl_FragCoord.xy / resolution.xy;",

      "float aspect = resolution.x/resolution.y;",
    
      "float r = length(uv);",
      "float p = atan(uv.x, r);",
      "vec3 color;",
      "color = bg2()*0.7 + circles2(uv, aspect)*0.5;",
      //"color = circles2(uv, aspect)*0.5;",

      "vec3 corColor = smoothstep(0.1, 1.0, color);",
      "gl_FragColor = vec4(corColor, 1.0);",
      //"gl_FragColor = vec4(0.2, 0.0, 1.0, 1.0);",
    "}"
  ].join("\n")

}
