var Text = function(){
    var size = TDEMO.MAIN.getRendererSize();
    PartBase.call(this,
        {camera : new THREE.OrthographicCamera( -size[0]/2, size[0]/2, size[1]/2, -size[1]/2, 0.1, 2000 )});
    this.camera.position.z = 1;

    this.mainScene = new THREE.Scene();
    var aspect = this.width/this.height;
    this.mainCamera = new THREE.PerspectiveCamera(50, aspect, this.near, this.far);

    this.mainScene.add(this.mainCamera);
    this.rtt = new THREE.WebGLRenderTarget(size[0], size[1]);
    this.rtt.texture.format = THREE.RGBFormat;
    this.rtt.texture.minFilter = THREE.NearestFilter;
    this.rtt.texture.magFilter = THREE.NearestFilter;
    this.rtt.texture.generateMipmaps = false;
    this.rtt.stencilBuffer = false;
    this.rtt.depthBuffer = true;
    this.rtt.depthTexture = new THREE.DepthTexture();
    this.rtt.depthTexture.type = THREE.UnsignedShortType;

    this.uniforms = THREE.DepthScreen.uniforms;
    this.uniforms.tDepth.value = this.rtt.depthTexture;
    this.uniforms.tDiffuse.value = this.rtt.texture;
    this.uniforms.uNear.value = this.near;
    this.uniforms.uFar.value = this.far;
    this.uniforms.uResolution.value = size;
    
    var pg = new THREE.PlaneBufferGeometry(this.width, this.height);
    var pm = new THREE.ShaderMaterial({
        uniforms : this.uniforms,
        vertexShader : THREE.DepthScreen.vertexShader,
        fragmentShader : THREE.DepthScreen.fragmentShader
    })

    //var pm = new THREE.MeshBasicMaterial({map: this.rtt.texture});
    this.plane = new THREE.Mesh(pg, pm);
    this.scene.add(this.plane);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(1.5);
    this.setDoF({
        focus: 0.2,
        maxblur: 0.25,
        aparture: 0.025,
        camera: this.mainCamera
    });

    var paragraphs = [
        "Enjoy",
        "the",
        "Vortex"
    ];

    //this.mainScene.fog = new THREE.Fog(0x808080, 10, 100);
    
    var ambientLight = new THREE.AmbientLight(0xFFFFFF);
    this.mainScene.add(ambientLight);
    
    this.pointLight = new THREE.PointLight(0x808080);
    this.pointLight.position.set(20., 30., 0.);
    this.mainScene.add(this.pointLight);
    
    this.pointLight2 = new THREE.PointLight(0x808080);
    this.pointLight2.position.set(-20., 30., 0.);
    this.mainScene.add(this.pointLight2);
    
    this.cameraLight = new THREE.PointLight(0xFFFFFF);
    this.mainScene.add(this.cameraLight);

    //this.teksti = this.createText(paragraphs);
    //this.mainScene.add(this.teksti);

    this.cubes = this.createCubes();
    this.cubes.position.y = -40;
    this.mainScene.add(this.cubes);

    this.ground = this.createHeightMap();
    this.ground.position.y = -35;
    this.mainScene.add(this.ground);

    this.sky = this.createSky();
    this.mainScene.add(this.sky);
};

Text.prototype = PartBase.prototype.inheritance();

Text.prototype.renderDepthScene = function(){
    TDEMO.MAIN.getRenderer().render(this.mainScene, this.mainCamera, this.rtt, true);
}

Text.prototype.animateCamera = function(){
    this.near = TDEMO.SYNC.getNear();
    this.far = TDEMO.SYNC.getFar();

    this.mainCamera.near = this.near;
    this.mainCamera.far = this.far;
    this.lens = TDEMO.SYNC.getLens();
    this.mainCamera.filmGauge = this.lens.fg;
    this.mainCamera.setFocalLength(this.lens.fl);
    this.mainCamera.updateProjectionMatrix();
    
    var camp = TDEMO.SYNC.getCameraPosition();
    this.mainCamera.position.x = camp.x;
    this.mainCamera.position.y = camp.y;
    this.mainCamera.position.z = camp.z;

    var camr = TDEMO.SYNC.getCameraRotation();
    /*this.mainCamera.rotation.x = camr.x;
    this.mainCamera.rotation.y = camr.y;
    this.mainCamera.rotation.z = camr.z;*/
    this.mainCamera.lookAt(camr);

    this.cameraLight.position.set(this.mainCamera.position.clone());

    this.uniforms.uNear.value = this.near;
    this.uniforms.uFar.value = this.far;
    this.uniforms.uRo.value = camp;
    this.uniforms.uRd.value = camr;
    this.uniforms.uFOV.value = this.mainCamera.getEffectiveFOV();
}

Text.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, false);
    this.animateCamera();

    var pos = TDEMO.SYNC.getObjPosition();
    /*this.teksti.position.x = pos.x;
    this.teksti.position.y = pos.y;
    this.teksti.position.z = pos.z;*/

    var rot = TDEMO.SYNC.getObjRotation();
    /*this.teksti.rotation.x = rot.x;
    this.teksti.rotation.y = rot.y;
    this.teksti.rotation.z = rot.z;*/

    for( var i = 0; i < this.ground.geometry.vertices.length; i++ ){
        this.ground.geometry.vertices[i].z = Math.random()*20.0;
    }
    this.ground.geometry.verticesNeedUpdate = true;

    this.uniforms.uTime.value = elapsedTime;

    var hb = TDEMO.SYNC.getHeartBeat();
    this.texture.offset.x = hb*1.5;
    this.texture.offset.y = hb;
    this.texture.needsUpdate = true;

    this.renderDepthScene();
};

Text.prototype.createText = function(paragraphs){

    var texts = new THREE.Object3D();

    var material = [
        new THREE.MeshLambertMaterial({
            color : 0xFF00FF,
            emissive : 0x00FF00,
            emissiveIntensity : 0.8
        }),
        new THREE.MeshLambertMaterial({
            color : 0x00FF00,
            emissive : 0xFF00FF,
            emissiveIntensity : 0.8
        })
    ];

    var options = {
        font: TDEMO.font,
        size: 4,
        height: 4,
        curveSegments: 12,
        bevelEnabled: true,
        bevelThickness: 1,
        bevelSize: 0.5,
        bevelSegments: 5
    };

    var rowHeight = 6;
    var yPos = 4;
    var zPos = 0;

    for(var i = 0; i < paragraphs.length; ++i){
        var geometry = new THREE.TextGeometry(paragraphs[i], options);
        geometry.computeBoundingBox();
        geometry.computeVertexNormals();
        var centerOffset = -0.5*(geometry.boundingBox.max.x-geometry.boundingBox.min.x);
        
        var mesh = new THREE.Mesh(geometry, material);
        mesh.position.x = centerOffset;
        mesh.position.y = yPos - rowHeight*i;
        mesh.position.z = zPos*i;

        texts.add(mesh);
    }
    return texts;
};


Text.prototype.createCubes = function(){

    var env_map = TDEMO.TEXTURES.getTextures().maa_env;

    var material = new THREE.MeshLambertMaterial({
        color : 0xFF00FF,
        emissive : 0x00FF00,
        emissiveIntensity : 0.5,
        envMap : env_map
    });
    
    var geometry = new THREE.BoxGeometry(10, 10, 10);
    
    var gridRight = new THREE.Object3D();
    var gridLeft = new THREE.Object3D();
    
    var x = -200;
    var z = -580;
    var defx = x;
    var deltaX = 20;
    var deltaZ = 20;
    
    for(var i = 0; i < 1200; ++i){
        var obj = new THREE.Mesh(geometry, material);
        obj.position.x = x;
        obj.position.z = z;

        obj.position.y = (((Math.sin(x)+1)+(Math.cos(z)+1))*5)+((i+0.5)/1200);
        obj.rotation.y = Math.PI*obj.position.y*0.5;
        
        gridRight.add(obj);
        gridLeft.add(obj.clone());
        
        x += deltaX;
        if((i+1)%20 === 0){
            x = defx;
            z += deltaZ;
        }
    }
    
    gridLeft.position.x = -180;
    gridRight.position.x = 180;
    
    var grid = new THREE.Object3D();
    grid.add(gridRight);
    grid.add(gridLeft);
    
    return grid;
};

Text.prototype.createHeightMap = function(){
    var geometry = new THREE.PlaneGeometry(1200, 1200, 180, 180);
    var env_map = TDEMO.TEXTURES.getTextures().taivas_env;
    var material = new THREE.MeshLambertMaterial({
        color : 0xFF00FF,
        emissive : 0x00FF00,
        emissiveIntensity : 0.5,
        envMap : env_map,
        side : THREE.DoubleSide
    });

    /*var material = new THREE.MeshBasicMaterial({
        color : 0xFFFFFF
    });*/

    for( var i = 0; i < geometry.vertices.length; i++ ){
        geometry.vertices[i].z = Math.random()*20.0;
    }
    geometry.verticesNeedUpdate = true;
    
    var ground = new THREE.Mesh( geometry, material );
    ground.rotation.x = -Math.PI/2;
    
    return ground;
};

Text.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(80, 128, 128);
    this.texture = TDEMO.TEXTURES.getTextures().taivas;
    var material = new THREE.MeshLambertMaterial({
        side : THREE.DoubleSide,
        map : this.texture,
        color : 0x00FF00,
        emissive : 0xFF00FF,
    });
    
    var sky = new THREE.Mesh(geometry, material);
    return sky;
};