var Kalat = function(){
    PartBase.call(this);
    this.setEdgeDetection();
    this.setBloom(2);

    this.texture = TDEMO.TEXTURES.getTextures().kalat_lila;
    var material = new THREE.MeshBasicMaterial({map: this.texture, side: THREE.BackSide});
    var geometry = new THREE.BoxGeometry(100, 100, 100);
    this.box = new THREE.Mesh(geometry, material);
    //this.box.rotation.x = -Math.PI/2;

    this.scene.add(this.box);
};


Kalat.prototype = PartBase.prototype.inheritance();

Kalat.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var pos = TDEMO.SYNC.getObjPosition();
    this.box.position.x = pos.x;
    this.box.position.y = pos.y;
    this.box.position.z = pos.z;

    var rot = TDEMO.SYNC.getObjRotation();
    this.box.rotation.x = rot.x;
    this.box.rotation.y = rot.y;
    this.box.rotation.z = rot.z;

    var hb = TDEMO.SYNC.getHeartBeat();
    this.texture.offset.x = hb*1.5;
    this.texture.offset.y = hb;
    this.texture.needsUpdate = true;
};
