#version 150

uniform float time;

in VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} inData;

out vec4 fragColor;

float sat(float x) { return clamp(x, 0., 1.); }
float demix(float a, float b, float t) { return (t - a) / (b - a); }

void main(void)
{
    vec2 uv = -1. + 2. * inData.v_texcoord;
    uv.x /= 1.77;

    uv *= .3;

    float t = mix(0., 1., sat(demix(0., 5., time)));

    float idx = floor(uv.y*10.);
    float udx = fract(uv.y*10.);

    vec3 col = sin(t)+.5 + 1.5 * sin((vec3(.0,.33,.67) + udx) * 6.28);

    //col *= step(abs(uv.x - .1), .5);

    float xpos = mix(-1., 1., pow(sat(demix(1., 2., time - idx * .1)), .3));
    col *= step(uv.x, xpos);
    col *= mod(idx, 2.);

    fragColor = vec4(col, 1.0);

    float fade = mix(1., 0., smoothstep(2., 2.5, time));
    fragColor*= fade;
}
