#version 150

uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform vec3 spectrum;
uniform mat4 mvp;
uniform sampler2D passA;

in vec4 a_position;
in vec3 a_normal;
in vec2 a_texcoord;

out VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} outData;

mat2 rot(float t) {
    float c = cos(t), s = sin(t);
    return mat2(c, s, -s, c);
}

void march(inout vec3 p, inout vec3 n, float r, float a) {
    vec3 c = p + r * n;
    mat2 m = rot(a * sign(r));
    p -= c;
    p.xy *= m;
    n.xy *= m;
    p += c;
}

vec3 map(float t)
{
    if (t < 0.2) return vec3(.6, 3.14/2., .2);
    if (t < 0.4) return vec3(-.3, 1.6*3.14, .4 + mix(-.4, .0, fract(time)));
    return vec3(.6, 3.14, .5);
}

const float instanceCount = 120;
void recmarch(inout vec3 p, inout vec3 n, int idx, int offset)
{
    float speed = 0.2;
    float fl = floor(mix(.2, 1., idx/instanceCount) + time * speed);
    float cx = clamp(mix(.2, 1., (idx + offset)/instanceCount) + time * speed - fl, 1./instanceCount, 1);
    n = vec3(0.,-1.,0.);
    p = vec3(0.);
    float t = 0.;
    for (int i = 0 ; i < 20 ; ++i) {
        vec3 s = map(t);
        s.y *= min((cx - t) / s.z, 1.0);
        march(p, n, s.x, s.y);
        t += s.z;
        if (t > cx) break;
    }
}

void main(void)
{
    vec2 part = texture(passA, vec2(gl_InstanceID/120.,0.)).xy;
    
    vec3 c0, n0;
    recmarch(c0, n0, gl_InstanceID, 0);
    vec3 c1, n1;
    recmarch(c1, n1, gl_InstanceID, 1);
    
    float fy = a_position.y*.5+.5;
    vec3 n = mix(n0, n1, fy);
    vec3 c = mix(c0, c1, fy);

    vec4 p = a_position;
    //p = mix(p-vec4(.5,.0,.0,0.), p, a_position.y);
    part = (c + n * a_position.x*.1).xy;
    //p.xz *= rot(1.*time);
    p.x *= 1.;
    p.xy *= rot(-atan(n.y, n.x));
    p.xyz *= .02;
    p.xy = part.xy;

    p.xyz *= 2.;

    gl_Position = mvp * p;
    outData.v_position = p;
    outData.v_normal = a_normal;
    outData.v_texcoord = vec2((gl_InstanceID+a_position.y*.5+.5)/instanceCount,a_position.x*.5+.5);
}

