#version 150

uniform float time;

in VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} inData;

out vec4 fragColor;

float sat(float x) { return clamp(x, 0., 1.); }
float demix(float a, float b, float t) { return (t - a) / (b - a); }

float fill(float d) { return smoothstep(.01, .0, d); }

void main(void)
{
    vec2 uv = -1. + 2. * inData.v_texcoord;
    uv.y *= 1.77;
    vec2 uv0 = uv;

	uv = uv0;
	uv -= vec2(.85, -1.3);
	uv *= 8.;
    float d = max(abs(uv.x * 2.) - .5, abs(uv.y * .35 + uv.x * .1) - .5);
    d = max(d, -max(abs(uv.x * 3.) - .5, abs(.9 + uv.y * 1.5 + uv.x * .1) - .5));
    d = max(d, -max(abs(uv.x * 3.) - .5, abs(-.6 + uv.y * 1.2 + uv.x * .1) - .5));
    d = min(d, max(abs(uv.x * 3.) - .5, abs(-5.5 + uv.y * 2.5 - uv.x * 2.5) - .5) * .1);
    uv = uv0;
    float r2 = step(.85, uv.x) * step(uv.x, .86) * step(-1.6, uv.y) * step(uv.y, -1.3);
    vec3 col = vec3(1.) * fill(d);

    fragColor = vec4(col, 1.0);

    float fade = mix(1., 0., smoothstep(.5, .8, time));
    fade *= step(.5, time);
    fragColor*= fade;
}
