#version 330 core

#define M_PI 3.1415926535897932384626433832795
#define BG_CIRCLES 1
#define BG_SPOT 2
#define BG_SPIRAL 3

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(1,1,1,1);

uniform float iTime = 1.0;
uniform float speed = 1.0;
uniform float fade = 0.1;
uniform vec2 position = vec2(-0.5, -0.5);
uniform vec4 backgroundColor = vec4(0,0,0,0);

uniform int background = BG_SPIRAL;

//BG_SPIRAL uniforms
uniform float curveThickness = 0.6;
uniform float curveBendDegrees = 70;
uniform float curvesDegrees = 90;

uniform float r = 1.0;
uniform float g = 1.0;
uniform float b = 1.0;

void main()
{
    vec2 coord=texCoord.xy;

    float time = iTime * speed;

    float x = coord.x;
    float y = coord.y;
    float d = sqrt(x*x + y*y);

    vec4 color1 = backgroundColor;
    if (background == BG_CIRCLES)
    {
        x = position.x+coord.x;
        y = position.y+coord.y;
        d = sqrt(x*x + y*y);
        d = sin(d*40)*5;
        color1 = vec4(d);
    }
    else if (background == BG_SPOT)
    {
        float cx = position.x+x;
        float cy = position.y+y;
        float circle = 1.0/sqrt(cx*cx + cy*cy);

        d = 0;
        //if (circle > 3.0)
        {
            float size = 1.5-sqrt(cx*cx + cy*cy)*(10*sin(time*3));
            d = sin(sqrt(x*x)*100)*1.5*size+cos(sqrt(y*y)*100)*1.2*size;
        }
        color1 = vec4(d);
    }
    else if (background == BG_SPIRAL)
    {
        coord += position;
        float curveBendRad = radians(curveBendDegrees);
        float curvesRad = radians(curvesDegrees);
        float bend = curveBendRad*log(length(coord));
        float d = mod((time*2.5)+atan(coord.x,coord.y)+bend, curvesRad);
        if (d < curvesRad*curveThickness)
        {
            float cx = position.x+x;
            float cy = position.y+y;
            float circle = 1.0/sqrt(cx*cx + cy*cy);

            float d2 = 0;
            float size = 1.5-sqrt(cx*cx + cy*cy)*(10*sin(time*5.5));
            d2 = sin(sqrt(x*x)*80)*1.5*size+cos(sqrt(y*y)*80)*1.2*size;
            d += 0.15*d2;

            color1 = vec4(1-d*0.1);
            color1.a *= 0.75;

        }


    }

    fragColor = clamp(vec4(color1.r*sin(mod(time,10)*x+y),color1.g*cos(mod(time,10)*y+x),color1.b+sin(mod(time,10)*x*y),color1.a) * color, vec4(0), vec4(1)) * vec4(r,g,b,1.0);
}
