// https://github.com/sparkfun/H2OhNo/blob/master/firmware/BasicBeep/BasicBeep.ino
// Auto sample player - http://www.technoblogy.com/show?QBB

#define u8   unsigned char
#define u16   unsigned short
#define s8 signed char 
#define s16  signed short
#define u32 unsigned long

#include <avr/power.h>
#include <avr/io.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/portpins.h>
#include <inttypes.h>

#include <avr/sleep.h>
#define adc_disable()  (ADCSRA &= ~(1<<ADEN))


// Define pins
#define PIN_LED1    PB0
#define PIN_LED2    PB1
#define PIN_LED4    PB4

// write digital "high" to pin <pn> on port <prt>
#define DIGIWRITE_H(prt, pn) prt |= (1<<pn)

// write digital "low" to pin <pn> on port <prt>
#define DIGIWRITE_L(prt, pn) prt &= ~(1<<pn)

#include "song_lft.h"

//RAM 13
volatile u8 callbackwait;
volatile u8 lastsample;
volatile u8 timetoplay;

u8 trackwait;
u8 trackpos;
u8 playsong;
u8 songpos;

u32 noiseseed = 1;
u8 light[2];
// RAM 165

// 2khz
/*
const u16 freqtable[] = {
 0x0214, 0x0234, 0x0258, 0x027C, 0x02A0, 0x02C8, 0x02F4, 0x0320, 0x0350,
  0x0384, 0x03B8, 0x03F0, 0x042C, 0x046C, 0x04B0, 0x04F8, 0x0544, 0x0594,
  0x05E8, 0x0644, 0x06A4, 0x0708, 0x0774, 0x07E4, 0x085C, 0x08DC, 0x0964,
  0x09F4, 0x0A8C, 0x0B2C, 0x0BD4, 0x0C88, 0x0D48, 0x0E14, 0x0EE8, 0x0FCC,
  0x10BC, 0x11BC, 0x12C8, 0x13E8, 0x1518, 0x1658, 0x17AC, 0x1914, 0x1A94,
  0x1C28, 0x1DD4, 0x1F98, 0x217C, 0x2378, 0x2594, 0x27D0, 0x2A30, 0x2CB0,
  0x2F58, 0x322C, 0x3528, 0x3850, 0x3BA8, 0x3F34, 0x42F8, 0x46F4, 0x4B2C,
  0x4FA4, 0x5460, 0x5964, 0x5EB4, 0x6458, 0x6A50, 0x70A0, 0x7754, 0x7E6C,
  0x85F0, 0x8DE8, 0x9658, 0x9F4C, 0xA8C4, 0xB2CC, 0xBD6C, 0xC8B0, 0xD4A0,
  0xE144, 0xEEAC, 0xFCDC
};
*/

// 3.5
/*
const u16 freqtable[] = {

0x01D2, 0x01EE, 0x020E, 0x022C, 0x024C, 0x0270, 0x0296, 0x02BC, 0x02E6, 0x0314, 0x0342, 0x0372, 0x03A6, 0x03DE, 0x041A, 0x045A, 0x049C, 0x04E2, 0x052C, 0x057C, 0x05D0, 0x0628, 0x0686, 0x06E8, 0x0750, 0x07C0, 0x0838, 0x08B6, 0x093A, 0x09C6, 0x0A5A, 0x0AF8, 0x0BA0, 0x0C52, 0x0D0C, 0x0DD2, 0x0EA4, 0x0F84, 0x1070, 0x116C, 0x1276, 0x138E, 0x14B6, 0x15F2, 0x1742, 0x18A4, 0x1A1A, 0x1BA6, 0x1D4C, 0x1F0A, 0x20E2, 0x22D6, 0x24EA, 0x271A, 0x296E, 0x2BE6, 0x2E84, 0x3146, 0x3434, 0x374E, 0x3A9A, 0x3E16, 0x41C6, 0x45B0, 0x49D4, 0x4E38, 0x52DE, 0x57CE, 0x5D06, 0x628C, 0x686A, 0x6E9E, 0x7532, 0x7C2C, 0x838E, 0x8B62, 0x93AC, 0x9C72, 0xA5BE, 0xAF9A, 0xBA0C, 0xC51C, 0xD0D6, 0xDD40

};
  */


// x3 

const u16 freqtable[] = {
  0x0190, 0x01A8, 0x01C2, 0x01DE, 0x01F8, 0x0216, 0x0238, 0x0258, 0x027C,
  0x02A4, 0x02CA, 0x02F4, 0x0322, 0x0352, 0x0384, 0x03BA, 0x03F4, 0x0430,
  0x046E, 0x04B4, 0x04FC, 0x0546, 0x0598, 0x05EC, 0x0646, 0x06A6, 0x070C,
  0x0778, 0x07EA, 0x0862, 0x08E0, 0x0966, 0x09F6, 0x0A90, 0x0B2E, 0x0BDA,
  0x0C8E, 0x0D4E, 0x0E16, 0x0EEE, 0x0FD2, 0x10C2, 0x11C2, 0x12D0, 0x13F0,
  0x151E, 0x1660, 0x17B2, 0x191E, 0x1A9A, 0x1C30, 0x1DDC, 0x1FA4, 0x2184,
  0x2382, 0x25A2, 0x27DE, 0x2A3C, 0x2CBE, 0x2F68, 0x323A, 0x3538, 0x3862,
  0x3BBC, 0x3F48, 0x430C, 0x4708, 0x4B42, 0x4FBC, 0x5478, 0x5980, 0x5ED2,
  0x6474, 0x6A6E, 0x70C2, 0x777A, 0x7E94, 0x861A, 0x8E12, 0x9684, 0x9F78,
  0xA8F4, 0xB302, 0xBDA6,
};


// x 2.5
/*
const u16 freqtable[] = {
0x014C, 0x0160, 0x0178, 0x018E, 0x01A4, 0x01BE, 0x01D8, 0x01F4, 0x0212, 0x0232, 0x0254, 0x0276, 0x029C, 0x02C4, 0x02EE, 0x031C, 0x034A, 0x037C, 0x03B2, 0x03EA, 0x0426, 0x0466, 0x04A8, 0x04EE, 0x053A, 0x058A, 0x05DE, 0x0638, 0x0698, 0x06FC, 0x0764, 0x07D6, 0x084E, 0x08CC, 0x0952, 0x09E0, 0x0A76, 0x0B16, 0x0BBE, 0x0C72, 0x0D30, 0x0DF8, 0x0ECC, 0x0FAC, 0x109C, 0x119A, 0x12A4, 0x13C0, 0x14EE, 0x162C, 0x177C, 0x18E2, 0x1A5E, 0x1BEE, 0x1D98, 0x1F5C, 0x213A, 0x2332, 0x254A, 0x2780, 0x29DC, 0x2C58, 0x2EFC, 0x31C6, 0x34BC, 0x37DE, 0x3B30, 0x3EB8, 0x4272, 0x4664, 0x4A94, 0x4F04, 0x53B6, 0x58B2, 0x5DF8, 0x6390, 0x697A, 0x6FC0, 0x7664, 0x7D6E, 0x84E4, 0x8CCA, 0x952C, 0x9E0A
};
*/

/* x2 4khz
const u16 freqtable[] = {
  //const  prog_uint16_t freqtable[] PROGMEM= {
  0x010b, 0x011b, 0x012c, 0x013e, 0x0151, 0x0165, 0x017a, 0x0191, 0x01a9,
  0x01c2, 0x01dd, 0x01f9, 0x0217, 0x0237, 0x0259, 0x027d, 0x02a3, 0x02cb,
  0x02f5, 0x0322, 0x0352, 0x0385, 0x03ba, 0x03f3, 0x042f, 0x046f, 0x04b2,
  0x04fa, 0x0546, 0x0596, 0x05eb, 0x0645, 0x06a5, 0x070a, 0x0775, 0x07e6,
  0x085f, 0x08de, 0x0965, 0x09f4, 0x0a8c, 0x0b2c, 0x0bd6, 0x0c8b, 0x0d4a,
  0x0e14, 0x0eea, 0x0fcd, 0x10be, 0x11bd, 0x12cb, 0x13e9, 0x1518, 0x1659,
  0x17ad, 0x1916, 0x1a94, 0x1c28, 0x1dd5, 0x1f9b, 0x217c, 0x237a, 0x2596,
  0x27d3, 0x2a31, 0x2cb3, 0x2f5b, 0x322c, 0x3528, 0x3851, 0x3bab, 0x3f37,
  0x42f9, 0x46f5, 0x4b2d, 0x4fa6, 0x5462, 0x5967, 0x5eb7, 0x6459, 0x6a51,
  0x70a3, 0x7756, 0x7e6f
};
*/

/* x1 = highest quality 8Khz
const u16 freqtable[] = {
 //const  prog_uint16_t freqtable[] PROGMEM= {
 0x0085, 0x008d, 0x0096, 0x009f, 0x00a8, 0x00b2, 0x00bd, 0x00c8, 0x00d4,
 0x00e1, 0x00ee, 0x00fc, 0x010b, 0x011b, 0x012c, 0x013e, 0x0151, 0x0165,
 0x017a, 0x0191, 0x01a9, 0x01c2, 0x01dd, 0x01f9, 0x0217, 0x0237, 0x0259,
 0x027d, 0x02a3, 0x02cb, 0x02f5, 0x0322, 0x0352, 0x0385, 0x03ba, 0x03f3,
 0x042f, 0x046f, 0x04b2, 0x04fa, 0x0546, 0x0596, 0x05eb, 0x0645, 0x06a5,
 0x070a, 0x0775, 0x07e6, 0x085f, 0x08de, 0x0965, 0x09f4, 0x0a8c, 0x0b2c,
 0x0bd6, 0x0c8b, 0x0d4a, 0x0e14, 0x0eea, 0x0fcd, 0x10be, 0x11bd, 0x12cb,
 0x13e9, 0x1518, 0x1659, 0x17ad, 0x1916, 0x1a94, 0x1c28, 0x1dd5, 0x1f9b,
 0x217c, 0x237a, 0x2596, 0x27d3, 0x2a31, 0x2cb3, 0x2f5b, 0x322c, 0x3528,
 0x3851, 0x3bab, 0x3f37
 };
*/

// RAM 64
//const  prog_char  sinetable[] PROGMEM = {
const s8 sinetable[] = {
  0, 12, 25, 37, 49, 60, 71, 81, 90, 98, 106, 112, 117, 122, 125, 126,
  127, 126, 125, 122, 117, 112, 106, 98, 90, 81, 71, 60, 49, 37, 25, 12,
  0, -12, -25, -37, -49, -60, -71, -81, -90, -98, -106, -112, -117, -122,
  -125, -126, -127, -126, -125, -122, -117, -112, -106, -98, -90, -81,
  -71, -60, -49, -37, -25, -12
};

// RAM 13
const u8 validcmds[] = "0dfijlmtvw~+=";

enum {
  WF_TRI,
  WF_SAW,
  WF_PUL,
  WF_NOI
};

// RAM 24
volatile struct oscillator {
  u16	freq;
  u16	phase;
  u16	duty;
  u8	waveform;
  u8	volume;	// 0-255
} 
osc[4];

struct trackline {
  u8	note;
  u8	instr;
  u8	cmd[2];
  u8	param[2];
};

struct track {
  struct trackline	line[TRACKLEN];
};

struct unpacker {
  u16	nextbyte;
  u8	buffer;
  u8	bits;
};


//RAM 22 per chan=  88 RAM
struct channel {
  struct unpacker		trackup;
  u8			tnum;
  s8			transp;
  u8			tnote;
  u8			lastinstr;
  u8			inum;
  u16			iptr;
  u8			iwait;
  u8			inote;
  s8			bendd;
  s16			bend;
  s8			volumed;
  s16			dutyd;
  u8			vdepth;
  u8			vrate;
  u8			vpos;
  s16			inertia;
  u16			slur;
} 
channel[4];

// RAM 32
//u16 resources[16 + MAXTRACK];

struct unpacker songup;

byte readsongbyte(u16 offset)
{
  return pgm_read_byte_near(&songdata[0] + offset); 
}

u16 readInt(u16 offset){
  // read back a 2-byte int

    return pgm_read_word_near(&freqtable[0] + offset);

}

void initup(struct unpacker *up, u16 offset) {
  up->nextbyte = offset;
  up->bits = 0;
}

u8 readbit(struct unpacker *up) {
  u8 val;

  if(!up->bits) {
    up->buffer = readsongbyte(up->nextbyte++);
    up->bits = 8;
  }

  up->bits--;
  val = up->buffer & 1;
  up->buffer >>= 1;

  return val;
}

u16 readchunk(struct unpacker *up, u8 n) {
  u16 val = 0;
  u8 i;
  for(i = 0; i < n; i++) {
    if(readbit(up)) {
      val |= (1 << i);
    }
  }
  return val;
}

void readinstr(byte num, byte pos, byte *dest) {
  //  dest[0] = readsongbyte(resources[num] + 2 * pos + 0);
  //  dest[1] = readsongbyte(resources[num] + 2 * pos + 1);
  dest[0] = readsongbyte(get_resources(num) + 2 * pos + 0);
  dest[1] = readsongbyte(get_resources(num) + 2 * pos + 1);
}

void runcmd(u8 ch, u8 cmd, u8 param) {
  switch(validcmds[cmd]) {
  case '0':
    channel[ch].inum = 0;
    break;
  case 'd':
    osc[ch].duty = param << 8;
    break;
  case 'f':
    channel[ch].volumed = param;
    break;
  case 'i':
    channel[ch].inertia = param << 1;
    break;
  case 'j':
    channel[ch].iptr = param;
    break;
  case 'l':
    channel[ch].bendd = param;
    break;
  case 'm':
    channel[ch].dutyd = param << 6;
    break;
  case 't':
    channel[ch].iwait = param;
    break;
  case 'v':
    osc[ch].volume = param;
    break;
  case 'w':
    osc[ch].waveform = param;
    break;
  case '+':
    channel[ch].inote = param + channel[ch].tnote - 12 * 4;
    break;
  case '=':
    channel[ch].inote = param;
    break;
  case '~':
    if(channel[ch].vdepth != (param >> 4)) {
      channel[ch].vpos = 0;
    }
    channel[ch].vdepth = param >> 4;
    channel[ch].vrate = param & 15;
    break;
  }
}

void playroutine() {			// called at 50 Hz
  u8 ch;
  u8 lights;

  OCR1B = LOW;


  if(playsong) {
    if(trackwait) {
      trackwait--;
    } 
    else {
      trackwait = 4;

      if(!trackpos) {
        if(playsong) {
          if(songpos >= SONGLEN) {
            playsong = 0;

            // End of data? Go to sleep
            adc_disable();
            sleep_enable();
            sleep_cpu();  // 1uA


          } 
          else {
            for(ch = 0; ch < 4; ch++) {
              u8 gottransp;
              u8 transp;

              gottransp = readchunk(&songup, 1);
              channel[ch].tnum = readchunk(&songup, 6);
              if(gottransp) {
                transp = readchunk(&songup, 4);
                if(transp & 0x8) transp |= 0xf0;
              } 
              else {
                transp = 0;
              }
              channel[ch].transp = (s8) transp;
              if(channel[ch].tnum) {
                //initup(&channel[ch].trackup, resources[16 + channel[ch].tnum - 1]);
                initup(&channel[ch].trackup, get_resources(16 + channel[ch].tnum - 1));
              }
            }
            songpos++;
          }
        }
      }

      if(playsong) {
        for(ch = 0; ch < 4; ch++) {
          if(channel[ch].tnum) {
            u8 note, instr, cmd, param;
            u8 fields;

            fields = readchunk(&channel[ch].trackup, 3);
            note = 0;
            instr = 0;
            cmd = 0;
            param = 0;
            if(fields & 1) note = readchunk(&channel[ch].trackup, 7);
            if(fields & 2) instr = readchunk(&channel[ch].trackup, 4);
            if(fields & 4) {
              cmd = readchunk(&channel[ch].trackup, 4);
              param = readchunk(&channel[ch].trackup, 8);
            }
            if(note) {
              channel[ch].tnote = note + channel[ch].transp;
              if(!instr) instr = channel[ch].lastinstr;
            }
            if(instr) {
              if(instr == 2) light[1] = 5;

              if(instr == 1) {
                light[0] = 5;
                if(channel[ch].tnum == 4) {
                  light[0] = light[1] = 3;
                }
              }

              if(instr == 7) {
                light[0] = light[1] = 30;
              }

              channel[ch].lastinstr = instr;
              channel[ch].inum = instr;
              channel[ch].iptr = 0;
              channel[ch].iwait = 0;
              channel[ch].bend = 0;
              channel[ch].bendd = 0;
              channel[ch].volumed = 0;
              channel[ch].dutyd = 0;
              channel[ch].vdepth = 0;
            }
            if(cmd) runcmd(ch, cmd, param);
          }
        }

        trackpos++;
        trackpos &= 31;
      }
    }
  }

  for(ch = 0; ch < 4; ch++) {
    s16 vol;
    u16 duty;
    u16 slur;

    while(channel[ch].inum && !channel[ch].iwait) {
      u8 il[2];

      readinstr(channel[ch].inum, channel[ch].iptr, il);
      channel[ch].iptr++;

      runcmd(ch, il[0], il[1]);
    }
    if(channel[ch].iwait) channel[ch].iwait--;

    if(channel[ch].inertia) {
      s16 diff;

      slur = channel[ch].slur;

      //diff = readInt(channel[ch].inote) - slur;
      diff = freqtable[channel[ch].inote] - slur;
      //diff >>= channel[ch].inertia;
      if(diff > 0) {
        if(diff > channel[ch].inertia) diff = channel[ch].inertia;
      } 
      else if(diff < 0) {
        if(diff < -channel[ch].inertia) diff = -channel[ch].inertia;
      }
      slur += diff;
      channel[ch].slur = slur;
    } 
    else {
      //slur = readInt(channel[ch].inote);
      slur = freqtable[channel[ch].inote];
    }

    osc[ch].freq =
      slur +
      channel[ch].bend +
      ((channel[ch].vdepth * sinetable[channel[ch].vpos & 63]) >> 2);
    //((channel[ch].vdepth * pgm_read_byte_near(&sinetable[0] + (channel[ch].vpos & 63))) >> 2);

    channel[ch].bend += channel[ch].bendd;
    vol = osc[ch].volume + channel[ch].volumed;
    if(vol < 0) vol = 0;
    if(vol > 255) vol = 255;
    osc[ch].volume = vol;

    duty = osc[ch].duty + channel[ch].dutyd;
    if(duty > 0xe000) duty = 0x2000;
    if(duty < 0x2000) duty = 0xe000;
    osc[ch].duty = duty;

    channel[ch].vpos += channel[ch].vrate;
  }


  lights = 0;
  if(light[0]) {
    light[0]--;
    lights |= 0x02;
    OCR1B = HIGH;  // PIN4
  }
  if(light[1]) {
    light[1]--;
    lights |= 0x10;
    
    //OCR1B = HIGH;  // PIN4
  }
}

void initresources() {
  initup(&songup, get_resources(0));
  //  initup(&songup, resources[0]);
}

u16 get_resources(u8 idx){
  return pgm_read_word_near(&resources[0] + idx);
}

#ifdef __AVR_ATtiny85__

void setup_timer() {
  // Enable 64 MHz PLL and use as source for Timer1
  PLLCSR = 1<<PCKE | 1<<PLLE;     

  // Set up Timer/Counter1 for PWM output

  TIMSK = 0;                              // Timer interrupts OFF
  TCCR1 = 1<<PWM1A | 2<<COM1A0 | 1<<CS10; // PWM A, clear on match, 1:1 prescale
  GTCCR = 1<<PWM1B | 2<<COM1B0;           // PWM B, clear on match
  OCR1A = 128; 
  OCR1B = 128;               // 50% duty at start

  // Set up Timer/Counter0 for 8kHz interrupt to output samples.
  TCCR0A = 3<<WGM00;                      // Fast PWM
  TCCR0B = 1<<WGM02 | 2<<CS00;            // 1/8 prescale (1,2)

  TIMSK = 1<<OCIE0A;                      // Enable compare match
  OCR0A = 187;//124, 186 (x3 @8Mhz),  217 (3.5), 248;                            // Divide by 1000

  //  set_sleep_mode(SLEEP_MODE_PWR_DOWN);
  pinMode(0, OUTPUT);
  pinMode(1, OUTPUT);
  pinMode(4, OUTPUT);
}
#endif


void setup(){
  //if (F_CPU == 16000000) clock_prescale_set(clock_div_1);

  
  
  int i;
  timetoplay = 0;
  trackwait = 0;
  trackpos = 0;
  playsong = 1;
  songpos = 0;

  osc[0].volume = 0;
  channel[0].inum = 0;
  osc[1].volume = 0;
  channel[1].inum = 0;
  osc[2].volume = 0;
  channel[2].inum = 0;
  osc[3].volume = 0;
  channel[3].inum = 0;

  initresources();

#ifdef __AVR_ATtiny85__
  setup_timer();
#endif  
}

void loop() {
  while(!timetoplay){
  };
  timetoplay--;
  playroutine();

}

ISR(TIMER0_COMPA_vect) {
  //void fillSample(){
   
    
  u8 i;

  s16 acc;
  u8 newbit;
  newbit = 0;

  OCR1A = lastsample&255;

  if(noiseseed & 0x80000000L) newbit ^= 1;
  if(noiseseed & 0x01000000L) newbit ^= 1;
  if(noiseseed & 0x00000040L) newbit ^= 1;
  if(noiseseed & 0x00000200L) newbit ^= 1;
  noiseseed = (noiseseed << 1) | newbit;

  if(callbackwait) {
    //callbackwait--;
    callbackwait--;
  } 
  else {
    timetoplay++;
    //timetoplay++;
    callbackwait = 60 - 1; //180, 90, 60(x3), 53(3.5), 45
  }
  
  
  // 217 timer, 3.5 freq,   53 callback wait = good 
  // 186 timer, 3 freq, 60 callback = better 


  acc = 0;


  for(i = 0; i < 4; i++) {
    s8 value; // [-32,31]

    switch(osc[i].waveform) {
    case WF_TRI:
      if(osc[i].phase < 0x8000) {
        value = -32 + (osc[i].phase >> 9);
      } 
      else {
        value = 31 - ((osc[i].phase - 0x8000) >> 9);
      }
      break;
    case WF_SAW:
      value = -32 + (osc[i].phase >> 10);
      break;
    case WF_PUL:
      value = (osc[i].phase > osc[i].duty)? -32 : 31;
      break;
    case WF_NOI:
      value = (noiseseed & 63) - 32;
      break;
    default:
      value = 0;
      break;
    }
    osc[i].phase += osc[i].freq;
    acc += value * osc[i].volume; // rhs = [-8160,7905]
  }

  lastsample = 128 + (acc >> 8);	// [1,251]

}




