#version 400

uniform float iGlobalTime;
uniform float width;
uniform float height;
uniform sampler2D message;

#define PI 3.14159265

float BPM = 134;
float sec_per_beat = 1.0 / (BPM/60);
//float t1 = 7;
float t1 = sec_per_beat * 4*4; // Intro (squares)
//float t2 = 8;
float t2 = sec_per_beat * 4*4; // Intro with synth (crazy fragment thing)
//float t3 = 15;
float t3 = sec_per_beat * (4*4 + 4*4); // Snare comes in, small changes at 16 (dominos 4x4, 4x4 morph)
//float t4 = 15;
float t4 = sec_per_beat * (4*4 + 2*7); // one 4x4 and then deadmau7 (squiggles)
//float t5 = 10;
float t5 = sec_per_beat * 4*7; // (donut guts)
//float t6a = 6.5;
float t6a = sec_per_beat * 2*7;
float t6b = 13.5;
float t6 = t6a + t6b;
float t7 = 100000;

float time = 0;

vec3 v_0 = vec3(0,0,0); // camera position

out vec4 outputColor;

float smoothstep(float edge0, float edge1, float x) {
  // Scale, bias and saturate x to 0..1 range
  x = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0); 
  // Evaluate polynomial
  return x * x * (3 - 2 * x);
}

float rand(vec2 c){
	return fract(sin(dot(c.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float noise(vec2 p, float freq ){
	//float unit = screenWidth/freq;
    float unit = 1.0;
	vec2 ij = floor(p/unit);
	vec2 xy = mod(p,unit)/unit;
	//xy = 3.*xy*xy-2.*xy*xy*xy;
	xy = .5*(1.-cos(PI*xy));
	float a = rand((ij+vec2(0.,0.)));
	float b = rand((ij+vec2(1.,0.)));
	float c = rand((ij+vec2(0.,1.)));
	float d = rand((ij+vec2(1.,1.)));
	float x1 = mix(a, b, xy.x);
	float x2 = mix(c, d, xy.x);
	return mix(x1, x2, xy.y);
}

float pNoise(vec2 p, int res){
	float persistance = .5;
	float n = 0.;
	float normK = 0.;
	float f = 4.;
	float amp = 1.;
	int iCount = 0;
	for (int i = 0; i<50; i++){
		n+=amp*noise(p, f);
		f*=2.;
		normK+=amp;
		amp*=persistance;
		if (iCount == res) break;
		iCount++;
	}
	float nf = n/normK;
	return nf*nf*nf*nf;
}

mat4 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
                0.0,                                0.0,                                0.0,                                1.0);
}

// start_value before start time, end_value after end time, linear slope from start_value to end_value in between
float knee(float t, float start_time, float start_value, float end_time, float end_value){
    float length = (end_time - start_time);
    float k = (end_value - start_value) / length; // Slope
    float s = max(0.0,min((t - start_time) / length, 1.0)); // 0 at start, 1 at end
    return start_value + k*(s * length);
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return length(max(d,0.0))
         + min(max(d.x,max(d.y,d.z)),0.0); // remove this line for an only partially signed sdf 
}


float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float opTx( vec3 p, mat4 m )
{
    vec3 q = (inverse(m)*vec4(p,1)).xyz;
    return sdBox(q,vec3(1,2,1));
}

vec3 opTwist(in vec3 p, float d)
{
    //const float k = 10.0; // or some other amount
    float k = d;
    float c = cos(k*p.y);
    float s = sin(k*p.y);
    mat2  m = mat2(c,-s,s,c);
    vec3  q = vec3(m*p.xz,p.y);
    return q;
}

float sdCappedCylinder( vec3 p, float h, float r )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - vec2(h,r);
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

vec3 displace(vec3 p, float d){
    return p + sin(d*p.x)*sin(d*p.y)*sin(d*p.z);
}

float cylinder_scene(vec3 p){
    vec3 rep = vec3(5,5,5);
    p += rep / 2.0;
    p = mod(p,rep)-0.5*rep; // Repeat
    return max(-sdCappedCylinder(p,1.1,0.3), sdCappedCylinder(p,1.0,0.5));
}

float rectangle_scene(vec3 p){
    vec3 rep = vec3(5,5,5);
    p += rep / 2.0;
    p = mod(p,rep)-0.5*rep; // Repeat
    return max(-sdBox(p, vec3(1.8, 1.8, 0.11)),sdBox(p, vec3(2.0,2.0,0.1)));
}

float torus_scene(vec3 p){
    p.x += 2;
    p.y += 2;
    vec3 rep = vec3(5,5,5);
    p += rep / 2.0;
    p = mod(p,rep)-0.5*rep; // Repeat
    return sdTorus(p, vec2(2.5 + sin(iGlobalTime)*0.10,0.3 + cos(iGlobalTime) * 0.05));
}

float scene1(vec3 p, float t){
    return rectangle_scene(p);
}

float scene2(vec3 p, float t){
    float d = min(5.0, 10 + cos(t * 0.5 + PI)*10);
    p = displace(p,d);
    return rectangle_scene(p);
}

float scene3(vec3 p, float t){
    float d = 10 + cos(t * 0.15)*10;
    p = displace(p,d);
    return cylinder_scene(p);
}


float scene4(vec3 p, float t){
    float d = 10 + cos(t3 * 0.15)*10 + sin(t) * 0.1;
    p = displace(p,d);
    return cylinder_scene(p);
}

float scene5(vec3 p, float t){
    float d = t;
    p.y += sin(t + p.x);
    p.x += sin(t + p.z);
    return torus_scene(p);
}

float scene6(vec3 p, float t){
    //float s1 = -sdSphere(p - v_0,50);
    //p -= v_0; // Camera to origin

    //float s1 = sdSphere(mod(p,vec3(20,20,20)) - vec3(20,20,20)/2, sin(time)*5 + 5);
    //float s1 = -(p.y-20);

    // Twist


    //p.y += sin(1*p.x)*sin(1*p.y)*sin(5*p.z) * 1.0;
    p += pNoise(p.xz + vec2(0, 0), 2)*(-2) - 0.0 * sin(p.x / 10);
    float bend = 0;
    if(t > t6a){
        bend = (t - t6a) * 0.001;
        if(t > t6a + t6b / 2.0) bend -= (t - (t6a + t6b / 2.0)) * 0.001 * 2;
    }
    p.y -= (p.z - v_0.z) * (p.z - v_0.z) * bend;
    
    //float s1 = sdSphere(p - v_0 - vec3(0,0,10), sin(time)*0 + 5);
    
    float s2 = p.y + 5 + (t/t6) * 10;
    //float s2 = -sdBox(p, vec3(100000,10.0,100000));
    return s2;
    //return s1;
    //return min(s1,s2);
}

float scene7(vec3 p, float t){

    float t2 = 0;
    if(t > 4) t2 = t-4;
    if(t2 > 13) t2 = max(0.0,13-(t2-13));
    float k = 0.0007*pow(t2,1.2);
    
    float mix = smoothstep(0,20,t) * (1 - smoothstep(0,20,t));
    k = 0.05 * mix;
    float c = cos(k*p.z);
    float s = sin(k*p.z);
    mat2  m = mat2(c,-s,s,c);
    p = vec3(m*p.xy,p.z);

    //p.y += sin(1*p.x)*sin(1*p.y)*sin(5*p.z) * 1.0;
    p += pNoise(p.xz + vec2(0, 0), 2)*(-2);// - 0.9 * sin(p.x / 100);
    if(t > t6a){
        //p.y -= (p.z - v_0.z) * (p.z - v_0.z) * ((t - 8) * 0.001);
    }
    
    //float s1 = sdSphere(p - v_0 - vec3(0,0,10), sin(time)*0 + 5);
    
    if(t > 20){
        float bend;
        bend = -sin((min(t,55)-20)/3)*0.02;
        //if(t > 55) bend = 1*0.02;
        p.y += (p.x - 0.1*v_0.x) * (p.x - 0.1*v_0.x) * bend;
    }

    float s2 = p.y+15;
    return s2;
    //float s2 = -sdBox(p, vec3(100000,10.0,100000));
    //return max(-s1,s2);
}

float part1_sdf(vec3 p){
    //p = displace(p);
    //float time = iGlobalTime;
    if(time < t1) return scene1(p, time);
    else if(time < t1 + t2) return scene2(p, time - t1);
    else if(time < t1 + t2 + t3) return scene3(p, time - t1 - t2);
    else if(time < t1 + t2 + t3 + t4) return scene4(p, time - t1 - t2 - t3);
    else if(time < t1 + t2 + t3 + t4 + t5){
        //float s1 = scene4(p, time - t1 - t2 - t3);
        float s2 = scene5(p, time - t1 - t2 - t3 - t4);
        return s2;
        //float blend = knee(iGlobalTime, t1+t2+t3+t4, 1, t1+t2+t3+t4+0.05, 0);
        //return s1 * blend + s2 * (1-blend);
        
    } else
        return 0.0;

}

float part2_sdf(vec3 p){
    if(time < t6) return scene6(p, time);
    else if(time < t6 + t7) return scene7(p,time - t6);
    else return 0.0;
}

vec3 get_normal_part1(vec3 pos)
{
	vec3 eps = vec3(0.01,0,0);
	return normalize(vec3(
		part1_sdf(pos + eps.xyy) - part1_sdf(pos - eps.xyy),
		part1_sdf(pos + eps.yxy) - part1_sdf(pos - eps.yxy),
		part1_sdf(pos + eps.yyx) - part1_sdf(pos - eps.yyx)
	));
}

vec3 get_normal_part2(vec3 pos)
{
	vec3 eps = vec3(0.01,0,0);
	return normalize(vec3(
		part2_sdf(pos + eps.xyy) - part2_sdf(pos - eps.xyy),
		part2_sdf(pos + eps.yxy) - part2_sdf(pos - eps.yxy),
		part2_sdf(pos + eps.yyx) - part2_sdf(pos - eps.yyx)
	));
}

// Clamped dot
float cdot(vec3 a, vec3 b){
    return max(0.0,dot(a,b));
}

vec3 filmicToneMapping(vec3 color)
{
	color = max(vec3(0.), color - vec3(0.004));
	color = (color * (6.2 * color + .5)) / (color * (6.2 * color + 1.7) + 0.06);
	return color;
}

vec3 gamma(vec3 c) {
	return pow(c, vec3(1.6/2.2));
}

void part1(){

    vec2 fragCoord = gl_FragCoord.xy;
    // Fix coordinate system
    float aspect_ratio = 16.0/9.0;
    //float aspect_ratio = 1.0;
	vec2 pixel_pos = fragCoord.xy / vec2(width,height); // [0,1]
    pixel_pos -= vec2(0.5,0.5); // [-1/2, 1/2]
    pixel_pos *= vec2(2,2); // [-1,1]
    pixel_pos.x *= aspect_ratio;
    
    float speed = 5.65;
    //vec3 v_0 = vec3(cos(0.5*time)*10.0,sin(0.5*time)*15.0, 10.0); // Camera position
    v_0 = vec3(0.0,0.0,-10.0 + time * speed); // Camera pos

    //v_0 = vec3(0,0,0); // debug
    float roll = time*0.1;
    mat4 camera_roll = rotationMatrix(vec3(0,0,-1), roll);
    mat4 camera_pitch = rotationMatrix(vec3(1,0,0), 0.0);
    mat4 camera_yaw = rotationMatrix(vec3(0,1,0), 3.14159);
    
    // Raymarch
    vec3 ray = normalize(vec3(pixel_pos.x, pixel_pos.y,-1));
    ray = (camera_yaw * camera_pitch * camera_roll * vec4(ray,1)).xyz;
    
    vec3 pos = v_0;
    const int nsteps = 50;
    const float stepsize = 0.98;
    for(int step = 0; step < nsteps; step++){
        pos += ray * abs(part1_sdf(pos))*stepsize;
    }
    
    // Phong: k_s * cos(alpha)^q * intensity / r^2
    float sun_intensity = 5.0 + 3.0 * sin(time);
    vec3 background = vec3(0.01,0.01,0.01);
    //vec3 sun = vec3(30.0 * sin(iGlobalTime),20,30.0*cos(iGlobalTime));
    //vec3 sun = v_0 + vec3(0,10,-20);
    vec3 sun = v_0;
    float k_s = 1.0; // Specular coefficient
    float q = 2.0; // Specular exponent
    
    vec3 diffuse_color = vec3(0.2,0.8,0.4);
    vec3 ambient_color = vec3(0.6,1,0.6);
    vec3 specular_color = vec3(0.7,1,0.7);
    
    if(part1_sdf(pos) > 0.05) // No hit
        outputColor = vec4(background,1);
    else{
        vec3 surface = pos;
        vec3 normal = get_normal_part1(surface);
        vec3 l = surface - sun; // Sun to surface
        float intensity_at_surface = sun_intensity / dot(l,l); // Inverse square decay
        
    	vec3 l_prime = l + 2.0*dot(l,normal)*normal;
        vec3 to_camera = v_0 - surface;
        float cos_angle = cdot(-l_prime, to_camera)/(length(l_prime) * length(to_camera));
        vec3 specular = specular_color * k_s * pow(cos_angle,q) * intensity_at_surface;
        vec3 diffuse = diffuse_color * 0.2 * cdot(normal, -l) * intensity_at_surface;
        vec3 ambient = ambient_color * 0.01;
        vec3 light = vec3(clamp(diffuse + specular + ambient,0.0,1.0));
        float fogfactor = clamp(length(pos-v_0)/200.0,0.0,1.0);
        //fogfactor = 0.0;
        vec3 finallight = vec3(light.x, light.y, light.z);
        finallight = mix(finallight, background, fogfactor);
        finallight = gamma(filmicToneMapping(finallight));
        outputColor = vec4(finallight,1);
    }

}

void part2(){

    //time = 20 + mod(time,20);

    vec2 fragCoord = gl_FragCoord.xy;
    // Fix coordinate system
    float aspect_ratio = 16.0/9.0;
    //float aspect_ratio = 1.0;
	vec2 pixel_pos = fragCoord.xy / vec2(width,height); // [0,1]
    pixel_pos -= vec2(0.5,0.5); // [-1/2, 1/2]
    pixel_pos *= vec2(2,2); // [-1,1]
    pixel_pos.x *= aspect_ratio;
    
    //vec3 v_0 = vec3(cos(0.5*time)*10.0,sin(0.5*time)*15.0, 10.0); // Camera position
    v_0 = vec3(0.0,sin(time)+1,-10.0 + time * 13.0); // Camera pos
    if(time > t6a) v_0.z += (time - t6a) * (time - t6a) * 1.0;
    //v_0 = vec3(0,0,0); // debug
    float roll = 0.1 * sin(time);
    mat4 camera_roll = rotationMatrix(vec3(0,0,-1), roll);
    mat4 camera_pitch = rotationMatrix(vec3(1,0,0), 0.2);
    mat4 camera_yaw = rotationMatrix(vec3(0,1,0), 3.14159);
    
    // Raymarch
    vec3 ray = normalize(vec3(pixel_pos.x, pixel_pos.y,-1));
    ray = (camera_yaw * camera_pitch * camera_roll * vec4(ray,1)).xyz;
    
    vec3 pos = v_0;
    const int nsteps = 150;
    const float stepsize = 0.4;
    for(int step = 0; step < nsteps; step++){
        pos += ray * part2_sdf(pos)*stepsize;
    }
    
    // Phong: k_s * cos(alpha)^q * intensity / r^2
    float sun_intensity = 100.0 + 3.0 * sin(time);
    vec3 background = vec3(0.01,0.01,0.01);
    //vec3 sun = vec3(30.0 * sin(iGlobalTime),20,30.0*cos(iGlobalTime));
    //vec3 sun = v_0 + vec3(0,10,-20);

    float k_s = 2.0; // Specular coefficient
    float q = 2.0; // Specular exponent
    
    vec3 diffuse_green = vec3(0.2,0.8,0.4);
    vec3 ambient_green = vec3(0.6,1,0.6);
    vec3 specular_green = vec3(0.7,1,0.7);

    vec3 diffuse_red = vec3(0.8,0.0,0.0);
    vec3 ambient_red = vec3(0.6,0.2,0.2);
    vec3 specular_red = vec3(0.8,0.6,0.6);

    vec3 diffuse_blue = vec3(0.2,0.3,1.8);
    vec3 ambient_blue = vec3(0.5,0.5,0.6);
    vec3 specular_blue = vec3(0.6,0.6,0.8);

    float blend67 = 1 - smoothstep(t6, t6 + 5, time); // 1 -> 0
    float blend67b = 1 - smoothstep(t6+20, t6 + 20 + 3, time); // 1 -> 0

    vec3 diffuse_color = diffuse_green * blend67 + diffuse_red * (1-blend67) * blend67b + diffuse_blue * (1-blend67b);
    vec3 ambient_color = ambient_green * blend67 + ambient_red * (1-blend67) * blend67b + ambient_blue * (1-blend67b);
    vec3 specular_color = specular_green * blend67 + specular_red * (1-blend67) * blend67b + specular_blue * (1-blend67b);

    vec3 sun6 = v_0 + vec3(-30,5,10);
    vec3 sun7 = v_0 + vec3(0,0,50);

    //vec3 sun = sun6 * blend67;
    vec3 sun = sun6 * blend67 + sun7 * (1 - blend67);

/*
    if(time > t6){

    }
*/
    if(part2_sdf(pos) > 0.05) // No hit
        outputColor = vec4(background,1);
    else{
        vec3 surface = pos;
        vec3 normal = get_normal_part2(surface);
        vec3 l = surface - sun; // Sun to surface
        float intensity_at_surface = sun_intensity / dot(l,l); // Inverse square decay
        
    	vec3 l_prime = l + 2.0*dot(l,normal)*normal;
        vec3 to_camera = v_0 - surface;
        float cos_angle = cdot(-l_prime, to_camera)/(length(l_prime) * length(to_camera));
        vec3 specular = specular_color * k_s * pow(cos_angle,q) * intensity_at_surface;
        vec3 diffuse = diffuse_color * 0.2 * cdot(normal, -l) * intensity_at_surface;
        vec3 ambient = ambient_color * 0.01;
        vec3 light = vec3(clamp(diffuse + specular + ambient,0.0,1.0));
        float fogfactor = clamp(length(pos-v_0)/400.0,0.0,1.0);
        fogfactor = 0.0;
        vec3 finallight = vec3(light.x, light.y, light.z);
        finallight = mix(finallight, background, fogfactor);
        finallight = gamma(filmicToneMapping(finallight));
        outputColor = vec4(finallight,1);
    }

    if(time > t6+20+9){
        if(pixel_pos.y > 0.3){
            fragCoord = gl_FragCoord.xy;
            // Fix coordinate system
            aspect_ratio = 16.0/9.0;
            //float aspect_ratio = 1.0;
            pixel_pos = fragCoord.xy / vec2(width,height); // [0,1]
            float t = time - t6 - 20 - 9;
            vec2 tex_coord = vec2(pixel_pos.x/10 - 0.1 + mod(t,100)*0.05, (pixel_pos.y - 0.7) / 0.3 + 0.1);
            tex_coord.y += sin(t*4.5 + pixel_pos.x*10)*0.25;
            //vec4 tex_color = texture(message, vec2(pixel_pos.x + 0.2*mod(time,5) , 
            //                                   pixel_pos.y + sin(time*3 + pixel_pos.x * 5)*0.1));
            vec4 tex_color = texture(message, tex_coord);
        //tex_color[1] = 0;
            outputColor += tex_color;
        }
    }
}

void main(){

    //time = mod(iGlobalTime,30) + t1 + t2 + t3;
    time = iGlobalTime;
    time -= 0.15;
    //time += 100;

    float fade1 = 1 - smoothstep(t1+t2+t3+t4 - 2, t1+t2+t3+t4, time) * (1 - smoothstep(t1+t2+t3+t4, t1+t2+t3+t4 + 2, time));
    float fade2 = 1 - smoothstep(t1+t2+t3+t4+t5 - 2, t1+t2+t3+t4+t5, time) * (1 - smoothstep(t1+t2+t3+t4+t5, t1+t2+t3+t4+t5 + 2, time));
    float fade3 = 1 - smoothstep(130, 133, time);

    //time = mod(iGlobalTime,40);
    //time += t1+t2+t3+t4+t5+t6;
    //time = 0;

    if(time < t1+t2+t3+t4+t5) part1();
    else{
        time = time - t1-t2-t3-t4-t5;
        part2();
    }

    outputColor *= fade1 * fade2 * fade3;

    //if(mod(time,sec_per_beat) < 0.05 || mod(time,sec_per_beat) > sec_per_beat - 0.05) outputColor = vec4(1,1,1,1);
}


