#version 430

layout(binding=0, r32i) uniform iimage2D testFixed;


uniform float partNum = 0.0;

ivec2 getTrip(int idt) {
    ivec2 triBufSize = imageSize(testFixed);
    ivec2 trip;
    trip.y = idt/triBufSize.x;
    trip.x = idt-trip.y*triBufSize.x;
    return trip;
}

int getInd(ivec2 uvi) {
    return uvi.x+uvi.y*int(imageSize(testFixed).x);
}

uniform float framePos;

void main() {
    ivec2 uv = ivec2(gl_FragCoord.xy);

    imageAtomicAdd(testFixed, getTrip(int(framePos)), 1);

    discard; return;
}
