#version 430

in vec2 uv;
in float no;

in vec3 norm;
in vec3 tan;
in vec3 bit;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texBump;
layout(binding=2) uniform sampler2D texNormal;


layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

uniform float g_time;


uniform mat4 viewInvMatrix;
uniform mat4 modelViewInvMatrix;

vec2 rotateXY2(vec2 p, float a) {
  vec2 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

uniform float texSub = 0.0;
uniform float texMul = 1.0;


vec3 texOp(vec3 t) {
    t.rgb -= vec3(texSub);
    t.rgb = clamp(t.rgb, 0.0, 10000.0);
    t.rgb *= texMul;
    return t;
}

uniform float uvScale = 1.0;

uniform float bumpTexInd = 0.0;



// todo: #include "bump.h"
uniform float bumpStrength = 1.0;
uniform float bumpTexDelta = 1.0;
uniform float bumpUvScale = 1.0;

uniform float useNormalMap = 0.0;


vec3 getBumpG(sampler2D s, vec2 uv) {
    if (abs(bumpUvScale) < 0.0001) {
    //    uv *= uvScale;
    } else {
        uv *= bumpUvScale;
    }
    uv += vec2(0.5);
    vec2 d = vec2(bumpTexDelta)/textureSize(tex, 0);

    if (useNormalMap > 0.5) {
      vec3 r = texture2D(texNormal, uv).xyz;
      r.xy *= bumpStrength;
      return r;
    } else {
      vec3 r = vec3(texOp(texture2D(s, uv+d.xy).rgb).g-texOp(texture2D(s, uv-d.xy).rgb).g,
                  texOp(texture2D(s, uv+d.yx).rgb).g-texOp(texture2D(s, uv-d.yx).rgb).g, 1.0)*bumpStrength;
      r.z = 1.0;
      return r;
    }
}


float deg2pi = 2.0*3.141592/360.0;





uniform float dispBrightMul = 1.5;
uniform float dispBrightOfs = 0.1;
uniform float dispBrightExp = 4.0;

//uniform float hillTexFade = 1.0;
//uniform float hillTexFadeExp = 1.0;
//uniform float hillTexFadeOfs = 0.0;

uniform float specExp = 4.0;
uniform float specAmp = 2.0;


uniform float diffExp = 1.0;
uniform float diffAmp = 2.0;

uniform float alpha = 1.0;
uniform float ambient = 0.1;
uniform float texAmount = 0.5;

void main() {
    vec2 uvS = uv;
    // uvS.y = 1.0-uvS.y;

    vec2 uvc = uvS*uvScale+vec2(0.5);

    vec4 r = texture2D(tex, uvc);
/*
    vec4 ht = vec4(0.0);

    if (abs(hillTexFade) > 0.001) {
        //ht = texture2D(texHill, uvS*uvScale);
        ht = texture2D(tex, uvS*uvScale);
    }

    float hillFade = 0.0;


    hillFade = clamp(pow(hiller, hillTexFadeExp)*hillTexFade+hillTexFadeOfs, 0.0, 1.0);
*/

    float dispBright = pow(clamp(no*dispBrightMul+dispBrightOfs, 0.0, 1000.0), dispBrightExp);

    r.rgb = texOp(r.rgb);
  //  ht.rgb = texOp(ht.rgb);

  //  r.rgb = mix(r.rgb, ht.rgb, hillFade);

    r.rgb *= r.rgb;

    r.rgb = vec3(1.0)*(1.0-texAmount)+r.rgb*(texAmount);

    r.rgb = clamp(r.rgb, 0.0, 1000.0);


//    r.rgb = pow(r.rgb, vec3(2.0))*10.0+vec3(0.5);
//    r.rgb = pow(r.rgb, vec3(0.5));

     vec3 bu = vec3(0.0);

     if (bumpTexInd < 0) {
         bu = getBumpG(tex, uvc);
//         if (abs(hillTexFade) > 0.001) {
//            // vec2 buh = getBumpG(texHill, uvS);
//            vec2 buh = getBumpG(tex, uvS);
//            bu = mix(bu, buh, hillFade);
//         }
     } else {
         bu = getBumpG(texBump, uvc);
     }

     // bu.xy *= 100.0;

     vec3 n = norm+bu.x*tan+bu.y*bit;
     n = normalize(n);

 //    vec3 ld = vec3(0.0, 0.0, 1.0);
 //    r.rgb *= clamp(vec3(ambient)+vec3(pow(clamp(dot(ld,n), 0.0, 1.0), diffExp)*diffAmp), 0.0, 10000.0);

  //   r.rgb += vec3(pow(clamp(dot(ld,n), 0.0, 1.0), specExp)*specAmp);

     r.rgb = pow(r.rgb, vec3(diffExp))*diffAmp+vec3(ambient);

     r.rgb *= dispBright;


     r.rgb = clamp(r.rgb, 0.0, 10000.0);

     r.rgb = pow(r.rgb, vec3(0.5));
     //r.rgb = normalize(norm.rgb)*1.0+vec3(0.0);

    // r.rgb = norm.rgb;

     // r.rgb = normalize(tan.rgb)*1.0+vec3(0.0);

     r.a *= alpha;

     // r.rgb = 5.0*texture2D(texBump, uvc).xyz;

    frag = r;


    vec3 nv = (viewInvMatrix*vec4(n, 0.0)).xyz;
   // nv.xyz /= nv.w;
 //   vec3 nv = -(modelViewInvMatrix*vec4(norm, 0.0)).xyz;

    nv = normalize(nv);

    frag2.rgb = nv.xyz;
    frag2.a = 1.0;
}

