/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.shape.Triangulator;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b+\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001LB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J&\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002J1\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015JH\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u001a\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0002J\u001e\u0010%\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J*\u0010)\u001a\u00020\u00172\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J*\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\b\u0010.\u001a\u0004\u0018\u00010\u0006H\u0002J(\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006H\u0002J\u0018\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002J\u0010\u00105\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J(\u00106\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u00107\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002J2\u00108\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u00109\u001a\u00020\"H\u0002J\u0018\u0010:\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002J\u0018\u0010;\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002JH\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u0004H\u0002J\u0010\u0010E\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010F\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0014\u0010G\u001a\u0004\u0018\u00010\u00062\b\u0010H\u001a\u0004\u0018\u00010\u0006H\u0002J>\u0010I\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u0010J\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002J0\u0010K\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002\u00a8\u0006M"}, d2={"Lorg/openrndr/shape/Triangulator;", "", "()V", "area", "", "p", "Lorg/openrndr/shape/Triangulator$Node;", "q", "r", "cureLocalIntersections", "start", "triangles", "", "", "dim", "earcut", "", "data", "", "holeIndices", "", "earcut$openrndr_shape", "earcutLinked", "", "ear", "minX", "minY", "size", "pass", "eliminateHole", "hole", "outerNode", "eliminateHoles", "equals", "", "p1", "p2", "filterPoints", "end", "findHoleBridge", "getLeftmost", "indexCurve", "insertNode", "i", "x", "y", "last", "intersects", "q1", "q2", "intersectsPolygon", "a", "b", "isEar", "isEarHashed", "isValidDiagonal", "linkedList", "clockwise", "locallyInside", "middleInside", "pointInTriangle", "ax", "ay", "bx", "by", "cx", "cy", "px", "py", "removeNode", "signedArea", "sortLinked", "list", "splitEarcut", "splitPolygon", "zOrder", "Node", "openrndr-shape"})
public final class Triangulator {
    public static final Triangulator INSTANCE;

    @NotNull
    public final List<Integer> earcut$openrndr_shape(@NotNull double[] data2, @Nullable int[] holeIndices, int dim) {
        int n;
        boolean hasHoles;
        Intrinsics.checkParameterIsNotNull(data2, "data");
        boolean bl = hasHoles = holeIndices != null && holeIndices.length > 0;
        if (hasHoles) {
            if (holeIndices == null) {
                Intrinsics.throwNpe();
            }
            n = holeIndices[0] * dim;
        } else {
            n = data2.length;
        }
        int outerLen = n;
        Node outerNode = this.linkedList(data2, 0, outerLen, dim, true);
        ArrayList triangles = new ArrayList();
        if (outerNode == null) {
            return triangles;
        }
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double size = DoubleCompanionObject.INSTANCE.getMIN_VALUE();
        if (hasHoles) {
            if (holeIndices == null) {
                Intrinsics.throwNpe();
            }
            outerNode = this.eliminateHoles(data2, holeIndices, outerNode, dim);
        }
        if (data2.length > 80 * dim) {
            minX = maxX = data2[0];
            minY = maxY = data2[1];
            for (int i = dim; i < outerLen; i += dim) {
                double x = data2[i];
                double y = data2[i + 1];
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (!(y > maxY)) continue;
                maxY = y;
            }
            size = Math.max(maxX - minX, maxY - minY);
        }
        this.earcutLinked(outerNode, triangles, dim, minX, minY, size, Integer.MIN_VALUE);
        return triangles;
    }

    @NotNull
    public static /* synthetic */ List earcut$openrndr_shape$default(Triangulator triangulator, double[] dArray, int[] nArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            nArray = null;
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        return triangulator.earcut$openrndr_shape(dArray, nArray, n);
    }

    private final void earcutLinked(Node ear, List<Integer> triangles, int dim, double minX, double minY, double size, int pass) {
        block9: {
            Node ear2;
            block11: {
                block10: {
                    Node node = ear;
                    if (node == null) {
                        return;
                    }
                    ear2 = node;
                    if (pass == Integer.MIN_VALUE && size != Double.MIN_VALUE) {
                        this.indexCurve(ear2, minX, minY, size);
                    }
                    Node stop = ear2;
                    while (true) {
                        Node node2 = ear2;
                        if (node2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (node2.getPrev$openrndr_shape() == ear2.getNext$openrndr_shape()) break block9;
                        Node prev = ear2.getPrev$openrndr_shape();
                        Node next = ear2.getNext$openrndr_shape();
                        if (size != Double.MIN_VALUE ? this.isEarHashed(ear2, minX, minY, size) : this.isEar(ear2)) {
                            Node node3 = prev;
                            if (node3 == null) {
                                Intrinsics.throwNpe();
                            }
                            triangles.add(node3.getI$openrndr_shape() / dim);
                            triangles.add(ear2.getI$openrndr_shape() / dim);
                            Node node4 = next;
                            if (node4 == null) {
                                Intrinsics.throwNpe();
                            }
                            triangles.add(node4.getI$openrndr_shape() / dim);
                            this.removeNode(ear2);
                            ear2 = next.getNext$openrndr_shape();
                            stop = next.getNext$openrndr_shape();
                            continue;
                        }
                        ear2 = next;
                        if (ear2 == stop) break;
                    }
                    if (pass != Integer.MIN_VALUE) break block10;
                    this.earcutLinked(this.filterPoints(ear2, null), triangles, dim, minX, minY, size, 1);
                    break block9;
                }
                if (pass != 1) break block11;
                Node node = ear2;
                if (node == null) {
                    throw (Throwable)new IllegalStateException("ear is null");
                }
                ear2 = this.cureLocalIntersections(node, triangles, dim);
                this.earcutLinked(ear2, triangles, dim, minX, minY, size, 2);
                break block9;
            }
            if (pass != 2) break block9;
            Node node = ear2;
            if (node == null) {
                throw (Throwable)new IllegalStateException("ear is null");
            }
            this.splitEarcut(node, triangles, dim, minX, minY, size);
        }
    }

    private final void splitEarcut(Node start, List<Integer> triangles, int dim, double minX, double minY, double size) {
        Node a2 = start;
        do {
            Node node = a2;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            if (node.getNext$openrndr_shape() == null) {
                Intrinsics.throwNpe();
            }
            for (Node b = (v132624).getNext$openrndr_shape(); b != a2.getPrev$openrndr_shape(); b = b.getNext$openrndr_shape()) {
                int n = a2.getI$openrndr_shape();
                Node node2 = b;
                if (node2 == null) {
                    Intrinsics.throwNpe();
                }
                if (n == node2.getI$openrndr_shape() || !this.isValidDiagonal(a2, b)) continue;
                Node c = this.splitPolygon(a2, b);
                a2 = this.filterPoints(a2, a2.getNext$openrndr_shape());
                Node node3 = c;
                if (node3 == null) {
                    Intrinsics.throwNpe();
                }
                c = this.filterPoints(c, node3.getNext$openrndr_shape());
                this.earcutLinked(a2, triangles, dim, minX, minY, size, Integer.MIN_VALUE);
                this.earcutLinked(c, triangles, dim, minX, minY, size, Integer.MIN_VALUE);
                return;
            }
        } while ((a2 = a2.getNext$openrndr_shape()) != start);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidDiagonal(Node a2, Node b) {
        Node node = a2.getNext$openrndr_shape();
        if (node == null) {
            Intrinsics.throwNpe();
        }
        if (node.getI$openrndr_shape() == b.getI$openrndr_shape()) return false;
        Node node2 = a2.getPrev$openrndr_shape();
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        if (node2.getI$openrndr_shape() == b.getI$openrndr_shape()) return false;
        if (this.intersectsPolygon(a2, b)) return false;
        if (!this.locallyInside(a2, b)) return false;
        if (!this.locallyInside(b, a2)) return false;
        if (!this.middleInside(a2, b)) return false;
        return true;
    }

    private final boolean middleInside(Node a2, Node b) {
        Node p = a2;
        boolean inside = false;
        double px = (a2.getX$openrndr_shape() + b.getX$openrndr_shape()) / (double)2;
        double py = (a2.getY$openrndr_shape() + b.getY$openrndr_shape()) / (double)2;
        do {
            Node node = p;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            boolean bl = node.getY$openrndr_shape() > py;
            Node node2 = p.getNext$openrndr_shape();
            if (node2 == null) {
                Intrinsics.throwNpe();
            }
            if (bl == node2.getY$openrndr_shape() > py) continue;
            Node node3 = p.getNext$openrndr_shape();
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            double d = (node3.getX$openrndr_shape() - p.getX$openrndr_shape()) * (py - p.getY$openrndr_shape());
            Node node4 = p.getNext$openrndr_shape();
            if (node4 == null) {
                Intrinsics.throwNpe();
            }
            if (!(px < d / (node4.getY$openrndr_shape() - p.getY$openrndr_shape()) + p.getX$openrndr_shape())) continue;
            boolean bl2 = inside = !inside;
        } while ((p = p.getNext$openrndr_shape()) != a2);
        return inside;
    }

    private final boolean intersectsPolygon(Node a2, Node b) {
        Node p = a2;
        do {
            if (p.getI$openrndr_shape() != a2.getI$openrndr_shape()) {
                Node node = p.getNext$openrndr_shape();
                if (node == null) {
                    Intrinsics.throwNpe();
                }
                if (node.getI$openrndr_shape() != a2.getI$openrndr_shape() && p.getI$openrndr_shape() != b.getI$openrndr_shape()) {
                    Node node2 = p.getNext$openrndr_shape();
                    if (node2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (node2.getI$openrndr_shape() != b.getI$openrndr_shape()) {
                        Node node3 = p.getNext$openrndr_shape();
                        if (node3 == null) {
                            throw (Throwable)new IllegalStateException("p.next is null");
                        }
                        if (this.intersects(p, node3, a2, b)) {
                            return true;
                        }
                    }
                }
            }
            if (p.getNext$openrndr_shape() != null) continue;
            throw (Throwable)new IllegalStateException("p.next is null");
        } while (p != a2);
        return false;
    }

    private final boolean intersects(Node p1, Node q1, Node p2, Node q2) {
        return this.equals(p1, q1) && this.equals(p2, q2) || this.equals(p1, q2) && this.equals(p2, q1) ? true : this.area(p1, q1, p2) > 0.0 != this.area(p1, q1, q2) > 0.0 && this.area(p2, q2, p1) > 0.0 != this.area(p2, q2, q1) > 0.0;
    }

    private final Node cureLocalIntersections(Node start, List<Integer> triangles, int dim) {
        Node start2;
        Node p = start2 = start;
        do {
            Node b;
            Node a2;
            if (p.getPrev$openrndr_shape() == null) {
                Intrinsics.throwNpe();
            }
            Node node = p.getNext$openrndr_shape();
            if (node == null) {
                Intrinsics.throwNpe();
            }
            if (node.getNext$openrndr_shape() == null) {
                Intrinsics.throwNpe();
            }
            if (!this.equals(a2, b)) {
                Node node2 = p.getNext$openrndr_shape();
                if (node2 == null) {
                    throw (Throwable)new IllegalStateException("p.next is null");
                }
                if (this.intersects(a2, p, node2, b) && this.locallyInside(a2, b) && this.locallyInside(b, a2)) {
                    triangles.add(a2.getI$openrndr_shape() / dim);
                    triangles.add(p.getI$openrndr_shape() / dim);
                    triangles.add(b.getI$openrndr_shape() / dim);
                    this.removeNode(p);
                    Node node3 = p.getNext$openrndr_shape();
                    if (node3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.removeNode(node3);
                    p = start2 = b;
                }
            }
            if (p.getNext$openrndr_shape() != null) continue;
            Intrinsics.throwNpe();
        } while (p != start2);
        return p;
    }

    private final boolean isEar(Node ear) {
        Node a2 = ear.getPrev$openrndr_shape();
        Node c = ear.getNext$openrndr_shape();
        Node node = a2;
        if (node == null) {
            Intrinsics.throwNpe();
        }
        Node node2 = c;
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        if (this.area(node, ear, node2) >= 0.0) {
            return false;
        }
        if (ear.getNext$openrndr_shape() == null) {
            Intrinsics.throwNpe();
        }
        for (Node p = (v133106).getNext$openrndr_shape(); p != ear.getPrev$openrndr_shape(); p = p.getNext$openrndr_shape()) {
            double d = a2.getX$openrndr_shape();
            double d2 = a2.getY$openrndr_shape();
            double d3 = ear.getX$openrndr_shape();
            double d4 = ear.getY$openrndr_shape();
            double d5 = c.getX$openrndr_shape();
            double d6 = c.getY$openrndr_shape();
            Node node3 = p;
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            if (!this.pointInTriangle(d, d2, d3, d4, d5, d6, node3.getX$openrndr_shape(), p.getY$openrndr_shape())) continue;
            Node node4 = p.getPrev$openrndr_shape();
            if (node4 == null) {
                Intrinsics.throwNpe();
            }
            Node node5 = p.getNext$openrndr_shape();
            if (node5 == null) {
                Intrinsics.throwNpe();
            }
            if (!(this.area(node4, p, node5) >= 0.0)) continue;
            return false;
        }
        return true;
    }

    private final boolean isEarHashed(Node ear, double minX, double minY, double size) {
        Node p;
        double maxTX;
        double minTY;
        double minTX;
        Node a2 = ear.getPrev$openrndr_shape();
        Node c = ear.getNext$openrndr_shape();
        Node node = a2;
        if (node == null) {
            Intrinsics.throwNpe();
        }
        Node node2 = c;
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        if (this.area(node, ear, node2) >= 0.0) {
            return false;
        }
        double d = a2.getX$openrndr_shape() < ear.getX$openrndr_shape() ? (a2.getX$openrndr_shape() < c.getX$openrndr_shape() ? a2.getX$openrndr_shape() : c.getX$openrndr_shape()) : (minTX = ear.getX$openrndr_shape() < c.getX$openrndr_shape() ? ear.getX$openrndr_shape() : c.getX$openrndr_shape());
        double d2 = a2.getY$openrndr_shape() < ear.getY$openrndr_shape() ? (a2.getY$openrndr_shape() < c.getY$openrndr_shape() ? a2.getY$openrndr_shape() : c.getY$openrndr_shape()) : (minTY = ear.getY$openrndr_shape() < c.getY$openrndr_shape() ? ear.getY$openrndr_shape() : c.getY$openrndr_shape());
        double d3 = a2.getX$openrndr_shape() > ear.getX$openrndr_shape() ? (a2.getX$openrndr_shape() > c.getX$openrndr_shape() ? a2.getX$openrndr_shape() : c.getX$openrndr_shape()) : (maxTX = ear.getX$openrndr_shape() > c.getX$openrndr_shape() ? ear.getX$openrndr_shape() : c.getX$openrndr_shape());
        double maxTY = a2.getY$openrndr_shape() > ear.getY$openrndr_shape() ? (a2.getY$openrndr_shape() > c.getY$openrndr_shape() ? a2.getY$openrndr_shape() : c.getY$openrndr_shape()) : (ear.getY$openrndr_shape() > c.getY$openrndr_shape() ? ear.getY$openrndr_shape() : c.getY$openrndr_shape());
        double minZ = this.zOrder(minTX, minTY, minX, minY, size);
        double maxZ = this.zOrder(maxTX, maxTY, minX, minY, size);
        for (p = ear.getNextZ$openrndr_shape(); p != null && p.getZ$openrndr_shape() <= maxZ; p = p.getNextZ$openrndr_shape()) {
            if (p == ear.getPrev$openrndr_shape() || p == ear.getNext$openrndr_shape() || !this.pointInTriangle(a2.getX$openrndr_shape(), a2.getY$openrndr_shape(), ear.getX$openrndr_shape(), ear.getY$openrndr_shape(), c.getX$openrndr_shape(), c.getY$openrndr_shape(), p.getX$openrndr_shape(), p.getY$openrndr_shape())) continue;
            Node node3 = p.getPrev$openrndr_shape();
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            Node node4 = p.getNext$openrndr_shape();
            if (node4 == null) {
                Intrinsics.throwNpe();
            }
            if (!(this.area(node3, p, node4) >= 0.0)) continue;
            return false;
        }
        for (p = ear.getPrevZ$openrndr_shape(); p != null && p.getZ$openrndr_shape() >= minZ; p = p.getPrevZ$openrndr_shape()) {
            if (p == ear.getPrev$openrndr_shape() || p == ear.getNext$openrndr_shape() || !this.pointInTriangle(a2.getX$openrndr_shape(), a2.getY$openrndr_shape(), ear.getX$openrndr_shape(), ear.getY$openrndr_shape(), c.getX$openrndr_shape(), c.getY$openrndr_shape(), p.getX$openrndr_shape(), p.getY$openrndr_shape())) continue;
            Node node5 = p.getPrev$openrndr_shape();
            if (node5 == null) {
                Intrinsics.throwNpe();
            }
            Node node6 = p.getNext$openrndr_shape();
            if (node6 == null) {
                Intrinsics.throwNpe();
            }
            if (!(this.area(node5, p, node6) >= 0.0)) continue;
            return false;
        }
        return true;
    }

    private final double zOrder(double x, double y, double minX, double minY, double size) {
        int lx = (int)((double)Short.MAX_VALUE * (x - minX) / size);
        int ly = (int)((double)Short.MAX_VALUE * (y - minY) / size);
        lx = (lx | lx << 8) & 0xFF00FF;
        lx = (lx | lx << 4) & 0xF0F0F0F;
        lx = (lx | lx << 2) & 0x33333333;
        lx = (lx | lx << 1) & 0x55555555;
        ly = (ly | ly << 8) & 0xFF00FF;
        ly = (ly | ly << 4) & 0xF0F0F0F;
        ly = (ly | ly << 2) & 0x33333333;
        ly = (ly | ly << 1) & 0x55555555;
        return lx | ly << 1;
    }

    private final void indexCurve(Node start, double minX, double minY, double size) {
        Node node = start;
        if (node == null) {
            return;
        }
        Node p = node;
        do {
            if (p.getZ$openrndr_shape() == Double.MIN_VALUE) {
                p.setZ$openrndr_shape(this.zOrder(p.getX$openrndr_shape(), p.getY$openrndr_shape(), minX, minY, size));
            }
            p.setPrevZ$openrndr_shape(p.getPrev$openrndr_shape());
            p.setNextZ$openrndr_shape(p.getNext$openrndr_shape());
            if (p.getNext$openrndr_shape() != null) continue;
            throw (Throwable)new IllegalStateException("p.next is null");
        } while (p != start);
        Node node2 = p.getPrevZ$openrndr_shape();
        if (node2 != null) {
            node2.setNextZ$openrndr_shape(null);
        }
        p.setPrevZ$openrndr_shape(null);
        this.sortLinked(p);
    }

    /*
     * WARNING - void declaration
     */
    private final Node sortLinked(Node list) {
        Node list2 = list;
        int inSize = 1;
        int numMerges = 0;
        do {
            Node p = list2;
            list2 = null;
            Node tail = null;
            numMerges = 0;
            while (p != null) {
                ++numMerges;
                Node q = p;
                int pSize = 0;
                int n = 0;
                int n2 = inSize;
                while (n < n2) {
                    void i;
                    ++pSize;
                    if ((q = q.getNextZ$openrndr_shape()) == null) break;
                    ++i;
                }
                int qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    Node e = null;
                    if (pSize == 0) {
                        Node node = q;
                        if (node == null) {
                            throw (Throwable)new IllegalStateException("q is null");
                        }
                        e = node;
                        q = q.getNextZ$openrndr_shape();
                        --qSize;
                    } else if (qSize == 0 || q == null) {
                        Node node = p;
                        if (node == null) {
                            throw (Throwable)new IllegalStateException("p is null");
                        }
                        e = node;
                        p = p.getNextZ$openrndr_shape();
                        --pSize;
                    } else {
                        Node node = p;
                        if (node == null) {
                            Intrinsics.throwNpe();
                        }
                        if (node.getZ$openrndr_shape() <= q.getZ$openrndr_shape()) {
                            e = p;
                            p = p.getNextZ$openrndr_shape();
                            --pSize;
                        } else {
                            e = q;
                            q = q.getNextZ$openrndr_shape();
                            --qSize;
                        }
                    }
                    if (tail != null) {
                        tail.setNextZ$openrndr_shape(e);
                    } else {
                        list2 = e;
                    }
                    e.setPrevZ$openrndr_shape(tail);
                    tail = e;
                }
                p = q;
            }
            Node node = tail;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            node.setNextZ$openrndr_shape(null);
            inSize *= 2;
        } while (numMerges > 1);
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final Node eliminateHoles(double[] data2, int[] holeIndices, Node outerNode, int dim) {
        Node outerNode2 = outerNode;
        ArrayList<Node> queue = new ArrayList<Node>();
        int len = holeIndices.length;
        int n = 0;
        int n2 = len;
        while (n < n2) {
            Node list;
            int end2;
            void i;
            int start = holeIndices[i] * dim;
            int n3 = end2 = i < len - 1 ? holeIndices[i + true] * dim : data2.length;
            if (this.linkedList(data2, start, end2, dim, false) == null) {
                throw (Throwable)new IllegalStateException("list is null");
            }
            if (list == list.getNext$openrndr_shape()) {
                list.setSteiner$openrndr_shape(true);
            }
            queue.add(this.getLeftmost(list));
            ++i;
        }
        CollectionsKt.sortWith((List)queue, eliminateHoles.1.INSTANCE);
        Iterator iterator2 = queue.iterator();
        while (iterator2.hasNext()) {
            Node node;
            Node node2 = node = (Node)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(node2, "node");
            this.eliminateHole(node2, outerNode2);
            Node node3 = outerNode2;
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            outerNode2 = this.filterPoints(outerNode2, node3.getNext$openrndr_shape());
        }
        return outerNode2;
    }

    private final Node filterPoints(Node start, Node end2) {
        Node end3 = end2;
        if (start == null) {
            return start;
        }
        if (end3 == null) {
            end3 = start;
        }
        Node p = start;
        boolean again = false;
        do {
            block14: {
                block13: {
                    block12: {
                        again = false;
                        Node node = p;
                        if (node == null) {
                            Intrinsics.throwNpe();
                        }
                        if (node.getSteiner$openrndr_shape()) break block12;
                        Node node2 = p.getNext$openrndr_shape();
                        if (node2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (this.equals(p, node2)) break block13;
                    }
                    Node node = p.getPrev$openrndr_shape();
                    if (node == null) {
                        Intrinsics.throwNpe();
                    }
                    Node node3 = p.getNext$openrndr_shape();
                    if (node3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (this.area(node, p, node3) != 0.0) break block14;
                }
                this.removeNode(p);
                Node node = p = (end3 = p.getPrev$openrndr_shape());
                if (node == null) {
                    Intrinsics.throwNpe();
                }
                if (p == node.getNext$openrndr_shape()) {
                    return null;
                }
                again = true;
                continue;
            }
            p = p.getNext$openrndr_shape();
        } while (again || p != end3);
        return end3;
    }

    private final boolean equals(Node p1, Node p2) {
        return p1.getX$openrndr_shape() == p2.getX$openrndr_shape() && p1.getY$openrndr_shape() == p2.getY$openrndr_shape();
    }

    private final double area(Node p, Node q, Node r) {
        return (q.getY$openrndr_shape() - p.getY$openrndr_shape()) * (r.getX$openrndr_shape() - q.getX$openrndr_shape()) - (q.getX$openrndr_shape() - p.getX$openrndr_shape()) * (r.getY$openrndr_shape() - q.getY$openrndr_shape());
    }

    private final void eliminateHole(Node hole, Node outerNode) {
        Node outerNode2 = outerNode;
        if ((outerNode2 = this.findHoleBridge(hole, outerNode2)) != null) {
            Node b = this.splitPolygon(outerNode2, hole);
            this.filterPoints(b, b.getNext$openrndr_shape());
        }
    }

    private final Node splitPolygon(Node a2, Node b) {
        Node a22 = new Node(a2.getI$openrndr_shape(), a2.getX$openrndr_shape(), a2.getY$openrndr_shape());
        Node b2 = new Node(b.getI$openrndr_shape(), b.getX$openrndr_shape(), b.getY$openrndr_shape());
        Node an = a2.getNext$openrndr_shape();
        Node bp = b.getPrev$openrndr_shape();
        a2.setNext$openrndr_shape(b);
        b.setPrev$openrndr_shape(a2);
        a22.setNext$openrndr_shape(an);
        Node node = an;
        if (node == null) {
            Intrinsics.throwNpe();
        }
        node.setPrev$openrndr_shape(a22);
        b2.setNext$openrndr_shape(a22);
        a22.setPrev$openrndr_shape(b2);
        Node node2 = bp;
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        node2.setNext$openrndr_shape(b2);
        b2.setPrev$openrndr_shape(bp);
        return b2;
    }

    private final Node findHoleBridge(Node hole, Node outerNode) {
        Node p = outerNode;
        double hx = hole.getX$openrndr_shape();
        double hy = hole.getY$openrndr_shape();
        double qx = -1.7976931348623157E308;
        Node m = null;
        do {
            double x;
            Node node = p;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            if (!(hy <= node.getY$openrndr_shape())) continue;
            Node node2 = p.getNext$openrndr_shape();
            if (node2 == null) {
                Intrinsics.throwNpe();
            }
            if (!(hy >= node2.getY$openrndr_shape())) continue;
            double d = p.getX$openrndr_shape();
            double d2 = hy - p.getY$openrndr_shape();
            Node node3 = p.getNext$openrndr_shape();
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            double d3 = d2 * (node3.getX$openrndr_shape() - p.getX$openrndr_shape());
            Node node4 = p.getNext$openrndr_shape();
            if (node4 == null) {
                Intrinsics.throwNpe();
            }
            if (!((x = d + d3 / (node4.getY$openrndr_shape() - p.getY$openrndr_shape())) <= hx) || !(x > qx)) continue;
            qx = x;
            if (x == hx) {
                if (hy == p.getY$openrndr_shape()) {
                    return p;
                }
                Node node5 = p.getNext$openrndr_shape();
                if (node5 == null) {
                    Intrinsics.throwNpe();
                }
                if (hy == node5.getY$openrndr_shape()) {
                    return p.getNext$openrndr_shape();
                }
            }
            double d4 = p.getX$openrndr_shape();
            Node node6 = p.getNext$openrndr_shape();
            if (node6 == null) {
                Intrinsics.throwNpe();
            }
            Node node7 = m = d4 < node6.getX$openrndr_shape() ? p : p.getNext$openrndr_shape();
        } while ((p = p.getNext$openrndr_shape()) != outerNode);
        if (m == null) {
            return null;
        }
        if (hx == qx) {
            return m.getPrev$openrndr_shape();
        }
        Node stop = m;
        double mx = m.getX$openrndr_shape();
        double my = m.getY$openrndr_shape();
        double tanMin = Double.MAX_VALUE;
        double tan = 0.0;
        for (p = m.getNext$openrndr_shape(); p != stop; p = p.getNext$openrndr_shape()) {
            Node node = p;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            if (!(hx >= node.getX$openrndr_shape()) || !(p.getX$openrndr_shape() >= mx) || !this.pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.getX$openrndr_shape(), p.getY$openrndr_shape()) || !((tan = Math.abs(hy - p.getY$openrndr_shape()) / (hx - p.getX$openrndr_shape())) < tanMin) && (tan != tanMin || !(p.getX$openrndr_shape() > m.getX$openrndr_shape())) || !this.locallyInside(p, hole)) continue;
            m = p;
            tanMin = tan;
        }
        return m;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean locallyInside(Node a2, Node b) {
        Node node = a2.getPrev$openrndr_shape();
        if (node == null) {
            Intrinsics.throwNpe();
        }
        Node node2 = a2.getNext$openrndr_shape();
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        if (this.area(node, a2, node2) < 0.0) {
            Node node3 = a2.getNext$openrndr_shape();
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            if (!(this.area(a2, b, node3) >= 0.0)) return false;
            Node node4 = a2.getPrev$openrndr_shape();
            if (node4 == null) {
                Intrinsics.throwNpe();
            }
            if (!(this.area(a2, node4, b) >= 0.0)) return false;
            return true;
        }
        Node node5 = a2.getPrev$openrndr_shape();
        if (node5 == null) {
            Intrinsics.throwNpe();
        }
        if (this.area(a2, b, node5) < 0.0) return true;
        Node node6 = a2.getNext$openrndr_shape();
        if (node6 == null) {
            Intrinsics.throwNpe();
        }
        if (!(this.area(a2, node6, b) < 0.0)) return false;
        return true;
    }

    private final boolean pointInTriangle(double ax, double ay, double bx, double by, double cx, double cy, double px, double py) {
        return (cx - px) * (ay - py) - (ax - px) * (cy - py) >= 0.0 && (ax - px) * (by - py) - (bx - px) * (ay - py) >= 0.0 && (bx - px) * (cy - py) - (cx - px) * (by - py) >= 0.0;
    }

    private final Node getLeftmost(Node start) {
        Node p = start;
        Node leftmost = start;
        do {
            Node node = p;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            if (!(node.getX$openrndr_shape() < leftmost.getX$openrndr_shape())) continue;
            leftmost = p;
        } while ((p = p.getNext$openrndr_shape()) != start);
        return leftmost;
    }

    private final Node linkedList(double[] data2, int start, int end2, int dim, boolean clockwise) {
        Node last2 = null;
        if (clockwise == this.signedArea(data2, start, end2, dim) > 0.0) {
            for (int i = start; i < end2; i += dim) {
                last2 = this.insertNode(i, data2[i], data2[i + 1], last2);
            }
        } else {
            for (int i = end2 - dim; i >= start; i -= dim) {
                last2 = this.insertNode(i, data2[i], data2[i + 1], last2);
            }
        }
        if (last2 != null) {
            Node node = last2.getNext$openrndr_shape();
            if (node == null) {
                Intrinsics.throwNpe();
            }
            if (this.equals(last2, node)) {
                this.removeNode(last2);
                last2 = last2.getNext$openrndr_shape();
            }
        }
        return last2;
    }

    private final void removeNode(Node p) {
        Node node = p.getNext$openrndr_shape();
        if (node == null) {
            Intrinsics.throwNpe();
        }
        node.setPrev$openrndr_shape(p.getPrev$openrndr_shape());
        Node node2 = p.getPrev$openrndr_shape();
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        node2.setNext$openrndr_shape(p.getNext$openrndr_shape());
        if (p.getPrevZ$openrndr_shape() != null) {
            Node node3 = p.getPrevZ$openrndr_shape();
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            node3.setNextZ$openrndr_shape(p.getNextZ$openrndr_shape());
        }
        if (p.getNextZ$openrndr_shape() != null) {
            Node node4 = p.getNextZ$openrndr_shape();
            if (node4 == null) {
                Intrinsics.throwNpe();
            }
            node4.setPrevZ$openrndr_shape(p.getPrevZ$openrndr_shape());
        }
    }

    private final Node insertNode(int i, double x, double y, Node last2) {
        Node p = new Node(i, x, y);
        if (last2 == null) {
            p.setPrev$openrndr_shape(p);
            p.setNext$openrndr_shape(p);
        } else {
            p.setNext$openrndr_shape(last2.getNext$openrndr_shape());
            p.setPrev$openrndr_shape(last2);
            Node node = last2.getNext$openrndr_shape();
            if (node == null) {
                Intrinsics.throwNpe();
            }
            node.setPrev$openrndr_shape(p);
            last2.setNext$openrndr_shape(p);
        }
        return p;
    }

    private final double signedArea(double[] data2, int start, int end2, int dim) {
        double sum = 0.0;
        int j = end2 - dim;
        for (int i = start; i < end2; i += dim) {
            sum += (data2[j] - data2[i]) * (data2[i + 1] + data2[j + 1]);
            j = i;
        }
        return sum;
    }

    private Triangulator() {
    }

    static {
        Triangulator triangulator;
        INSTANCE = triangulator = new Triangulator();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010)\u001a\u00020*H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0000X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0000X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0000X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0000X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0006\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010!\"\u0004\b%\u0010#R\u001a\u0010&\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010!\"\u0004\b(\u0010#\u00a8\u0006+"}, d2={"Lorg/openrndr/shape/Triangulator$Node;", "", "i", "", "x", "", "y", "(IDD)V", "getI$openrndr_shape", "()I", "setI$openrndr_shape", "(I)V", "next", "getNext$openrndr_shape", "()Lorg/openrndr/shape/Triangulator$Node;", "setNext$openrndr_shape", "(Lorg/openrndr/shape/Triangulator$Node;)V", "nextZ", "getNextZ$openrndr_shape", "setNextZ$openrndr_shape", "prev", "getPrev$openrndr_shape", "setPrev$openrndr_shape", "prevZ", "getPrevZ$openrndr_shape", "setPrevZ$openrndr_shape", "steiner", "", "getSteiner$openrndr_shape", "()Z", "setSteiner$openrndr_shape", "(Z)V", "getX$openrndr_shape", "()D", "setX$openrndr_shape", "(D)V", "getY$openrndr_shape", "setY$openrndr_shape", "z", "getZ$openrndr_shape", "setZ$openrndr_shape", "toString", "", "openrndr-shape"})
    private static final class Node {
        private double z;
        private boolean steiner;
        @Nullable
        private Node prev;
        @Nullable
        private Node next;
        @Nullable
        private Node prevZ;
        @Nullable
        private Node nextZ;
        private int i;
        private double x;
        private double y;

        public final double getZ$openrndr_shape() {
            return this.z;
        }

        public final void setZ$openrndr_shape(double d) {
            this.z = d;
        }

        public final boolean getSteiner$openrndr_shape() {
            return this.steiner;
        }

        public final void setSteiner$openrndr_shape(boolean bl) {
            this.steiner = bl;
        }

        @Nullable
        public final Node getPrev$openrndr_shape() {
            return this.prev;
        }

        public final void setPrev$openrndr_shape(@Nullable Node node) {
            this.prev = node;
        }

        @Nullable
        public final Node getNext$openrndr_shape() {
            return this.next;
        }

        public final void setNext$openrndr_shape(@Nullable Node node) {
            this.next = node;
        }

        @Nullable
        public final Node getPrevZ$openrndr_shape() {
            return this.prevZ;
        }

        public final void setPrevZ$openrndr_shape(@Nullable Node node) {
            this.prevZ = node;
        }

        @Nullable
        public final Node getNextZ$openrndr_shape() {
            return this.nextZ;
        }

        public final void setNextZ$openrndr_shape(@Nullable Node node) {
            this.nextZ = node;
        }

        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{i: ").append(this.i).append(", x: ").append(this.x).append(", y: ").append(this.y).append(", prev: ").append(this.prev).append(", next: ").append(this.next);
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
            return string;
        }

        public final int getI$openrndr_shape() {
            return this.i;
        }

        public final void setI$openrndr_shape(int n) {
            this.i = n;
        }

        public final double getX$openrndr_shape() {
            return this.x;
        }

        public final void setX$openrndr_shape(double d) {
            this.x = d;
        }

        public final double getY$openrndr_shape() {
            return this.y;
        }

        public final void setY$openrndr_shape(double d) {
            this.y = d;
        }

        public Node(int i, double x, double y) {
            this.i = i;
            this.x = x;
            this.y = y;
            this.prev = null;
            this.next = null;
            this.z = Double.MIN_VALUE;
            this.prevZ = null;
            this.nextZ = null;
            this.steiner = false;
        }
    }
}

