/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extras.meshgenerators;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extras.meshgenerators.MeshGeneratorsKt;
import org.openrndr.math.Spherical;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a{\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2O\u0010\t\u001aK\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00010\nj\u0002`\u0012\u001a{\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2O\u0010\t\u001aK\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00010\nj\u0002`\u0012\u001a.\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"generateHemisphere", "", "sides", "", "segments", "radius", "", "invert", "", "writer", "Lkotlin/Function3;", "Lorg/openrndr/math/Vector3;", "Lkotlin/ParameterName;", "name", "position", "normal", "Lorg/openrndr/math/Vector2;", "texCoord", "Lorg/openrndr/extras/meshgenerators/VertexWriter;", "generateSphere", "sphereMesh", "Lorg/openrndr/draw/VertexBuffer;", "orx-mesh-generators"})
public final class SphereKt {
    @NotNull
    public static final VertexBuffer sphereMesh(int sides, int segments, double radius, boolean invert2) {
        int vertexCount2 = 2 * sides * 3 + Math.max(0, segments - 2) * sides * 6;
        VertexBuffer vb2 = MeshGeneratorsKt.meshVertexBuffer(vertexCount2);
        vb2.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(sides, segments, radius, invert2){
            final /* synthetic */ int $sides;
            final /* synthetic */ int $segments;
            final /* synthetic */ double $radius;
            final /* synthetic */ boolean $invert;

            public final void invoke(@NotNull BufferWriter $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                SphereKt.generateSphere(this.$sides, this.$segments, this.$radius, this.$invert, MeshGeneratorsKt.bufferWriter($receiver));
            }
            {
                this.$sides = n;
                this.$segments = n2;
                this.$radius = d;
                this.$invert = bl;
                super(1);
            }
        });
        return vb2;
    }

    @NotNull
    public static /* synthetic */ VertexBuffer sphereMesh$default(int n, int n2, double d, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 16;
        }
        if ((n3 & 2) != 0) {
            n2 = 16;
        }
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return SphereKt.sphereMesh(n, n2, d, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateSphere(int sides, int segments, double radius, boolean invert2, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> writer) {
        Intrinsics.checkParameterIsNotNull(writer, "writer");
        double inverter = invert2 ? -1.0 : 1.0;
        int n = 0;
        int n2 = segments;
        while (n < n2) {
            void t;
            int n3 = 0;
            int n4 = sides;
            while (n3 < n4) {
                void s2;
                Spherical st00 = new Spherical(radius, (double)s2 * Math.PI * 2.0 / (double)sides, (double)t * Math.PI / (double)segments);
                Spherical st01 = new Spherical(radius, (double)s2 * Math.PI * 2.0 / (double)sides, (double)(t + true) * Math.PI / (double)segments);
                Spherical st10 = new Spherical(radius, (double)(s2 + true) * Math.PI * 2.0 / (double)sides, (double)t * Math.PI / (double)segments);
                Spherical st11 = new Spherical(radius, (double)(s2 + true) * Math.PI * 2.0 / (double)sides, (double)(t + true) * Math.PI / (double)segments);
                double thetaMax = Math.PI;
                double phiMax = Math.PI * 2;
                void var20_16 = t;
                if (var20_16 == false) {
                    writer.invoke(st00.getCartesian(), st00.getCartesian().getNormalized().times(inverter), new Vector2(st00.getPhi() / phiMax, st00.getTheta() / thetaMax));
                    writer.invoke(st01.getCartesian(), st01.getCartesian().getNormalized().times(inverter), new Vector2(st01.getPhi() / phiMax, st01.getTheta() / thetaMax));
                    writer.invoke(st11.getCartesian(), st11.getCartesian().getNormalized().times(inverter), new Vector2(st11.getPhi() / phiMax, st11.getTheta() / thetaMax));
                } else if (var20_16 == segments - 1) {
                    writer.invoke(st11.getCartesian(), st11.getCartesian().getNormalized().times(inverter), new Vector2(st11.getPhi() / phiMax, st11.getTheta() / thetaMax));
                    writer.invoke(st10.getCartesian(), st10.getCartesian().getNormalized().times(inverter), new Vector2(st10.getPhi() / phiMax, st10.getTheta() / thetaMax));
                    writer.invoke(st00.getCartesian(), st00.getCartesian().getNormalized().times(inverter), new Vector2(st00.getPhi() / phiMax, st00.getTheta() / thetaMax));
                } else {
                    writer.invoke(st00.getCartesian(), st00.getCartesian().getNormalized().times(inverter), new Vector2(st00.getPhi() / phiMax, st00.getTheta() / thetaMax));
                    writer.invoke(st01.getCartesian(), st01.getCartesian().getNormalized().times(inverter), new Vector2(st01.getPhi() / phiMax, st01.getTheta() / thetaMax));
                    writer.invoke(st11.getCartesian(), st11.getCartesian().getNormalized().times(inverter), new Vector2(st11.getPhi() / phiMax, st11.getTheta() / thetaMax));
                    writer.invoke(st11.getCartesian(), st11.getCartesian().getNormalized().times(inverter), new Vector2(st11.getPhi() / phiMax, st11.getTheta() / thetaMax));
                    writer.invoke(st10.getCartesian(), st10.getCartesian().getNormalized().times(inverter), new Vector2(st10.getPhi() / phiMax, st10.getTheta() / thetaMax));
                    writer.invoke(st00.getCartesian(), st00.getCartesian().getNormalized().times(inverter), new Vector2(st00.getPhi() / phiMax, st00.getTheta() / thetaMax));
                }
                ++s2;
            }
            ++t;
        }
    }

    public static /* synthetic */ void generateSphere$default(int n, int n2, double d, boolean bl, Function3 function3, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        SphereKt.generateSphere(n, n2, d, bl, function3);
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateHemisphere(int sides, int segments, double radius, boolean invert2, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> writer) {
        Intrinsics.checkParameterIsNotNull(writer, "writer");
        double inverter = invert2 ? -1.0 : 1.0;
        int n = 0;
        int n2 = segments;
        while (n < n2) {
            void t;
            int n3 = 0;
            int n4 = sides;
            while (n3 < n4) {
                void s2;
                Spherical st00 = new Spherical(radius, (double)s2 * Math.PI * 2.0 / (double)sides, (double)t * Math.PI * 0.5 / (double)segments);
                Spherical st01 = new Spherical(radius, (double)s2 * Math.PI * 2.0 / (double)sides, (double)(t + true) * Math.PI * 0.5 / (double)segments);
                Spherical st10 = new Spherical(radius, (double)(s2 + true) * Math.PI * 2.0 / (double)sides, (double)t * Math.PI * 0.5 / (double)segments);
                Spherical st11 = new Spherical(radius, (double)(s2 + true) * Math.PI * 2.0 / (double)sides, (double)(t + true) * Math.PI * 0.5 / (double)segments);
                double thetaMax = 1.5707963267948966;
                double phiMax = Math.PI * 2;
                switch (t) {
                    case 0: {
                        writer.invoke(st00.getCartesian(), st00.getCartesian().getNormalized().times(inverter), new Vector2(st00.getPhi() / phiMax, st00.getTheta() / thetaMax));
                        writer.invoke(st01.getCartesian(), st01.getCartesian().getNormalized().times(inverter), new Vector2(st01.getPhi() / phiMax, st01.getTheta() / thetaMax));
                        writer.invoke(st11.getCartesian(), st11.getCartesian().getNormalized().times(inverter), new Vector2(st11.getPhi() / phiMax, st11.getTheta() / thetaMax));
                        break;
                    }
                    default: {
                        writer.invoke(st00.getCartesian(), st00.getCartesian().getNormalized().times(inverter), new Vector2(st00.getPhi() / phiMax, st00.getTheta() / thetaMax));
                        writer.invoke(st01.getCartesian(), st01.getCartesian().getNormalized().times(inverter), new Vector2(st01.getPhi() / phiMax, st01.getTheta() / thetaMax));
                        writer.invoke(st11.getCartesian(), st11.getCartesian().getNormalized().times(inverter), new Vector2(st11.getPhi() / phiMax, st11.getTheta() / thetaMax));
                        writer.invoke(st11.getCartesian(), st11.getCartesian().getNormalized().times(inverter), new Vector2(st11.getPhi() / phiMax, st11.getTheta() / thetaMax));
                        writer.invoke(st10.getCartesian(), st10.getCartesian().getNormalized().times(inverter), new Vector2(st10.getPhi() / phiMax, st10.getTheta() / thetaMax));
                        writer.invoke(st00.getCartesian(), st00.getCartesian().getNormalized().times(inverter), new Vector2(st00.getPhi() / phiMax, st00.getTheta() / thetaMax));
                    }
                }
                ++s2;
            }
            ++t;
        }
    }

    public static /* synthetic */ void generateHemisphere$default(int n, int n2, double d, boolean bl, Function3 function3, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        SphereKt.generateHemisphere(n, n2, d, bl, function3);
    }
}

