#version 430

in vec2 uv;

layout(location = 0) out vec4 frag;

uniform float g_time;

/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
*/

uniform float flip=1.0;

uniform float overlayAlpha=1.0;


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texPrev;

uniform float pixelSize = 1.0;

void main() {

    vec2 uvS = uv;
    uvS.y = 1.0-uvS.y;

    ivec2 texSize = textureSize(tex, 0);

    vec2 ct = gl_FragCoord.xy-vec2(texSize)*0.5;

    vec4 screen = texelFetch(tex, ivec2(vec2(ivec2(ct/pixelSize))*pixelSize+vec2(texSize)*0.5), 0);
    screen.a = 1.0;
    frag = screen;
}

