import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
  id: effect
  name: "lighter"
  effectName: "Lighter"

  property real lightPosX: s("pos.x", 0.0)
  property real lightPosY: s("pos.y", 0.0)
  property real lightPosZ: s("pos.z", 0.0)

  property real lightUpX: s("up.x", 0.0)
  property real lightUpY: s("up.y", 1.0)
  property real lightUpZ: s("up.z", 0.0)

  property real lightLookAtX: s("lookAt.x", 0.0)
  property real lightLookAtY: s("lookAt.y", 0.0)
  property real lightLookAtZ: s("lookAt.z", 0.0)

  property real lightCamDist: s("cam.dist", 1.0)

  RenderTarget {
    RenderTargetLayer {
      textureRT: "view"+effect.name; format: "RGBA32F";
      width: demo.windowWidth; height: demo.windowHeight
      Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; cD: 1.0 }
    }

    Camera {
      x: (lightPosX-lightLookAtX)*lightCamDist+lightLookAtX;
      y: (lightPosY-lightLookAtY)*lightCamDist+lightLookAtY;
      z: (lightPosZ-lightLookAtZ)*lightCamDist+lightLookAtZ;
      lookAtX: lightLookAtX; lookAtY: lightLookAtY; lookAtZ: lightLookAtZ
      upX: lightUpX; upY: lightUpY; upZ: lightUpZ
    }

    DrawVB { clearDepth: true; type: "emptyVBO"; storeView: "view"+effect.name }


    Shader { file: "meshLight" }
    ReDraw {
      reDrawGroups: "shadow,collider"
      useDrawShaders: false
    }

    BreakIn {
      name: "breakin1"
      drawOnly: true
    }

    // yea s-u-x but true - easier like this'so
    Mesher {
      name: "mesher1"
      drawOnly: true
    }

    Camera { // back to flyCam
      property vector3d pos: flyCam.getCamPosSmooth()
      property vector3d lookAt: flyCam.getCamLookAtSmooth()
      property vector3d up: flyCam.getCamUpSmooth()

      x: pos.x; y: pos.y; z: pos.z
      lookAtX: lookAt.x; lookAtY: lookAt.y; lookAtZ: lookAt.z
      upX: up.x; upY: up.y; upZ: up.z
      viewAngle: flyCam.camViewAngle
    }

  }

}
