

class OffsetCam
{
	
	void set_center(Transform t) { mCenter = t; mOffset = mCenter.position; }
	Transform get_center() { return mCenter;}
	weakref<Object> observed;
	pFloat offset = 5.0f;
	
	
	protected Transform mCenter;
	protected Quaternion mYaw; 
	protected Quaternion mPitch;
	protected Vector3 mOffset;
	protected pFloat mDistance = 5.0f;
	protected bool mActivated = false;
	protected Camera@ mCam;
	protected Control@ mControl;

	void set_projection(const Projection &in p) {
		mCam.projection = p;
	}
	
	
	OffsetCam(pFloat fov, pFloat aspect, pFloat near, pFloat far, Control@ control)  {

		@mControl = control;
		@mCam = Camera(60, aspect, near, far);
		mControl.stepped += StepCallback(this.step);
	}
	
	void activate() {
		mActivated = true;
	}
	
	void deactivate() {
		mActivated = false;
	}
	
	void enable() {
		mCam.enable();
	}
	
	void disable() {
		mCam.disable();
	}
	
	void setDistance(pFloat d) 
	{
		mDistance = d;
	}

	//Cast operator
	Camera@ opImplConv() const { return mCam; }
	Object@ opImplConv() const { return cast<Object@>(mCam); }
	
	private void step(pFloat dt)
	{
		auto object = observed.get();
		if (object is null) return;


		Vector3 dir = mCenter.position - object.position;

		if (dir.length2() < offset * offset) {
			
		} else 
			mOffset = object.position + (dir.normalized() * offset);
			//Set offset
		Vector3 offset = mOffset +  mCam.xForm.quaternion.rotVector3(Vector3(0,-mDistance,0));
		mCam.position = offset;
	
	}
}
