

class FreeCam
{
	
	protected pFloat CamSpeed = 0.003;
	protected Quaternion Yaw; 
	protected Quaternion Pitch;
	protected bool mActivated = false;
	protected Control@ mControl;
	protected Window@ mWindow;
	protected Camera@ mCam;

	FreeCam(pFloat fov, pFloat aspect, pFloat near, pFloat far, Control@ control, Window@ window)  {

		@mControl = control;
		@mWindow = window;
		@mCam = Camera(60, aspect, near, far);
		//Let's put the camera back a bit, so that we're looking at 0,0,0 from a distance
		mControl.stepped += StepCallback(this.step);
	}
	
	void activate() {
		mActivated = true;
	}
	
	void deactivate() {
		mActivated = false;
	}
	
	void enable() {
		mCam.enable();
	}
	
	void disable() {
		mCam.disable();
	}

	//Cast operator
	Camera@ opImplConv() const { return mCam; }
	Object@ opImplConv() const { return cast<Object@>(mCam); }
	
	private void step(pFloat dt)
	{
		if (!mActivated) return ;
		
		if (mControl.Input.keyIsPressed(PK_w))
		mCam.relTranslate(0, dt * CamSpeed, 0);
		if (mControl.Input.keyIsPressed(PK_s))
		mCam.relTranslate(0, dt * -CamSpeed, 0);
		if (mControl.Input.keyIsPressed(PK_a))
		mCam.relTranslate(dt * -CamSpeed, 0, 0);
		if (mControl.Input.keyIsPressed(PK_d))
		mCam.relTranslate(dt * CamSpeed, 0, 0);
		if (mControl.Input.keyIsPressed(PK_q))
		mCam.relTranslate(0, 0, dt * CamSpeed);
		if (mControl.Input.keyIsPressed(PK_e))
		mCam.relTranslate(0, 0, dt * -CamSpeed);
				
		pInt newX, newY;
		getCursorPos(newX, newY);
		
		pInt divX = newX - (mWindow.width / 2); 
		pInt divY = newY - (mWindow.height / 2);
		
		Yaw *= Quaternion(Vector3(0.0,0.0, 1.0), -divX * 0.001);
		Pitch *= Quaternion(Vector3(1.0,0.0, 0.0), -divY *  0.001);
		
		mCam.setRotation(Yaw * Pitch);
		mWindow.setCursorPos(mWindow.width/2, mWindow.height /2);
	}

}
