#include "../SimpleSceneBase.as"
#include "Button.as"
#include "FancyMenuButton.as"

class MainMenu : SimpleSceneBase
{
	bool Started = false;
	private GUI@ mGui;
	bool mActive = false;
	Scene@ mBGScene;

	FancyMenuButton@ mStartButton;
	FancyMenuButton@ mLevelSelectButton;
	FancyMenuButton@ mQuitButton;
	FancyMenuButton@ mCreditsButton;
  private LevelSelection@ mLevelSelection;
	private Camera@ mBGCamera;



	MainMenu( Control@ control, Window@ window, ResourcePool@ pool, String@ resourcedir)
	{
		super(control, window, pool, resourcedir);
		

		//loadAwesomeBackground(); 
		pFloat hW = mWindow.width * 0.5;
		pFloat hH = mWindow.height * 0.5;

		@mCam = Camera(-hW, hW, hH, -hH, -100, 100);
		@mBGCamera = Camera(-1920 *0.5, 1920* 0.5, 1080* 0.5, -1080 * 0.5, 0, 10);
		mScene.add(mCam);
		
				mViewport.addCamera(1, mBGCamera);
		mViewport.addCamera(2, mCam);


		@mBGScene = Scene(Partition());
		mBGScene.add(mBGCamera);

	//	mViewport.disableClear(); //enable clear color (or don't, whatever suits your usecase best) Default is BLACK

		auto background = GAME.objectFactory.createPoster(GAME.assetRoot + "3D/Menu/menu_bg.png");
    mBGScene.add(background);
		background.model.setDrawMode(DM_EMISSIVE);
    background.translate(0,10,0);
	
    @mGui = GUI(window, mScene);
	//  pUInt offset = 120;
			pInt pos = -50;
			pInt xPos = -300;

			@mStartButton = FancyMenuButton(mScene, "Start game");
			mStartButton.position = Vector3(xPos,0,pos);
			@mStartButton.onButtonUp = Action(this.startGame);
			pUInt offset = pUInt(mStartButton.sizes.z) + 10;

			@mLevelSelectButton = FancyMenuButton(mScene, "Select level");
			mLevelSelectButton.position = Vector3(xPos,0,pos -= offset);
			@mLevelSelectButton.onButtonUp = Action(this.selectLevel);

			@mCreditsButton = FancyMenuButton(mScene,  "Credits");
      mCreditsButton.position = Vector3(xPos,0,pos -= offset);
      @mCreditsButton.onButtonUp = Action(this.showCredits);

			@mQuitButton = FancyMenuButton(mScene,  "Quit");
      mQuitButton.position = Vector3(xPos,0,pos -= offset);
      @mQuitButton.onButtonUp = Action(this.quitGame);

		
			mGui.addButton(1, mStartButton);
			mGui.addButton(2, mLevelSelectButton);
			mGui.addButton(3, mCreditsButton);
			mGui.addButton(4, mQuitButton);

			@mLevelSelection = LevelSelection(control, window, pool, GAME.assetRoot, GAME.levelInfo);
			@mLevelSelection.onCancel = Action(this.selectLevelCancel);
			@mLevelSelection.onStartLevel = StartLevelCB(this.startSelectedGame);
	}

//NOPE
	// void loadAwesomeBackground() 
	// {
	// 		@mBGScene = Scene(OctreePartition());
	// //			Level@ level = Level(mBGScene);
	// 		//level.load();
	// 		auto obj = GAME.objectFactory.load(GAME.assetRoot + "/3D/Menu/menu_scene.fbx");
	// 		mBGScene.add(obj);

	// 		@mBGCamera = Camera(40, mWindow.width / float(mWindow.height), 0.5, 50);
	// 		mBGScene.add(mBGCamera);

	// 		auto dl = DirectionalLight();
	// 		dl.rotate(0,0,1, PI);
	// 		dl.rotate(1,0,0, -0.25 * PI);
	// 		mBGScene.add(dl);

	// 		mBGCamera.translate(1.0, 2.5, 1.4);
	// 		mBGCamera.rotate(0, 0, 1, 0.90 * PI);
	// 		mBGCamera.relRotate(1, 0, 0,-0.05 * PI);
	// 		mViewport.addCamera(1, mBGCamera);
	// }

	
	void release() {
			mScene.clear();
			@mScene = null;
			mLevelSelection.release();
	}


	private void onWindowResize(Window@ w, pUInt width, pUInt height) {
		pFloat hW = w.width * 0.5;
    pFloat hH = w.height * 0.5;


		Projection p(-hW, hW, -hH, hH, -100, 100);
		mViewport.width = w.width;
		mViewport.height = w.height;
    mCam.projection = p;

		// Projection p2(60, mWindow.width / float(mWindow.height), 0.5, 50);
		// mBGCamera.projection = p2;

		mLevelSelection.onWindowResize(w, width, height);
	}
	
	
	void Show() {
		if (mActive) return;
		mActive = true;

		SimpleSceneBase::Show();
		echo("Showing: "+ String(mViewportIdx));
		GAME.audio.stopLevelMusic();
		GAME.audio.playMainMenuMusic();
    mGui.activate();
	}

	void Hide() {
		if (!mActive) return;
		mActive = false;


    echo("Hiding: "+ String(mViewportIdx));
		SimpleSceneBase::Hide();
		
		mGui.deactivate();
		GAME.audio.stopMainMenuMusic();
	}
	
	private void startGame() {
		Hide();
		GAME.NewGame();
	}

	private void selectLevel() {
		mGui.deactivate();
		mLevelSelection.Show();
	}

	void selectLevelCancel() {
		mGui.activate();
	}

	void startSelectedGame(pUInt level) {
		Hide();
		GAME.NewGame(level);
	}

	void quitGame() {
			Hide();
			GAME.quit();
	}

	void showCredits() {
			Hide();
			GAME.showCredits();
	}
	
	
	~MainMenu()
    {
		echo ("Destroying MainMenu!");
    }
}