#include "Gui.as"
#include "FancyMenuButton.as"
#include "../Credits.as"

class GameOverScreen : SimpleSceneBase
{
    
    Action@ onMainMenu;
    Action@ onExitGame;
    Action@ onResume;
    Action@ onOptions; 

    private GUI@ mGui;
    private FancyMenuButton@ mRestartButton;
    private FancyMenuButton@ mBackToMainButton;
    private FancyMenuButton@ mQuitButton;
    private DirectionalLight@ mLight;

    private bool mActive = false;
	
	GameOverScreen( Control@ control, Window@ window, ResourcePool@ pool, String@ resourcedir)
	{
        super(control, window, pool, resourcedir);

        pFloat hW = mWindow.width * 0.5;
        pFloat hH = mWindow.height * 0.5;

        @mCam = Camera(-hW, hW, hH, -hH, -100, 100);

		mScene.add(mCam);
  
		mViewport.addCamera(0, mCam);
        mViewport.disableClear();

        @mLight = DirectionalLight();
        mScene.add(mLight);

        @mGui = GUI(window, mScene);

        pInt pos = 300;
        
        BitmapFont@ myFont = GAME.resourcePool.getBitmapFont(GAME.assetRoot + "Fonts/blightfont.fnt");
	 	Label@ msg = Label(myFont, "YOU DIED");
        msg.model.setColor(RED);
        msg.applyScale(2);
        mScene.add(msg);
       
        msg.position = Vector3(-msg.width * 0.5,0,pos);

        pos -= 200;

        @mRestartButton = FancyMenuButton(mScene, "Restart level");
        mRestartButton.position = Vector3(0,0,pos);
        @mRestartButton.onButtonUp = Action(this.restartLevel);
        pUInt offset = pUInt(mRestartButton.sizes.z) + 10;

        @mBackToMainButton = FancyMenuButton(mScene, "Back to main");
        mBackToMainButton.position = Vector3(0,0,pos -= offset);
        @mBackToMainButton.onButtonUp = Action(this.backToMain);

        @mQuitButton = FancyMenuButton(mScene,  "Quit");
        mQuitButton.position = Vector3(0,0,pos -= offset);
        @mQuitButton.onButtonUp = Action(this.Quit);

        mGui.addButton(1, mRestartButton);
        mGui.addButton(2, mBackToMainButton);
        mGui.addButton(3, mQuitButton);
    }

    void release() {
        mScene.clear();
        @mScene = null;

    }

    ~GameOverScreen( ) {
    }
   
    
    private void onWindowResize(Window@ w, pUInt width, pUInt height) {
		pFloat hW = w.width * 0.5;
    	pFloat hH = w.height * 0.5;

		Projection p(-hW, hW, -hH, hH, -100, 100);
        mViewport.width = w.width;
        mViewport.height = w.height;
    	mCam.projection = p;
	}

    void restartLevel() {
        GAME.restartLevel();
        Hide();
    }

    void backToMain() {
        GAME.ShowMenu();
        Hide();
    }
    
    void Quit() {
        Hide();
        GAME.quit();
    }
    	
	void Show() {
        mActive = true;
		SimpleSceneBase::Show();
        mGui.activate();
	}
    
	void Hide() {
        mActive = false;
        mGui.deactivate();
		SimpleSceneBase::Hide();
	}


}