#include "Gui.as"
#include "FancyMenuButton.as"
#include "../Credits.as"

class GameEndScreen : SimpleSceneBase
{    
    Action@ onMainMenu;
    Action@ onExitGame;
    Action@ onResume;
	Action@ onOptions; 
 
    private GUI@ mGui;
    private FancyMenuButton@ mBackToMainButton;
    private FancyMenuButton@ mQuitButton;
    private DirectionalLight@ mLight;
    private Object@ mBackground;

    private bool mActive = false;
    private Label@ mCredits;
	private ObjectAnimation@ mScrollAnim;
	private ObjectAnimation@ mScrollPicAnim;
	private bool mButtonsEnabled = false;
	private Object@ mPic;
	
	GameEndScreen( Control@ control, Window@ window, ResourcePool@ pool, String@ resourcedir)
	{
        super(control, window, pool, resourcedir);

        pFloat hW = mWindow.width * 0.5;
        pFloat hH = mWindow.height * 0.5;

        @mCam = Camera(-hW, hW, hH, -hH, -100, 100);

        auto background = GAME.objectFactory.createPoster(GAME.assetRoot + "3D/Menu/end_screen.png");
        mScene.add(background);
        background.translate(0,10,0);
        

		mScene.add(mCam);
  
		mViewport.addCamera(0, mCam);
        mViewport.disableClear();

        @mLight = DirectionalLight();
        mScene.add(mLight);

        @mGui = GUI(window, mScene);

        int pos = 0;

        @mBackToMainButton = FancyMenuButton(mScene, "Back to main");
        mBackToMainButton.position = Vector3(0,-50,pos);
        @mBackToMainButton.onButtonUp = Action(this.backToMain);
        pUInt offset = pUInt(mBackToMainButton.sizes.z) + 10;
        mBackToMainButton.disable();

        @mQuitButton = FancyMenuButton(mScene,  "Quit");
        mQuitButton.position = Vector3(0,-50,pos -= offset);
        @mQuitButton.onButtonUp = Action(this.Quit);
        mQuitButton.disable();

        mGui.addButton(1, mBackToMainButton);
        mGui.addButton(1, mQuitButton);

        mControl.Input.keyDown(PK_ESCAPE) +=  KeyStateCallback(this.toggleButtons);

		BitmapFont@ myFont = GAME.resourcePool.getBitmapFont(GAME.assetRoot + "Fonts/blightfont.fnt");
	 	@mCredits = Label(myFont, CREDITS);
		mCredits.position = Vector3(-300,0,-400);
		@mCredits.animator = Animator();
		
		mCredits.animator.animationEnded += AnimEndedCallback(this.animEnded);
		
		@mScrollAnim = ObjectAnimation("scroll");
		mScrollAnim.addFrames(Vector3(-300, 0, -400), Vector3(-300, 0, 2820));
		mScrollAnim.build(IM_LINEAR);
		
		@mScrollPicAnim = ObjectAnimation("scrollPic");
		//mScrollPicAnim.addFrames(Vector3(-300, 0, 0), Vector3(-300, 0, 950));
		mScrollPicAnim.addFrames(Vector3(-300, 0, 0), Vector3(-300, 0, 500));
		mScrollPicAnim.build(IM_LINEAR);
		
	    @mPic = GAME.objectFactory.load(GAME.assetRoot + "3D/Menu/pikologo.fbx");
		@mPic.animator = Animator();
		
		//mPic.animator.animationEnded += AnimEndedCallback(this.animEnded);
		
        mScene.add(mCredits);
    }
	
	void animEnded(Entity@ entity, Animation@ anim) {
		if (@mCredits == @entity) {
			echo("PLAYING IMAGE SCROLLER");
			mScene.remove(mCredits);
			mPic.position = Vector3(0,0,-550);
			mScene.add(mPic);	
			mPic.animator.play(mScrollPicAnim, false, 0.06);
		}
		//if (@mPic == @entity) {
			//echo("PLAYING CREDITS SCROLLER");
			//mCredits.position = Vector3(-300,0,-400);
			//mCredits.animator.play(mScrollAnim, false, 0.02);
		//}
	}
    
	void release() {
        mScene.clear();
        @mScene = null;
    }

    ~GameEndScreen( ) {
    }

    void toggleButtons(pKeyCode key) {
		if (!mActive) return;

		if (!mButtonsEnabled) {
			echo ("SHOW BUTTONS");
			mQuitButton.enable();
			mBackToMainButton.enable();
			mButtonsEnabled = true;
		}
		else{
			mQuitButton.disable();
			mBackToMainButton.disable();
			mButtonsEnabled = false;
		}
    }
   
    
    private void onWindowResize(Window@ w, pUInt width, pUInt height) {
		pFloat hW = w.width * 0.5;
    	pFloat hH = w.height * 0.5;

		Projection p(-hW, hW, -hH, hH, -100, 100);
        mViewport.width = w.width;
        mViewport.height = w.height;
    	mCam.projection = p;
	}

    void restartLevel() {
        GAME.restartLevel();
        Hide();
    }

    void backToMain() {
        Hide();
        GAME.ShowMenu();
    }
    
    void Quit() {
        Hide();
        GAME.quit();
    }
    	
	void Show() {
		mQuitButton.disable();
		mBackToMainButton.disable();
		mButtonsEnabled = false;

		SimpleSceneBase::Show();
		mScene.remove(mPic);
		mScene.add(mCredits);
		mCredits.position = Vector3(-300,0,-400);
		GAME.audio.playNextLevelMusic();
		mCredits.animator.play(mScrollAnim, false, 0.02);
		
        mActive = true;
        mGui.activate();

	}
    
	void Hide() {
		mCredits.animator.stopAll();
		mPic.animator.stopAll();
        mActive = false;
        mGui.deactivate();
		SimpleSceneBase::Hide();
	}


}