class Portal
{
    private Object@ mObject;
    private bool mActivated = false;
    private Location mLocation;
    private Scene@ mScene;
    private PointLight@ mPointLight;
    private pFloat mTileSize = 0.0f;
    private Surface@ mAdditive;
    private Surface@ mEmissive;
	private OpenALSource@ mIdleSound;
	private OpenALSource@ mStartSound;
	private Timer@ mStartTimer;
	private pFloat mElapsed = 0.0;

    Location get_location() { return mLocation; }

    bool get_activated() { return mActivated; }

    Action@ Activated;

    Portal(Location loc, pFloat x, pFloat y, Scene@ scene, pFloat tilesize) {
        mLocation = loc;
        @mScene = scene;
        mTileSize = tilesize;

        @mObject  =  GAME.objectFactory.load(GAME.assetRoot + "/3D/Tiles/portal.fbx");
        mObject.setScale(tilesize);
        mObject.setPosition(x, y, 0);

        //Don't think we need to merge these.. you will most likely only see one at a time,
        //making it more efficient if it gets culled.
        mScene.add(mObject);

       //HACK! DEADLINES!
       @mAdditive = mObject.model.getSurface("ADDITIVE_glow");
       mAdditive.material.mode = DM_ADDITIVE;
       @mEmissive = mObject.model.getSurface("UNLIT_portal");
       mEmissive.material.mode = DM_EMISSIVE;

        mAdditive.material.color = BLACK;
        mEmissive.material.color = BLACK;
		
		@mStartTimer = GAME.control.createTimer(1000, true);
		mStartTimer.elapsed += Action(this.tick);
		mStartTimer.stop();
		
		@mIdleSound = GAME.audio.createFXSource();
		@mStartSound = GAME.audio.createFXSource();
		mIdleSound.loop = true;
		mIdleSound.volume = 200.0;
    }
	
	void tick()
	{
		mElapsed += 1.0;
		if (mElapsed >= 5.0) {
			mIdleSound.play(GAME.resourcePool.getSound(GAME.assetRoot + "Sounds/portal_idle.ogg"));
			
			mStartTimer.stop();
			mElapsed = 0.0;
		}
	}

    void activate() {
        if (mActivated) return;
        mObject.model.setColor(WHITE);
        mActivated = true;
		
		mStartSound.play(GAME.resourcePool.getSound(GAME.assetRoot + "Sounds/portal_start.ogg"));
		mStartTimer.start();

        @mPointLight = PointLight(mTileSize * 2);
        mPointLight.color = Color(79, 185, 204, 255); 
        mPointLight.position = mObject.position;
        mPointLight.translate(0,0, mTileSize * 0.2);
        mScene.add(mPointLight);

        if (Activated !is null)
            Activated();
    }

    void reset() {
		mStartTimer.stop();
		mElapsed = 0.0;
		
		mStartSound.stop();
		mStartSound.stop();
	
        mActivated = false;
        mAdditive.material.color = BLACK;
        mEmissive.material.color = BLACK;
        mScene.remove(mPointLight);
        @mPointLight = null;
    }
}; 