class Character : iRefObj
{
	weakref<Object> mModel;

	Character(const Transform &in xForm)
	{
	
		Object@ model = OBJECTFACTORY.createCapsule(0.20, 1.3);
		Proxy@ p = MAIN_SCENE.world.createCharacterProxy();
		p.collisionGroupBitmask = COL_CHARACTER;
		@model.proxy = p;
		
		//@model.proxy = MAIN_SCENE.world.createProxy(PT_STATIC);
		model.proxy.addCapsule(0.20, 1.3);
		model.xForm = xForm;

		MAIN_SCENE.add(model);
		//model.translate(0,0,);

		@model.userRef = this;
		@mModel = model;
	}
	
	 ~Character()
    {
		auto@ model = mModel.get();
		if (model !is null) {
			MAIN_SCENE.remove(model);
			@model.userRef = null;
		}
		
		echo ("Destroying Character...");
      // Perform explicit cleanup here
    }
}
