

class Audio
{
	private OpenALDevice@ mAudioDevice;
	private OpenALContext@ mAudioContext;
	private Scene@ mAudioScene;
	private Array<String> mLevelMusicList;
	private Array<OpenALSource@> mLevelFXSrcList;
	private Array<OpenALSource@> mLevelMusicSrcList;
	private Array<OpenALSource@> mMenuMusicSrcList;
	private Array<pFloat> mLevelMusicTotalTimesList;
	private int mCurrentLevelMusicIndex = -1;
	private Timer@ mMusicTimer;
	private pFloat mMusicElapsed = 0.0;

	private Array<pFloat> mLevelFXVolumeList;
	private Array<pFloat> mLevelMusicVolumeList;
	private Array<pFloat> mMenuMusicVolumeList;
	
	private OpenALSource@ mMainMenuMusic;
	private pFloat mMainMenuMusicVolume = 0.0;
	
	private ResourcePool@ mPool;
	private String mAssetRoot;
	private bool mMute;
	private bool mPlayingTitleMusic = false;
	
	Audio(ResourcePool@ pool, Control@ _control, String assetRoot)  {

		mAssetRoot = assetRoot;
		@mPool = pool;
		@mAudioDevice = OpenALDevice();
		@mAudioScene = Scene(Partition());
		@mAudioContext = mAudioDevice.createContext(mAudioScene);
		mMute = false;
		
		@mMusicTimer = _control.createTimer(1000, true);
		mMusicTimer.elapsed += Action(this.musicTick);
		mMusicTimer.stop();
		
		@mMainMenuMusic = mAudioContext.createSource();
		mMainMenuMusic.loop = true;
		
		setupLvlMusic();
	}
	
	void setMusicVolume(pFloat v)
	{
		for (pUInt i=0; i<mLevelMusicSrcList.length(); ++i) {
			mLevelMusicSrcList[i].volume = v;
		}
		
		for (pUInt i=0; i<mMenuMusicSrcList.length(); ++i) {
			mMenuMusicSrcList[i].volume = v;
		}
		
		mMainMenuMusic.volume = v;
	}

	void setFXVolume(pFloat v)
	{
		for (pUInt i=0; i<mLevelFXSrcList.length(); ++i) {
			mLevelFXSrcList[i].volume = v;
		}
	}
	
	void playMainMenuMusic()
	{
		if (mPlayingTitleMusic) return;
		mPlayingTitleMusic = true;
		mMainMenuMusic.play(mPool.getSound(mAssetRoot + "Music/Dascon_Blight-Title.ogg"));
	}
	
	void stopMainMenuMusic()
	{
		mPlayingTitleMusic = false;
		mMainMenuMusic.stop();
	}
	
	void mute()
	{
		if (mMute) return;
	
		mLevelFXVolumeList.clear();
		for (pUInt i=0; i<mLevelFXSrcList.length(); ++i) {
			mLevelFXVolumeList.add(mLevelFXSrcList[i].volume);
			mLevelFXSrcList[i].volume = 0.0;
		}
		
		mLevelMusicVolumeList.clear();
		for (pUInt i=0; i<mLevelMusicSrcList.length(); ++i) {
			mLevelMusicVolumeList.add(mLevelMusicSrcList[i].volume);
			mLevelMusicSrcList[i].volume = 0.0;
		}
		
		mMenuMusicVolumeList.clear();
		for (pUInt i=0; i<mMenuMusicSrcList.length(); ++i) {
			mMenuMusicVolumeList.add(mMenuMusicSrcList[i].volume);
			mMenuMusicSrcList[i].volume = 0.0;
		}
		
		mMainMenuMusicVolume = mMainMenuMusic.volume;
		mMainMenuMusic.volume = 0.0;

		mMute = true;
	}
	
	void unmute()
	{
		if (!mMute) return;
		
		for (pUInt i=0; i<mLevelFXVolumeList.length(); ++i) {
			mLevelFXSrcList[i].volume = mLevelFXVolumeList[i];
		}
		
		for (pUInt i=0; i<mLevelMusicVolumeList.length(); ++i) {
			mLevelMusicSrcList[i].volume = mLevelMusicVolumeList[i];
		}
		
		for (pUInt i=0; i<mMenuMusicSrcList.length(); ++i) {
			mMenuMusicSrcList[i].volume =  mMenuMusicVolumeList[i];
		}
		
		mMainMenuMusic.volume = mMainMenuMusicVolume;	

		mMute = false;		
	}
	
    private void musicTick() 
    {
        mMusicElapsed += 1.0;
		if (mMusicElapsed > mLevelMusicTotalTimesList[mCurrentLevelMusicIndex])
			playNextLevelMusic();
	}

	OpenALListener@ getListener()	
	{
		return mAudioContext.getListener();
	}
	
	void setupLvlMusic()
	{
		mCurrentLevelMusicIndex = -1;
		mMusicElapsed = 0.0;
		
		mLevelMusicList.clear();
		mLevelMusicList.add(mAssetRoot + "Music/Dascon_Blight-Levelmusic.ogg");
		mLevelMusicList.add(mAssetRoot + "Music/Virgill-Spliffhanger.ogg");
		mLevelMusicList.add(mAssetRoot + "Music/Alpaidus_Lowres kids (final2).ogg");
		mLevelMusicList.add(mAssetRoot + "Music/Alpaidus_Lost.ogg");

		mLevelMusicSrcList.clear();
		mLevelMusicSrcList.add(mAudioContext.createSource());
		mLevelMusicSrcList.add(mAudioContext.createSource());
		mLevelMusicSrcList.add(mAudioContext.createSource());
		mLevelMusicSrcList.add(mAudioContext.createSource());
		
		// added a 2 sec between songs
		pFloat delay = 2.0;
		mLevelMusicTotalTimesList.clear();
		mLevelMusicTotalTimesList.add(139 + delay); // 2min 19s (139s)
		mLevelMusicTotalTimesList.add(5874 + delay); // 5min 14s (5874s)
		mLevelMusicTotalTimesList.add(212 + delay); // 3min 32s (212s)
		mLevelMusicTotalTimesList.add(201 + delay); // 3min 21s (201s)
	}
	
	void playNextLevelMusic()
	{
		stopLevelMusic();
	
		mMusicElapsed = 0.0;
		mMusicTimer.start();
		mCurrentLevelMusicIndex = (mCurrentLevelMusicIndex + 1) % mLevelMusicSrcList.length();
		
		echo(String("Playing level Music: ", mCurrentLevelMusicIndex));
		mLevelMusicSrcList[mCurrentLevelMusicIndex].play(mPool.getSound(mLevelMusicList[mCurrentLevelMusicIndex]));
	}
	
	void playTitleMusic()
	{
		
	
	}
	
	void stopLevelMusic()
	{
		if (mCurrentLevelMusicIndex < 0) return;
	
		echo(String("Stopping level Music: ", mCurrentLevelMusicIndex));
		mLevelMusicSrcList[mCurrentLevelMusicIndex].stop();
		mMusicTimer.stop();
	}
	
	OpenALSource@ createMenuSource()
	{
		OpenALSource@ s = mAudioContext.createSource();
		mMenuMusicSrcList.add(s);
		
		if (mMute) {
			mMenuMusicVolumeList.add(s.volume);
			s.volume = 0.0;
		}
		return s;
	}
	
	OpenALSource@ createFXSource()
	{
		OpenALSource@ s = mAudioContext.createSource();
		mLevelFXSrcList.add(s);
		
		if (mMute) {
			mLevelFXVolumeList.add(s.volume);
			s.volume = 0.0;
		}
		
		return s;
	}
}
