/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.BezierKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2Kt;
import org.openrndr.math.Vector4;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.LineSegmentKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.SegmentProjection;
import org.openrndr.shape.ShapeKt;
import org.openrndr.shape.internal.BezierCubicSampler;
import org.openrndr.shape.internal.BezierQuadraticSampler;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ \u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0002J*\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u0003022\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030$2\u0006\u00105\u001a\u00020\u0003H\u0002J/\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u00107J\u000e\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u001eJ\u0006\u0010:\u001a\u00020\u0003J\u000e\u0010:\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u001eJ\u0014\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030$0$H\u0002J\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001e0$J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00030$J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\b\b\u0002\u0010>\u001a\u000203J\u000e\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u001eJ\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00000$2\u0006\u0010B\u001a\u00020\u001eJ\u001f\u0010C\u001a\u0004\u0018\u00010\u001e2\u0006\u0010D\u001a\u00020\u00032\b\b\u0002\u0010E\u001a\u00020\u001e\u00a2\u0006\u0002\u0010FJ\u000e\u0010G\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u001eJ\u000e\u0010H\u001a\u00020I2\u0006\u0010D\u001a\u00020\u0003J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00030$2\b\b\u0002\u0010K\u001a\u00020\u001eJ(\u0010L\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030$022\b\b\u0002\u0010K\u001a\u00020\u001eJ\u001a\u0010M\u001a\u00020\u00002\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0NJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u001eJ\u0019\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b2\u0006\u00109\u001a\u00020\u001e\u00a2\u0006\u0002\u0010PJ\u0016\u0010Q\u001a\u00020\u00002\u0006\u0010R\u001a\u00020\u001e2\u0006\u0010S\u001a\u00020\u001eJ\b\u0010T\u001a\u00020UH\u0016J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010V\u001a\u00020WR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00000$8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001aR\u0011\u0010*\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001c\u00a8\u0006X"}, d2={"Lorg/openrndr/shape/Segment;", "", "start", "Lorg/openrndr/math/Vector2;", "end", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "c0", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "c1", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "control", "", "(Lorg/openrndr/math/Vector2;[Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "clockwise", "", "getClockwise", "()Z", "getControl", "()[Lorg/openrndr/math/Vector2;", "[Lorg/openrndr/math/Vector2;", "cubic", "getCubic", "()Lorg/openrndr/shape/Segment;", "getEnd", "()Lorg/openrndr/math/Vector2;", "length", "", "getLength", "()D", "linear", "getLinear", "lut", "", "reduced", "getReduced", "()Ljava/util/List;", "reverse", "getReverse", "simple", "getSimple", "getStart", "angle", "o", "v1", "v2", "closest", "Lkotlin/Pair;", "", "points", "query", "copy", "(Lorg/openrndr/math/Vector2;[Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)Lorg/openrndr/shape/Segment;", "derivative", "t", "direction", "dpoints", "extrema", "extremaPoints", "size", "normal", "ut", "offset", "distance", "on", "point", "error", "(Lorg/openrndr/math/Vector2;D)Ljava/lang/Double;", "position", "project", "Lorg/openrndr/shape/SegmentProjection;", "sampleAdaptive", "distanceTolerance", "sampleAdaptiveNormals", "scale", "Lkotlin/Function1;", "split", "(D)[Lorg/openrndr/shape/Segment;", "sub", "t0", "t1", "toString", "", "transform", "Lorg/openrndr/math/Matrix44;", "openrndr-shape"})
public final class Segment {
    @NotNull
    private final Vector2 start;
    @NotNull
    private final Vector2 end;
    @NotNull
    private final Vector2[] control;
    private List<Vector2> lut;

    @NotNull
    public final Vector2 getStart() {
        return this.start;
    }

    @NotNull
    public final Vector2 getEnd() {
        return this.end;
    }

    @NotNull
    public final Vector2[] getControl() {
        return this.control;
    }

    public final boolean getLinear() {
        Vector2[] vector2Array = this.control;
        boolean bl = false;
        return vector2Array.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> lut(int size) {
        block7: {
            Collection<Vector2> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            block6: {
                if (this.lut == null) break block6;
                List<Vector2> list = this.lut;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (list.size() == size) break block7;
            }
            int n = 0;
            Iterable iterable = new IntRange(n, size);
            Segment segment = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                Vector2 vector2 = this.position((double)it / (double)size);
                collection.add(vector2);
            }
            collection = (List)destination$iv$iv;
            segment.lut = collection;
        }
        List<Vector2> list = this.lut;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    @NotNull
    public static /* synthetic */ List lut$default(Segment segment, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        return segment.lut(n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double on(@NotNull Vector2 point, double error) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        List lut = Segment.lut$default(this, 0, 1, null);
        int hits = 0;
        double t = 0.0;
        int n = 0;
        int n2 = lut.size();
        while (n < n2) {
            void i;
            if (((Vector2)lut.get((int)i)).minus(point).getSquaredLength() < error * error) {
                ++hits;
                t += (double)i / (double)lut.size();
            }
            ++i;
        }
        return hits > 0 ? Double.valueOf(t / (double)hits) : null;
    }

    @Nullable
    public static /* synthetic */ Double on$default(Segment segment, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return segment.on(vector2, d);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Vector2> closest(List<Vector2> points, Vector2 query) {
        int closestIndex = 0;
        Vector2 closestValue = points.get(0);
        double closestDistance = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        int n = 0;
        int n2 = points.size();
        while (n < n2) {
            void i;
            double distance = points.get((int)i).minus(query).getSquaredLength();
            if (distance < closestDistance) {
                closestIndex = i;
                closestValue = points.get((int)i);
                closestDistance = distance;
            }
            ++i;
        }
        return new Pair<Integer, Vector2>(closestIndex, closestValue);
    }

    @NotNull
    public final SegmentProjection project(@NotNull Vector2 point) {
        Vector2 p;
        Intrinsics.checkParameterIsNotNull(point, "point");
        List lut = Segment.lut$default(this, 0, 1, null);
        double l = lut.size() - 1;
        Pair<Integer, Vector2> closest = this.closest(lut, point);
        double closestDistance = point.minus(closest.getSecond()).getSquaredLength();
        if (((Number)closest.getFirst()).intValue() == 0 || ((Number)closest.getFirst()).intValue() == lut.size() - 1) {
            double t = (double)((Number)closest.getFirst()).intValue() / l;
            return new SegmentProjection(this, t, closestDistance, closest.getSecond());
        }
        double t1 = (double)(((Number)closest.getFirst()).intValue() - 1) / l;
        double t2 = (double)(((Number)closest.getFirst()).intValue() + 1) / l;
        double step = 0.1 / l;
        double ft = t1;
        for (double t = t1; t < t2 + step; t += step) {
            p = this.position(t);
            double d = p.minus(point).getSquaredLength();
            if (!(d < closestDistance)) continue;
            closestDistance = d;
            ft = t;
        }
        p = this.position(ft);
        return new SegmentProjection(this, ft, closestDistance, p);
    }

    @NotNull
    public final Segment transform(@NotNull Matrix44 transform) {
        Vector2[] vector2Array;
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        Vector2 tstart = transform.times(this.start.getXy01()).getDiv().getXy();
        Vector2 tend = transform.times(this.end.getXy01()).getDiv().getXy();
        switch (this.control.length) {
            case 2: {
                Vector2[] vector2Array2 = new Vector2[2];
                vector2Array2[0] = transform.times(this.control[0].getXy01()).getDiv().getXy();
                vector2Array = vector2Array2;
                vector2Array2[1] = transform.times(this.control[1].getXy01()).getDiv().getXy();
                break;
            }
            case 1: {
                Vector2[] vector2Array3 = new Vector2[1];
                vector2Array = vector2Array3;
                vector2Array3[0] = transform.times(this.control[0].getXy01()).getDiv().getXy();
                break;
            }
            default: {
                boolean $i$f$emptyArray = false;
                vector2Array = new Vector2[]{};
            }
        }
        Vector2[] tcontrol = vector2Array;
        return new Segment(tstart, tcontrol, tend);
    }

    @NotNull
    public final List<Vector2> sampleAdaptive(double distanceTolerance) {
        List<Vector2> list;
        switch (this.control.length) {
            case 0: {
                list = CollectionsKt.listOf(this.start, this.end);
                break;
            }
            case 1: {
                BezierQuadraticSampler bezierQuadraticSampler = new BezierQuadraticSampler();
                boolean bl = false;
                boolean bl2 = false;
                BezierQuadraticSampler $this$apply = bezierQuadraticSampler;
                boolean bl3 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                list = bezierQuadraticSampler.sample(this.start, this.control[0], this.end).getFirst();
                break;
            }
            case 2: {
                BezierCubicSampler bezierCubicSampler = new BezierCubicSampler();
                boolean bl = false;
                boolean bl4 = false;
                BezierCubicSampler $this$apply = bezierCubicSampler;
                boolean bl5 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                list = bezierCubicSampler.sample(this.start, this.control[0], this.control[1], this.end).getFirst();
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return list;
    }

    @NotNull
    public static /* synthetic */ List sampleAdaptive$default(Segment segment, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return segment.sampleAdaptive(d);
    }

    @NotNull
    public final Pair<List<Vector2>, List<Vector2>> sampleAdaptiveNormals(double distanceTolerance) {
        Pair<List<Vector2>, List<Vector2>> pair;
        switch (this.control.length) {
            case 0: {
                pair = new Pair<List<Vector2>, List<Vector2>>(CollectionsKt.listOf(this.start, this.end), CollectionsKt.listOf(this.end.minus(this.start), this.end.minus(this.start)));
                break;
            }
            case 1: {
                BezierQuadraticSampler bezierQuadraticSampler = new BezierQuadraticSampler();
                boolean bl = false;
                boolean bl2 = false;
                BezierQuadraticSampler $this$apply = bezierQuadraticSampler;
                boolean bl3 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                pair = bezierQuadraticSampler.sample(this.start, this.control[0], this.end);
                break;
            }
            case 2: {
                BezierCubicSampler bezierCubicSampler = new BezierCubicSampler();
                boolean bl = false;
                boolean bl4 = false;
                BezierCubicSampler $this$apply = bezierCubicSampler;
                boolean bl5 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                pair = bezierCubicSampler.sample(this.start, this.control[0], this.control[1], this.end);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return pair;
    }

    @NotNull
    public static /* synthetic */ Pair sampleAdaptiveNormals$default(Segment segment, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return segment.sampleAdaptiveNormals(d);
    }

    public final double getLength() {
        double d;
        switch (this.control.length) {
            case 0: {
                d = this.end.minus(this.start).getLength();
                break;
            }
            case 1: 
            case 2: {
                d = ShapeKt.access$sumDifferences(Segment.sampleAdaptive$default(this, 0.0, 1, null));
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return d;
    }

    @NotNull
    public final Vector2 position(double ut) {
        Vector2 vector2;
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        switch (this.control.length) {
            case 0: {
                vector2 = new Vector2(this.start.getX() * (1.0 - t) + this.end.getX() * t, this.start.getY() * (1.0 - t) + this.end.getY() * t);
                break;
            }
            case 1: {
                vector2 = BezierKt.bezier(this.start, this.control[0], this.end, t);
                break;
            }
            case 2: {
                vector2 = BezierKt.bezier(this.start, this.control[0], this.control[1], this.end, t);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return vector2;
    }

    @NotNull
    public final Vector2 direction() {
        return this.start.minus(this.end).getNormalized();
    }

    @NotNull
    public final Vector2 direction(double t) {
        return this.derivative(t).getNormalized();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> extrema() {
        List list;
        List<List<Vector2>> dpoints = this.dpoints();
        if (this.getLinear()) {
            list = CollectionsKt.emptyList();
        } else if (this.control.length == 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Double d;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = dpoints.get(0);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Vector2 vector2 = (Vector2)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                d = it.getX();
                collection.add(d);
            }
            List<Double> xRoots = BezierKt.roots((List)destination$iv$iv);
            Iterable $this$map$iv2 = dpoints.get(0);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Vector2 bl = (Vector2)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                d = it.getY();
                collection.add(d);
            }
            List<Double> yRoots = BezierKt.roots((List)destination$iv$iv2);
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                double d2 = it;
                if (!(d2 >= 0.0 && d2 <= 1.0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else if (this.control.length == 2) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Double d;
            Object object;
            Vector2 it;
            Collection collection;
            Iterable $this$mapTo$iv$iv3;
            Iterable $this$map$iv = dpoints.get(0);
            boolean $i$f$map = false;
            Iterable $i$f$filter = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Vector2 element$iv$iv = (Vector2)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = it.getX();
                collection.add(object);
            }
            $this$map$iv = dpoints.get(1);
            collection = BezierKt.roots((List)destination$iv$iv);
            $i$f$map = false;
            $this$mapTo$iv$iv3 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (Vector2)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                d = it.getX();
                object.add(d);
            }
            object = (List)destination$iv$iv;
            List xRoots = CollectionsKt.plus(collection, (Iterable)BezierKt.roots((List<Double>)object));
            Iterable $this$map$iv3 = dpoints.get(0);
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Vector2 bl = (Vector2)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                object = it2.getY();
                collection.add(object);
            }
            $this$map$iv3 = dpoints.get(1);
            collection = BezierKt.roots((List)destination$iv$iv3);
            $i$f$map3 = false;
            $this$mapTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Vector2 it2 = (Vector2)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                d = it2.getY();
                object.add(d);
            }
            object = (List)destination$iv$iv3;
            List yRoots = CollectionsKt.plus(collection, (Iterable)BezierKt.roots((List<Double>)object));
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Vector2 element$iv$iv : $this$filterTo$iv$iv) {
                double it3 = ((Number)((Object)element$iv$iv)).doubleValue();
                boolean bl = false;
                double d3 = it3;
                if (!(d3 >= 0.0 && d3 <= 1.0)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list = (List)destination$iv$iv3;
        } else {
            throw (Throwable)new RuntimeException("not supported");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> extremaPoints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.extrema();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Vector2 vector2 = this.position((double)it);
            collection.add(vector2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Rectangle getBounds() {
        return RectangleKt.vector2Bounds(CollectionsKt.plus((Collection)CollectionsKt.listOf(this.start, this.end), (Iterable)this.extremaPoints()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Vector2>> dpoints() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add(this.start);
        spreadBuilder.addSpread(this.control);
        spreadBuilder.add(this.end);
        List points = CollectionsKt.listOf((Vector2[])spreadBuilder.toArray(new Vector2[spreadBuilder.size()]));
        int d = points.size();
        int c2 = d - 1;
        boolean bl = false;
        List dpoints = new ArrayList();
        List p = points;
        while (d > 1) {
            int n = 0;
            List list = new ArrayList();
            n = 0;
            int n2 = c2;
            while (n < n2) {
                void j;
                list.add(new Vector2((double)c2 * (((Vector2)p.get((int)(j + true))).getX() - ((Vector2)p.get((int)j)).getX()), (double)c2 * (((Vector2)p.get((int)(j + true))).getY() - ((Vector2)p.get((int)j)).getY())));
                ++j;
            }
            dpoints.add(list);
            p = list;
            --d;
            --c2;
        }
        return dpoints;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Segment> offset(double distance) {
        List list;
        if (this.getLinear()) {
            Vector2 n = this.normal(0.0);
            list = CollectionsKt.listOf(new Segment(this.start.plus(Vector2Kt.times(distance, n)), this.end.plus(Vector2Kt.times(distance, n))));
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getReduced();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Segment segment = (Segment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Segment segment2 = it.scale(distance);
                collection.add(segment2);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final double angle(Vector2 o, Vector2 v1, Vector2 v2) {
        double dx1 = v1.getX() - o.getX();
        double dy1 = v1.getY() - o.getY();
        double dx2 = v2.getX() - o.getX();
        double dy2 = v2.getY() - o.getY();
        double cross = dx1 * dy2 - dy1 * dx2;
        double dot = dx1 * dx2 + dy1 * dy2;
        return Math.atan2(cross, dot);
    }

    public final boolean getSimple() {
        Vector2 n2;
        Vector2 n1;
        double s2;
        if (this.getLinear()) {
            return true;
        }
        if (this.control.length == 2) {
            double a1 = this.angle(this.start, this.end, this.control[0]);
            double a2 = this.angle(this.start, this.end, this.control[1]);
            if (a1 > 0.0 && a2 < 0.0 || a1 < 0.0 && a2 > 0.0) {
                return false;
            }
        }
        return (s2 = (n1 = this.normal(0.0)).dot(n2 = this.normal(1.0))) >= 0.9;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Segment> getReduced() {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        double step = 0.01;
        List<Double> extrema = this.extrema();
        if (extrema.isEmpty() || ((Number)extrema.get(0)).doubleValue() != 0.0) {
            extrema = CollectionsKt.plus((Collection)CollectionsKt.listOf(0.0), (Iterable)extrema);
        }
        if (((Number)CollectionsKt.last(extrema)).doubleValue() != 1.0) {
            extrema = CollectionsKt.plus((Collection)extrema, (Iterable)CollectionsKt.listOf(1.0));
        }
        Iterable $this$map$iv = CollectionsKt.zipWithNext((Iterable)extrema);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Segment segment = this.sub(((Number)it.getFirst()).doubleValue(), ((Number)it.getSecond()).doubleValue());
            collection.add(segment);
        }
        List pass1 = (List)destination$iv$iv;
        $i$f$map = false;
        List pass2 = new ArrayList();
        Iterable $this$forEach$iv = pass1;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Segment it = (Segment)element$iv;
            boolean bl = false;
            double t1 = 0.0;
            for (double t2 = step; t2 <= 1.0; t2 += step) {
                Segment segment = it.sub(t1, t2);
                if (segment.getSimple()) continue;
                pass2.add(segment);
                t1 = t2;
            }
            if (!(t1 < 1.0)) continue;
            pass2.add(it.sub(t1, 1.0));
        }
        Iterable $this$flatMap$iv = pass2;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Segment it = (Segment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList(it.split(0.5));
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public final Segment scale(double scale2) {
        return this.scale((Function1<? super Double, Double>)new Function1<Double, Double>(scale2){
            final /* synthetic */ double $scale;

            public final double invoke(double it) {
                return this.$scale;
            }
            {
                this.$scale = d;
                super(1);
            }
        });
    }

    public final boolean getClockwise() {
        return this.angle(this.start, this.end, this.control[0]) > 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Segment scale(@NotNull Function1<? super Double, Double> scale2) {
        void $this$toTypedArray$iv;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(scale2, "scale");
        if (this.control.length == 1) {
            return this.getCubic().scale(scale2);
        }
        Vector2 newStart = this.start.plus(this.normal(0.0).times(((Number)scale2.invoke((Double)0.0)).doubleValue()));
        Vector2 newEnd = this.end.plus(this.normal(1.0).times(((Number)scale2.invoke((Double)1.0)).doubleValue()));
        LineSegment a2 = new LineSegment(this.start.plus(this.normal(0.0).times(10.0)), this.start);
        LineSegment b = new LineSegment(this.end.plus(this.normal(1.0).times(10.0)), this.end);
        Vector2 o = LineSegmentKt.intersection(a2, b, 1.0E9);
        new LineSegment(newStart, newEnd);
        if (Intrinsics.areEqual(o, Vector2.Companion.getINFINITY()) ^ true) {
            void $this$toTypedArray$iv2;
            void $this$mapIndexedTo$iv$iv2;
            Object $this$mapIndexed$iv = this.control;
            boolean $i$f$mapIndexed = false;
            Vector2[] vector2Array = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(((Vector2[])$this$mapIndexed$iv).length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                void index;
                void it;
                int n = index$iv$iv++;
                void var18_27 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Vector2 d = it.minus(o);
                double rc = ((Number)scale2.invoke((Double)(((double)index + 1.0) / 3.0))).doubleValue();
                double d2 = this.normal(0.0).dot(d);
                boolean bl2 = false;
                double s2 = Math.signum(d2);
                Vector2 nd = d.getNormalized().times(s2);
                Vector2 vector2 = it.plus(Vector2Kt.times(rc, nd));
                collection.add(vector2);
            }
            List newControls = (List)destination$iv$iv;
            $this$mapIndexed$iv = newControls;
            Vector2 vector2 = newStart;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv2;
            Vector2[] vector2Array2 = thisCollection$iv.toArray(new Vector2[0]);
            if (vector2Array2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Vector2[] vector2Array3 = vector2Array2;
            Vector2 vector22 = newEnd;
            Vector2[] vector2Array4 = vector2Array3;
            Vector2 vector23 = vector2;
            return new Segment(vector23, vector2Array4, vector22);
        }
        Object $this$mapIndexed$iv = this.control;
        boolean $i$f$mapIndexed = false;
        Vector2[] thisCollection$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(((Vector2[])$this$mapIndexed$iv).length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            int n = index$iv$iv++;
            void it = item$iv$iv;
            int index = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double rc = ((Number)scale2.invoke((Double)(((double)index + 1.0) / 3.0))).doubleValue();
            Vector2 vector2 = it.plus(Vector2Kt.times(rc, this.normal(0.0)).times(this.getClockwise() ? 1.0 : -1.0));
            collection.add(vector2);
        }
        List newControls = (List)destination$iv$iv;
        $this$mapIndexed$iv = newControls;
        Vector2 vector2 = newStart;
        boolean $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        Vector2[] vector2Array = thisCollection$iv.toArray(new Vector2[0]);
        if (vector2Array == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Vector2[] vector2Array5 = vector2Array;
        Vector2 vector24 = newEnd;
        Vector2[] vector2Array6 = vector2Array5;
        Vector2 vector25 = vector2;
        return new Segment(vector25, vector2Array6, vector24);
    }

    @NotNull
    public final Segment getCubic() {
        Segment segment;
        if (this.control.length == 2) {
            segment = this;
        } else if (this.control.length == 1) {
            segment = new Segment(this.start, this.start.times(0.3333333333333333).plus(this.control[0].times(0.6666666666666666)), this.control[0].times(0.6666666666666666).plus(this.end.times(0.3333333333333333)), this.end);
        } else {
            throw (Throwable)new RuntimeException("cannot convert to cubic segment");
        }
        return segment;
    }

    @NotNull
    public final Vector2 derivative(double t) {
        Vector2 vector2;
        if (this.getLinear()) {
            vector2 = this.start.minus(this.end);
        } else if (this.control.length == 1) {
            vector2 = BezierKt.derivative(this.start, this.control[0], this.end, t);
        } else if (this.control.length == 2) {
            vector2 = BezierKt.derivative(this.start, this.control[0], this.control[1], this.end, t);
        } else {
            throw (Throwable)new RuntimeException("not implemented");
        }
        return vector2;
    }

    @NotNull
    public final Vector2 normal(double ut) {
        Vector2 vector2 = this.direction(ut);
        boolean bl = false;
        boolean bl2 = false;
        Vector2 it = vector2;
        boolean bl3 = false;
        return it.copy(it.getY() * -1.0, it.getX());
    }

    @NotNull
    public final Segment getReverse() {
        Segment segment;
        switch (this.control.length) {
            case 0: {
                segment = new Segment(this.end, this.start);
                break;
            }
            case 1: {
                segment = new Segment(this.end, this.control[0], this.start);
                break;
            }
            case 2: {
                segment = new Segment(this.end, this.control[1], this.control[0], this.start);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return segment;
    }

    @NotNull
    public final Segment sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? this.split(z0)[1] : this.split(z0)[1].split(MappingKt.map(z0, 1.0, 0.0, 1.0, z1))[0]);
    }

    @NotNull
    public final Segment[] split(double t) {
        double u = RangesKt.coerceIn(t, 0.0, 1.0);
        if (this.getLinear()) {
            Vector2 cut = this.start.plus(this.end.minus(this.start).times(u));
            return new Segment[]{new Segment(this.start, cut), new Segment(cut, this.end)};
        }
        if (this.control.length == 2) {
            double z = u;
            double z2 = z * z;
            double z3 = z * z * z;
            double iz = 1.0 - z;
            double iz2 = iz * iz;
            double iz3 = iz * iz * iz;
            Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3);
            Vector4 px = new Vector4(this.start.getX(), this.control[0].getX(), this.control[1].getX(), this.end.getX());
            Vector4 py = new Vector4(this.start.getY(), this.control[0].getY(), this.control[1].getY(), this.end.getY());
            Vector4 plx = lsm.times(px);
            Vector4 ply = lsm.times(py);
            Vector2 pl0 = new Vector2(plx.getX(), ply.getX());
            Vector2 pl1 = new Vector2(plx.getY(), ply.getY());
            Vector2 pl2 = new Vector2(plx.getZ(), ply.getZ());
            Vector2 pl3 = new Vector2(plx.getW(), ply.getW());
            Segment left = new Segment(pl0, pl1, pl2, pl3);
            Matrix44 rsm = new Matrix44(iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0);
            Vector4 prx = rsm.times(px);
            Vector4 pry = rsm.times(py);
            Vector2 pr0 = new Vector2(prx.getX(), pry.getX());
            Vector2 pr1 = new Vector2(prx.getY(), pry.getY());
            Vector2 pr2 = new Vector2(prx.getZ(), pry.getZ());
            Vector2 pr3 = new Vector2(prx.getW(), pry.getW());
            Segment right = new Segment(pr0, pr1, pr2, pr3);
            return new Segment[]{left, right};
        }
        if (this.control.length == 1) {
            double z = u;
            double iz = 1.0 - z;
            double iz2 = iz * iz;
            double z2 = z * z;
            Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, 0.0, 0.0, 0.0);
            Vector4 px = new Vector4(this.start.getX(), this.control[0].getX(), this.end.getX(), 0.0);
            Vector4 py = new Vector4(this.start.getY(), this.control[0].getY(), this.end.getY(), 0.0);
            Vector4 plx = lsm.times(px);
            Vector4 ply = lsm.times(py);
            Segment left = new Segment(new Vector2(plx.getX(), ply.getX()), new Vector2(plx.getY(), ply.getY()), new Vector2(plx.getZ(), ply.getZ()));
            Matrix44 rsm = new Matrix44(iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Vector4 prx = rsm.times(px);
            Vector4 pry = rsm.times(py);
            Segment right = new Segment(new Vector2(prx.getX(), pry.getX()), new Vector2(prx.getY(), pry.getY()), new Vector2(prx.getZ(), pry.getZ()));
            return new Segment[]{left, right};
        }
        throw (Throwable)new RuntimeException("not implemented");
    }

    @NotNull
    public String toString() {
        return "Segment(start=" + this.start + ", end=" + this.end + ", control=" + Arrays.toString(this.control) + ')';
    }

    @NotNull
    public final Segment copy(@NotNull Vector2 start, @NotNull Vector2[] control, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(control, "control");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        return new Segment(start, control, end2);
    }

    @NotNull
    public static /* synthetic */ Segment copy$default(Segment segment, Vector2 vector2, Vector2[] vector2Array, Vector2 vector22, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = segment.start;
        }
        if ((n & 2) != 0) {
            vector2Array = segment.control;
        }
        if ((n & 4) != 0) {
            vector22 = segment.end;
        }
        return segment.copy(vector2, vector2Array, vector22);
    }

    public Segment(@NotNull Vector2 start, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.end = end2;
        Segment segment = this;
        boolean $i$f$emptyArray = false;
        Vector2[] vector2Array = new Vector2[]{};
        segment.control = vector2Array;
    }

    public Segment(@NotNull Vector2 start, @NotNull Vector2 c0, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.control = new Vector2[]{c0};
        this.end = end2;
    }

    public Segment(@NotNull Vector2 start, @NotNull Vector2 c0, @NotNull Vector2 c1, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(c1, "c1");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.control = new Vector2[]{c0, c1};
        this.end = end2;
    }

    public Segment(@NotNull Vector2 start, @NotNull Vector2[] control, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(control, "control");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.control = control;
        this.end = end2;
    }
}

