/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extras.camera;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Spherical;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ;2\u00020\u0001:\u0001;B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0006J\u0006\u0010'\u001a\u00020%J\u0006\u0010(\u001a\u00020%J\u000e\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0006J\u001e\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006J\u000e\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u0003J\u0016\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0006J\u0016\u00103\u001a\u00020%2\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0006J\u000e\u00103\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003J\u001e\u00104\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u0006J\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020%2\u0006\u0010:\u001a\u00020\u0006R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\fR$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\f\u00a8\u0006<"}, d2={"Lorg/openrndr/extras/camera/OrbitalCamera;", "", "eye", "Lorg/openrndr/math/Vector3;", "lookAt", "fov", "", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;D)V", "dampingFactor", "getDampingFactor", "()D", "setDampingFactor", "(D)V", "dirty", "", "getFov", "setFov", "fovEnd", "getFovEnd", "setFovEnd", "<set-?>", "getLookAt", "()Lorg/openrndr/math/Vector3;", "setLookAt", "(Lorg/openrndr/math/Vector3;)V", "lookAtEnd", "Lorg/openrndr/math/Spherical;", "spherical", "getSpherical", "()Lorg/openrndr/math/Spherical;", "setSpherical", "(Lorg/openrndr/math/Spherical;)V", "sphericalEnd", "zoomSpeed", "getZoomSpeed", "setZoomSpeed", "dolly", "", "distance", "dollyIn", "dollyOut", "dollyTo", "pan", "x", "y", "z", "panTo", "target", "rotate", "rotX", "rotY", "rotateTo", "setView", "update", "timeDelta", "viewMatrix", "Lorg/openrndr/math/Matrix44;", "zoom", "degrees", "Companion", "orx-camera"})
public final class OrbitalCamera {
    @NotNull
    private Spherical spherical;
    @NotNull
    private Vector3 lookAt;
    private Spherical sphericalEnd;
    private Vector3 lookAtEnd;
    private boolean dirty;
    private double fovEnd;
    private double dampingFactor;
    private double zoomSpeed;
    private double fov;
    private static final double EPSILON = 1.0E-6;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Spherical getSpherical() {
        return this.spherical;
    }

    private final void setSpherical(Spherical spherical) {
        this.spherical = spherical;
    }

    @NotNull
    public final Vector3 getLookAt() {
        return this.lookAt;
    }

    private final void setLookAt(Vector3 vector3) {
        this.lookAt = vector3;
    }

    public final double getFovEnd() {
        return this.fovEnd;
    }

    public final void setFovEnd(double d) {
        this.fovEnd = d;
    }

    public final double getDampingFactor() {
        return this.dampingFactor;
    }

    public final void setDampingFactor(double d) {
        this.dampingFactor = d;
    }

    public final double getZoomSpeed() {
        return this.zoomSpeed;
    }

    public final void setZoomSpeed(double d) {
        this.zoomSpeed = d;
    }

    public final void setView(@NotNull Vector3 lookAt, @NotNull Spherical spherical, double fov) {
        Intrinsics.checkParameterIsNotNull(lookAt, "lookAt");
        Intrinsics.checkParameterIsNotNull(spherical, "spherical");
        this.lookAt = lookAt;
        this.lookAtEnd = lookAt;
        this.spherical = spherical;
        this.sphericalEnd = spherical;
        this.fov = fov;
        this.fovEnd = fov;
    }

    public final void rotate(double rotX, double rotY) {
        this.sphericalEnd = this.sphericalEnd.plus(new Spherical(0.0, rotX, rotY));
        this.sphericalEnd = this.sphericalEnd.makeSafe();
        this.dirty = true;
    }

    public final void rotateTo(double rotX, double rotY) {
        this.sphericalEnd = Spherical.copy$default(this.sphericalEnd, 0.0, rotX, rotY, 1, null);
        this.sphericalEnd = this.sphericalEnd.makeSafe();
        this.dirty = true;
    }

    public final void rotateTo(@NotNull Vector3 eye) {
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        this.sphericalEnd = Spherical.Companion.fromVector(eye);
        this.sphericalEnd = this.sphericalEnd.makeSafe();
        this.dirty = true;
    }

    public final void dollyIn() {
        double zoomScale = Math.pow(0.95, this.zoomSpeed);
        this.dolly(this.sphericalEnd.getRadius() * zoomScale - this.sphericalEnd.getRadius());
    }

    public final void dollyOut() {
        double zoomScale = Math.pow(0.95, this.zoomSpeed);
        this.dolly(this.sphericalEnd.getRadius() / zoomScale - this.sphericalEnd.getRadius());
    }

    public final void dolly(double distance) {
        this.sphericalEnd = this.sphericalEnd.plus(new Spherical(distance, 0.0, 0.0));
        this.dirty = true;
    }

    public final void pan(double x, double y, double z) {
        Matrix44 view2 = this.viewMatrix();
        Vector3 xColumn = new Vector3(view2.getC0r0(), view2.getC1r0(), view2.getC2r0()).times(x);
        Vector3 yColumn = new Vector3(view2.getC0r1(), view2.getC1r1(), view2.getC2r1()).times(y);
        Vector3 zColumn = new Vector3(view2.getC0r2(), view2.getC1r2(), view2.getC2r2()).times(z);
        this.lookAtEnd = this.lookAtEnd.plus(xColumn.plus(yColumn).plus(zColumn));
        this.dirty = true;
    }

    public final void panTo(@NotNull Vector3 target2) {
        Intrinsics.checkParameterIsNotNull(target2, "target");
        this.lookAtEnd = target2;
        this.dirty = true;
    }

    public final void dollyTo(double distance) {
        this.sphericalEnd = Spherical.copy$default(this.sphericalEnd, distance, 0.0, 0.0, 6, null);
        this.dirty = true;
    }

    public final void zoom(double degrees) {
        this.fovEnd += degrees;
    }

    public final void update(double timeDelta) {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        double dampingFactor = this.dampingFactor * timeDelta / 0.006;
        Spherical sphericalDelta = this.sphericalEnd.minus(this.spherical);
        Vector3 lookAtDelta = this.lookAtEnd.minus(this.lookAt);
        double fovDelta = this.fovEnd - this.fov;
        if (Math.abs(this.sphericalEnd.getRadius()) > 1.0E-6 || Math.abs(this.sphericalEnd.getTheta()) > 1.0E-6 || Math.abs(this.sphericalEnd.getPhi()) > 1.0E-6 || Math.abs(lookAtDelta.getX()) > 1.0E-6 || Math.abs(lookAtDelta.getY()) > 1.0E-6 || Math.abs(lookAtDelta.getZ()) > 1.0E-6 || Math.abs(fovDelta) > 1.0E-6) {
            this.fov += fovDelta * dampingFactor;
            this.spherical = this.spherical.plus(sphericalDelta.times(dampingFactor));
            this.spherical = this.spherical.makeSafe();
            this.lookAt = this.lookAt.plus(lookAtDelta.times(dampingFactor));
            this.dirty = true;
        } else {
            this.spherical = Spherical.copy$default(this.sphericalEnd, 0.0, 0.0, 0.0, 7, null);
            this.lookAt = Vector3.copy$default(this.lookAtEnd, 0.0, 0.0, 0.0, 7, null);
        }
        this.spherical = this.spherical.makeSafe();
    }

    @NotNull
    public final Matrix44 viewMatrix() {
        return TransformsKt.lookAt(Vector3.Companion.fromSpherical(this.spherical).plus(this.lookAt), this.lookAt, Vector3.Companion.getUNIT_Y());
    }

    public final double getFov() {
        return this.fov;
    }

    public final void setFov(double d) {
        this.fov = d;
    }

    public OrbitalCamera(@NotNull Vector3 eye, @NotNull Vector3 lookAt, double fov) {
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        Intrinsics.checkParameterIsNotNull(lookAt, "lookAt");
        this.fov = fov;
        this.spherical = Spherical.Companion.fromVector(eye);
        this.lookAt = lookAt;
        this.sphericalEnd = Spherical.Companion.fromVector(eye);
        this.lookAtEnd = Vector3.copy$default(lookAt, 0.0, 0.0, 0.0, 7, null);
        this.dirty = true;
        this.fovEnd = this.fov;
        this.dampingFactor = 0.05;
        this.zoomSpeed = 1.0;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrndr/extras/camera/OrbitalCamera$Companion;", "", "()V", "EPSILON", "", "orx-camera"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

