; The Hole - Windows 512 bytes intro by TomCat/Abaddon
; Flashdance/MIDI music by ern0

; Tunnel idea: Roberval T. Especuloide
; https://gist.github.com/Especuloide/de1695d12ccd4e68e2ac7c75a916a3a7

RESX EQU 462;455
RESY EQU 256

BASE EQU 00400000H
ORG BASE
USE32

FORMAT BINARY AS 'exe'
                 DW 'MZ'       ; 00.e_magic
MIDIMSG:         DW 1090H      ; 02.e_cblp 
                 DD 'PE'       ; 04.Signature
                 DW 014CH      ; 08.Machine
                 DW 0          ; 0A.NumberOfSections
LoadLibraryA:    DD 0xE9826FC6 ; 0C.TimeDateStamp
GetWindowRect:   DD 0xF9AC1F38 ; 10.PointerToSymbolTable
ShowCursor:      DD 0x19A434A8 ; 14.NumberOfSymbols
AMPL:            DW 8          ; 18.SizeOfOptionalHeader
                 DW 2          ; 1A.Characteristics IMAGE_FILE_EXECUTABLE_IMAGE
                 DW 010BH      ; 1C.Magic (0x3CC90FDA)
BMPNFO:          DW 0001H      ; 1E.Major+MinorLinkerVersion
SRCCOPY:         DD 00CC0020H  ; 20.SizeOfCode
CreateWindowExA: DD 0xF8820ECC ; 24.SizeOfInitializedData
StretchDIBits:   DD 0x4ED54D5C ; 28.SizeOfUninitializedData
                 DD start-BASE ; 2C.AddressOfEntryPoint
ExitProcess:     DD 0x38A66AE8 ; 30.BaseOfCode
edit:            DD 'edit'     ; 34.BaseOfData
                 DD BASE       ; 38.ImageBase
                 DD 4          ; 3C.SectionAlignment (.e_lfanew)
                 DD 4          ; 40.FileAlignment
GetAsyncKeyState:DD 0xDE59F860 ; 44.Major+MinorOperatingSystemVersion
GetDC:           DD 0xA4D450D1 ; 48.Major+MinorImageVersion
PI128:           DW 3          ; 4C.MajorSubsystemVersion
                 DW 3CC9H      ; 4E.MinorSubsystemVersion
GetTickCount:    DD 0xFBBA3133 ; 50.Win32VersionValue
midiOutShortMsg: DD 0x0AE8E716 ; 54.SizeOfImage (malloc)
                 DD 30H        ; 58.SizeOfHeaders
midiOutOpen:     DD 0xC7AE717F ; 5C.CheckSum
                 DW 2          ; 60.Subsystem 2->gui
                 DW 0          ; 62.DllCharacteristics
start:                         ; 64.SizeOfStackReserve
 MOV BL,0x0C
 MOV EAX,[EBX]
 MOV EAX,[EAX+0x1C]
 PUSH ES
base:
 PUSH EDX
 MOV EBX,[EAX+0x08]
 POP ESI
 MOV EBP,[EAX+0x20]
 JMP skip
XRES:            DW RESX       ; 76.
                 DB 0          ; 78.NumberOfRvaAndSizes
WINDOW:          DD 91000000H

;bit mirror table
;0123456789ABCDEF
;084C2A6E195D3B7F
score:        
 DB 0D3H,023H,0D3H,043H,05DH,04DH,05DH,04DH,05DH,04DH,05DH,04DH
 DB 019H,049H,019H,009H,019H,009H,019H,009H,06EH,00EH,06EH,04EH
 DB 062H,09EH,03DH,029H,016H,0D9H,073H
last:
 DB 02DH                       ; 02FH XOR 02DH
adder:
 DB 72                         ; 60 XOR 72 

libname:         DB 'gdi32',0,'winmm',0,'user32',0

skip:
 CMP [EBP+0x18],DH
 MOV EAX,[EAX]
 JNZ base

 LEA EDI,[EDX-start+libname]
scan:
 PUSH 5CH/4
 POP ECX
func:
 PUSHAD
 LEA ESI,[ESI-start+BASE+ECX*4]
 MOV EAX,[EBX+0x3C]            ; EAX = RVA NT Header
 MOV EBP,[EBX+EAX+0x78]        ; EBP = RVA Data Directory
 ADD EBP,EBX                   ; EBP = RVA -> VA

hash:
; EBX = imagebase of dll
; EAX = imagebase + &NT_Hdr
; EBP = imagebase + &DataDirectory
; EDI = &libname
; ESI = &hashed function name

 MOV ECX,[EBP+0x18]            ; ECX = Num Exports
redo:
 JECXZ done                    ; ECX = 0 No More Exports
 DEC ECX                       ; ECX = Num Exports Decreased
 MOV EAX,[EBP+0x20]            ; EAX = RVA Exports Asciiz
 CDQ                           ; EDX = 0 (.PointerToLinenumbers)
 ADD EAX,EBX                   ; EAX = RVA -> VA
 MOV EDI,[EAX+ECX*4]           ; EDI = RVA Export Asciiz Index
 ADD EDI,EBX                   ; EDI = RVA -> VA
 SALC                          ; AL = 0
calc:
 ROL EDX,6                     ; EDX = Hash Preparation
 XOR DL,[EDI]                  ; EDX = Add Char Export Asciiz
 SCASB                         ; AL  = 0 Only For End of Asciiz
 JNZ calc                      ; If Not Zero Keep Hashing
 CMP EDX,[ESI]                 ; Check Hash Against Input
 JNZ redo                      ; If Not Equal Hash Next Function

 MOV EDX,[EBP+0x24]            ; EDX = RVA Function Ordinal
 ADD EDX,EBX                   ; EDX = RVA -> VA
 MOV CL,[EDX+ECX*2]
 MOV EDX,[EBP+0x1C]            ; EDX = Function RVAS List
 ADD EDX,EBX                   ; EDX = RVA -> VA
 ADD EBX,[EDX+ECX*4]           ; EBX = Function RVA
 MOV [ESI],EBX
done:
 POPAD                         ; Restore Registers
 LOOP func

 PUSH EDI
 CALL DWORD [ESI-start+LoadLibraryA]
 XCHG EBX,EAX

 PUSH 6
 POP ECX
@@:
 PUSH EBX
 INC EDI                       ; next dll name
 LOOP @B

 TEST EBX,EBX
 JNZ scan

; EBX = 0, ESI = start, EDI = hmo

 MOV EBP,[ESI-start+XRES]      ; EBP = RESX
 MOV CH,RESY/256               ; ECX = RESY

 PUSH DWORD [ESI-start+BMPNFO] ; .biPlanes+.biBitCount
 PUSH ECX                      ; .biHeight (negative value->vertical flip)
 PUSH EBP                      ; .biWidth
 PUSH 40                       ; .biSize
 MOV EAX,ESP                   ; BITMAPINFOHEADER

 PUSH DWORD [ESI-start+SRCCOPY]; 00CC0020H
 PUSH EBX                      ; DIB_RGB_COLORS
 PUSH EAX                      ; BITMAPINFOHEADER

 LEA EAX,[ESI+EBP*2]           ; BASE+1024
 PUSH EAX                      ; PIXELS
 PUSH ECX                      ; RESY
 PUSH EBP                      ; RESX
 SHR AH,1                      ; EAX = BASE+512 = sinus table
@@:
 MOV [ESI],EAX
 FLD DWORD [ESI-start+PI128]   ; PI/128
 FIMUL DWORD [ESI]             ; counter*PI/128
 FSIN                          ; SIN(counter*PI/128)
 FIMUL WORD [ESI-start+AMPL]   ; 8*SIN(counter*PI/128)
 FISTP DWORD [EAX]             ; -
 INC EAX
 LOOP @B

 MOV CL,19                     ; StretchDIBits:2+midiOutOpen:4+ShowCursor:1+CreateWindowEx:8+RECT:4
@@:
 PUSH EBX                      ; fill the stack by zeros
 LOOP @B

;midiOutOpen(&handle, 0, 0, 0, CALLBACK_NULL);
 PUSH EDI                      ; lphmo      
 CALL DWORD [ESI-start+midiOutOpen]

;ShowCursor(FALSE);
 CALL DWORD [ESI-start+ShowCursor]

 LEA EAX,[ESI-start+edit]
 PUSH DWORD [ESI-start+WINDOW] ; WS_POPUP|WS_MAXIMIZE|WS_VISIBLE
 PUSH EBX
 PUSH EAX
 PUSH EBX

;CreateWindowEx(0,"edit",0,WS_POPUP|WS_MAXIMIZE|WS_VISIBLE,0,0,0,0,0,0,0,0);
 CALL DWORD [ESI-start+CreateWindowExA]

 MOV EDX,ESP
 PUSH EAX      ; hwnd
 PUSH EDX      ; RECT
 PUSH EAX      ; hwnd
 CALL DWORD [ESI-start+GetWindowRect]

;GetDC(hwnd);
 CALL DWORD [ESI-start+GetDC]
 PUSH EAX      ; hdc

 MOV BL,252
 JMP main
music:
 ADD EBP,EAX                   ; save time counter
 MOV EDX,[ESI-start+MIDIMSG]   ; 007F1090H
@@:
 BT [ESI-start+score],EBX
 RCL DH,1
 INC BL
 JNC @B
 JNZ @F
 XOR WORD [ESI-start+last],7402H
@@:
 ADD DH,[ESI-start+adder]

;midiOutShortMsg(handle, 0x007f4090);
 PUSH EDX                      ; send note on channel 0
 PUSH DWORD [ESI-start+libname+6*4];[EDI]
 CALL DWORD [ESI-start+midiOutShortMsg]

main:
 CALL DWORD [ESI-start+GetTickCount]
 SHR EAX,3
 MOV [ESI],AL                  ; angle
 SHR EAX,1
 SUB EAX,EBP
 MOV BH,30
 SUB BH,AL
 JBE music

visual:
 LEA EDI,[ESI+156+768+RESX*4-((RESX-RESY)/2)*4-6]

 CDQ
nextpixel:
 PUSH EBX
 MOV EBX,[ESI]                 ; SINTAB
 PUSH 39
 POP ECX
nextlayer:
 PUSH EDX

@@:
 MOV AL,DH
 SUB AL,[EBX]
 CBW
 XOR AL,AH
 MOV DH,127
 SUB DH,AL
 XCHG DL,DH
 ADD BL,64
 DEC ECX
 NEG EBP
 JS @B

 MOV EAX,ESI
 MOV AL,3
 MUL CL

 CMP DL,AL
 JA @F
 CMP DH,AL
 JA @F
 CMP DL,CL
 JNA @F
 CMP DH,CL
@@:
 POP EDX
 JA putpixel

 SUB BL,139
 LOOP nextlayer

putpixel:
 POP EBX
 TEST BL,15+128
 JNZ @F
 CMP BH,CL
 JC @F
 NOT EAX
@@:

 TEST DL,DL
 JNZ @F
 MOV CL,RESX-RESY+1
 REP
@@:
 STOSD

 DEC DX
 JNZ nextpixel

;StretchDIBits(hdc,rc.left,rc.top,rc.right,rc.bottom,0,0,ResX,ResY,pixels,bmpnfo,0,SRCCOPY);
 CALL DWORD [ESI-start+StretchDIBits]
 SUB ESP,13*4  ; repair the stack frame (preserves StretchDIBits arguments)

 PUSH 1BH      ; VK_ESCAPE
 CALL DWORD [ESI-start+GetAsyncKeyState]
;DEC EAX       <--- not worked on a 32bit win10
;JS main
 TEST EAX,EAX
 JZ main

quit:
 JMP DWORD [ESI-start+ExitProcess]
