var bg, mid, fg;
var ps1, ps2;
var vs1, vs2;
var hist = [];
let frames = 0

function setup() {
    createCanvas(800, 480);
    bg = createGraphics(width, height)
    mid = createGraphics(width, height)
    fg = createGraphics(width, height)

    ps1 = [createVector(0, 0), createVector(200, 100)]
    ps2 = [createVector(16, 16), createVector(150, 80)]
    vs1 = [createVector(1, 1), createVector(1, -1)]
    vs2 = [createVector(-1, 1), createVector(-1, 1)]
    console.log(ps1, ps2)
}

function updateSpeed(p, v) {
    p.add(v)
    if (p.x < 0) {
        p.x = 0
        v.x = -v.x
    }
    if (p.x >= width) {
        p.x = width - 1
        v.x = -v.x
    }
    if (p.y < 0) {
        p.y = 0
        v.y = -v.y
    }
    if (p.y >= height) {
        p.y = height - 1
        v.y = -v.y
    }
}

function draw() {
    colorMode(RGB, 255)
    background(50,50,255,255)

    updateSpeed(ps1[0], vs1[0])
    updateSpeed(ps1[1], vs1[1])
    updateSpeed(ps2[0], vs2[0])
    updateSpeed(ps2[1], vs2[1])

    // ps1 = first two end points
    // ps2 = second two end points
    // ps1[0] -- ps1[1]
    // ps1[1] -- ps2[0]
    // ps2[0] -- ps2[1]
    // ps2[0] -- ps1[0]
    if ((frames % 8) == 0) {
        hist.push(
            [[
                createVector(ps1[0].x, ps1[0].y),
                createVector(ps1[1].x, ps1[1].y),
            ],[
                createVector(ps2[0].x, ps2[0].y),
                createVector(ps2[1].x, ps2[1].y),
            ]
            ])
        // var hist = [[ps1, ps2]]
        if (hist.length > 8) {
            hist = hist.slice(1, hist.length)
            //lastUpdate = frames
        }
    }

    color(255, 255, 255)

    for (let i=0;i<hist.length;i++) {
        let h = hist[i]
        let p1 = h[0]
        let p2 = h[1]
        //console.log(i, h)
        //console.log(p1, p2)
        line(p1[0].x, p1[0].y, p1[1].x, p1[1].y)
        line(p1[1].x, p1[1].y, p2[0].x, p2[0].y)
        line(p2[0].x, p2[0].y, p2[1].x, p2[1].y)
        line(p2[1].x, p2[1].y, p1[0].x, p1[0].y)
        //
        // line(ps1[0].x, ps1[0].y, ps1[1].x, ps1[1].y)
        // line(ps1[1].x, ps1[1].y, ps2[0].x, ps2[0].y)
        // line(ps2[0].x, ps2[0].y, ps2[1].x, ps2[1].y)
        // line(ps2[1].x, ps2[1].y, ps1[0].x, ps1[0].y)
    }

    frames += 1
}

