#version 120

uniform sampler2D texture;


uniform float time = 1.0;
uniform float starlength = 1.0;
uniform float starrot = 0.0;


void main()
{
	vec2 coord = gl_TexCoord[0].st;

    vec2 position = ( coord.xy)-vec2(0.5,0.0);

        // 256 angle steps
        float angle = atan(position.y,position.x)/(.90*3.14159265359);
        
        float rad = length(position);
        
        float color = 0.0;
        for (int i = 0; i < 2; i++) {
            float angleFract = fract(angle*40);
            float angleRnd = floor(angle*360.+starrot*time)+1.;
            float angleRnd1 = fract(angleRnd*fract(angleRnd*.7235)*45.1);
            float angleRnd2 = fract(angleRnd*fract(angleRnd*.82657)*13.724);
            float t = time+angleRnd1*10.;
            float radDist = sqrt(4*angleRnd2+float(i));
            
            float adist = radDist/rad*0.5;
            float dist = (t*.2+adist);
            dist = abs(fract(dist)-.1);
            color += max(0.,12.-dist*100.*starlength/adist)*(.1-abs(angleFract-.5))*5./adist/radDist;
            
            angle = fract(angle);
        }
    
    
    
    
    
    


	gl_FragColor = vec4(color,color,color,color);
}