
uniform float RBLUR_SAMPLES = 44.0;
uniform sampler2D texture1;
uniform float time = 0.5;

float rblur( in vec2 uv, in vec2 center, float falloffExp )
{
   
    uv -= center;
    float invSamples = 1.0 / float(RBLUR_SAMPLES);

    float result = 0.0;

    float r0=0.0,r1=0.0,r2=0.0,r3=0.0;

    vec4 indices = vec4(0,1,2,3);

    vec4 scale = vec4(0);

    for( int i = 0; i < RBLUR_SAMPLES; i+=4 )
    {
        scale = indices*invSamples;
        r0 = texture(texture1, uv*scale.x + center).r;
        r1 = texture(texture1, uv*scale.y + center).r;
        r2 = texture(texture1, uv*scale.z + center).r;
        r3 = texture(texture1, uv*scale.w + center).r;
        indices += 4.0;
        result += r0+r1+r2+r3;
    }
    return pow(result * invSamples,falloffExp);
}

void main()
{

    vec2 uv = gl_TexCoord[0].xy;
    
    // Get a stock copy of the image.
    vec4 jcvd = texture(texture1,uv);
    
    // Get a radial blur of him.
    float b = rblur(uv, vec2(.5),0.21);

    gl_FragColor = vec4(b,b,b,1)-jcvd;
}