var Tunneli = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setDoF({
        focus: 0.8,
        maxblur: 1.25,
        aparture: 0.0025
    });
    this.setBloom(8.1);

    this.scene.fog = new THREE.Fog(0xFF1111, 0.01, 200);

    this.texture = TDEMO.TEXTURES.getTextures().nelio;

    this.putki = this.createScene(this.texture);
    this.scene.add(this.putki);
};

Tunneli.prototype = PartBase.prototype.inheritance();

Tunneli.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var offset = TDEMO.SYNC.getObjPosition();
    this.texture.offset.x = offset.x;
    this.texture.offset.y = offset.y;
    this.texture.needsUpdate = true;
};

Tunneli.prototype.createScene = function(map){
    var geometry = new THREE.CylinderGeometry(20, 20, 800, 124, 50, true);
    var material = new THREE.MeshBasicMaterial({
        map : map,
        side : THREE.BackSide
    });

    var putki = new THREE.Mesh(geometry, material);
    putki.rotation.x = Math.PI/2;

    return putki;
}
