var Lines = function(){

    var size = TDEMO.MAIN.getRendererSize();
    PartBase.call(this,
        {camera : new THREE.OrthographicCamera( -size[0]/2, size[0]/2, size[1]/2, -size[1]/2, 0.1, 2000 )});
    this.camera.position.z = 1;

    this.mainScene = new THREE.Scene();
    var aspect = this.width/this.height;
    this.mainCamera = new THREE.PerspectiveCamera(50, aspect, this.near, this.far);

    this.mainScene.add(this.mainCamera);
    var rtSize  = {
        width : 2048,//1024,
        height: 1024//512
    }
    this.rtt = new THREE.WebGLRenderTarget(rtSize.width, rtSize.height);
    this.rtt.texture.wrapS = THREE.MirroredRepeatWrapping;
    this.rtt.texture.wrapT = THREE.MirroredRepeatWrapping;
    this.rtt.texture.offset.x = 0;
    this.rtt.texture.offset.y = 0;

    this.composer = new THREE.EffectComposer(TDEMO.MAIN.getRenderer(), this.rtt);
    this.composer.setSize(rtSize.width, rtSize.height);
    this.rp = new THREE.RenderPass(this.mainScene, this.mainCamera);

    this.phblur = new THREE.ShaderPass(THREE.HorizontalBlurShader);
    this.phblur.uniforms["h"].value = 8/rtSize.width;

    this.pvblur = new THREE.ShaderPass(THREE.VerticalBlurShader);
    this.pvblur.uniforms["v"].value = 8/rtSize.height;

    this.pedge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.pedge.uniforms[ "resolution" ].value =  new THREE.Vector2(rtSize.width, rtSize.height);

    this.pbloom = new THREE.BloomPass(2, 25, 4, rtSize.width);
    this.pbloom.renderToScreen = true;
    this.pbloom.needsSwap = true;
    this.pbloom.clear = true;

    this.composer.addPass(this.rp);
    //this.composer.addPass(this.phblur);
    //this.composer.addPass(this.pvblur);
    this.composer.addPass(this.pedge);
    this.composer.addPass(this.pbloom);

    //POSTPROCESSING
    /*this.setHorizontalBlur(8);
    this.setVerticalBlur(8);
    this.setEdgeDetection();
    this.setBloom(10);*/
    this.setBloom(0.3);

    var pg = new THREE.PlaneBufferGeometry(this.width, this.height);
    var pm = new THREE.MeshBasicMaterial({map: this.rtt.texture});
    this.plane = new THREE.Mesh(pg, pm);
    this.scene.add(this.plane);

    this.createSurroundings();

    this.lines = new THREE.Object3D();
    this.lineMaterial = new THREE.LineBasicMaterial({ color: 0x00FFFF});
    this.lineMaterial2 = new THREE.LineBasicMaterial({ color: 0xFF00FF});

    this.lsystem = new LSYSTEM();

    this.lsystem.interpret(9, 90, "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 4);
    this.lsystem.moveToCenter();

    this.line = this.lsystem.createLine(this.lineMaterial);
    this.line.position.x = 10;
    this.lines.add(this.line);


    this.line2 = new THREE.Line(this.line.geometry, this.lineMaterial2);
    this.line2.position.x = -10;
    this.lines.add(this.line2);

    this.lines.position.z = this.lsystem.center.z;
    this.mainScene.add(this.lines);
};

Lines.prototype = PartBase.prototype.inheritance();

Lines.prototype.animate = function(elapsedTime, delta){
    /*PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var lp = TDEMO.SYNC.getObjRotation();
    this.line.rotation.x = lp.x;
    this.line.rotation.y = lp.y;
    this.line.rotation.z = lp.z;

    this.line2.rotation.x = -lp.x;
    this.line2.rotation.y = -lp.y;
    this.line2.rotation.z = -lp.z;*/

    PartBase.prototype.animate.call(this, elapsedTime, delta, false);

    this.near = TDEMO.SYNC.getNear();
    this.far = TDEMO.SYNC.getFar();


    this.mainCamera.near = this.near;
    this.mainCamera.far = this.far;
    this.lens = TDEMO.SYNC.getLens();
    this.mainCamera.filmGauge = this.lens.fg;
    this.mainCamera.setFocalLength(this.lens.fl);
    this.mainCamera.updateProjectionMatrix();
    
    var camp = TDEMO.SYNC.getCameraPosition();
    this.mainCamera.position.x = camp.x;
    this.mainCamera.position.y = camp.y;
    this.mainCamera.position.z = camp.z;

    var camr = TDEMO.SYNC.getCameraRotation();
    this.mainCamera.rotation.x = camr.x;
    this.mainCamera.rotation.y = camr.y;
    this.mainCamera.rotation.z = camr.z;

    var lp = TDEMO.SYNC.getObjRotation();
    this.line.rotation.x = lp.x;
    this.line.rotation.y = lp.y;
    this.line.rotation.z = lp.z;

    this.line2.rotation.x = -lp.x;
    this.line2.rotation.y = -lp.y;
    this.line2.rotation.z = -lp.z;
    
    var p = TDEMO.SYNC.getObjPosition();
    this.lines.position.x = p.x;
    this.lines.position.y = p.y;
    this.lines.position.z = p.z;

    
    var hb = TDEMO.SYNC.getHeartBeat();
    this.rtt.texture.offset.x = hb;
    this.rtt.texture.offset.y = -hb;

    this.composer.render();
};

Lines.prototype.createSurroundings = function(){

    this.mainScene.fog = new THREE.Fog(0x5D478B, 200, 800);
    var material = new THREE.MeshStandardMaterial({
        color : 0xCDCCFF,
        side : THREE.BackSide
    });
    this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(800, 64, 64), material);
    this.mainScene.add(this.skySphere);
}
