#ifdef GL_ES
#define LOW lowp
#define MED mediump
#define HIGH highp
precision mediump float;
#else
#define MED
#define LOW
#define HIGH
#endif

attribute vec2 aPos;
attribute vec2 aTexCoords;
varying vec2 TexCoords;
varying vec4 blurTextureCoords1;
varying vec4 blurTextureCoords2;
varying vec2 blurTextureCenterCoord;
uniform float targetHeight;

void main()
{
    gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0);
    vec2 centerTexCoords = aPos * 0.5 + 0.5;
    float pixelSize = 1.0 / targetHeight;
    TexCoords = aTexCoords;
    blurTextureCoords1.xy = centerTexCoords + vec2(0.0, pixelSize * -2.0);
    blurTextureCoords1.zw = centerTexCoords + vec2(0.0, pixelSize * -1.0);
    blurTextureCenterCoord = centerTexCoords + vec2(0.0, pixelSize * 0.0);
    blurTextureCoords2.xy = centerTexCoords + vec2(0.0, pixelSize * 1.0);
    blurTextureCoords2.zw = centerTexCoords + vec2(0.0, pixelSize * 2.0);
}
