#ifdef GL_ES
#define LOW lowp
#define MED mediump
#define HIGH highp
precision mediump float;
#else
#define MED
#define LOW
#define HIGH
#endif

uniform sampler2D screenTexture;
varying vec2 TexCoords;

void main()
{
    //const float exposure = 14.0;
    const float exposure = 2.9;
    const float gamma = 1.0;
    vec3 hdrColor = texture2D(screenTexture, TexCoords).rgb;

    // Exposure tone mapping
    vec3 mapped = vec3(1.0) - exp(-hdrColor * exposure);
    // Gamma correction
    mapped = pow(mapped, vec3(1.0 / gamma));

    gl_FragColor = vec4(mapped, 1.0);
}
