#ifdef GL_ES
#define LOW lowp
#define MED mediump
#define HIGH highp
precision mediump float;
#else
#define MED
#define LOW
#define HIGH
#endif

varying vec2 v_texCoords;
varying vec3 v_normal;
varying vec3 v_fragPos;

uniform sampler2D texture;

uniform float lightStrength;
uniform vec3 lightPos;
uniform vec3 lightColor;
uniform vec3 objectAmbientColor;
uniform vec3 camPos;
uniform int specularOnly;
uniform float alpha;
uniform vec2 resolution;
uniform int reflection;

//float specStr = 0.7;
float specStr = 1.7;


#define NUM_LIGHTS 4

struct Light {
    vec3 position;

    vec3 ambient;
    vec3 diffuse;
    vec3 specular;

    float strength;

    float constant;
    float linear;
    float quadratic;
};


uniform Light lights[NUM_LIGHTS];


vec4 PointLight(Light light) {

    // combine
    vec4 texcol = texture2D(texture, v_texCoords);

    //vec2 uv = gl_FragCoord.xy / resolution;

    // ambient
    vec3 ambientColor = light.ambient * vec3(texcol);

    // calculate light position vector
    vec3 norm = normalize(v_normal);
    vec3 lightDir = normalize(light.position - v_fragPos);

    // calculate diffuse amount
    float diff = max(dot(norm, lightDir), 0.0);
    vec3 diffuse = diff * light.diffuse;



    // calculate camera position vector and specular
    vec3 camDir = normalize(camPos - v_fragPos);
    vec3 reflectDir = reflect(-lightDir, norm);
    float spec = pow(max(dot(camDir, reflectDir), 0.0), 32.0);
    vec3 specCol =  specStr * spec * light.specular;



    float distance    = length(light.position - v_fragPos);
    float attenuation = 1.0 / (light.constant + light.linear * distance + light.quadratic * (distance * distance));

    //vec3 result = (ambientColor + diffuse*lightStrength + specCol) * vec3(texcol) ;
    ambientColor  *= attenuation;
    diffuse   *= attenuation;
    specCol *= attenuation;

    vec3 result = vec3(0.0,0.0,0.0);
    result = (objectAmbientColor + ambientColor + diffuse*light.strength) * vec3(texcol) ;
    //gl_FragColor = vec4(result, 1.0);

    vec4 outval = vec4(result, 1.0);

    if (specularOnly == 0) {
        outval = vec4(result, 1.0);
/*        if (reflection == 0) {
        }
        else {
            float alf = pow(v_fragPos.y + 1.0, 1.2);
            outval = vec4(result, alpha);
        }*/
    }
    else {
        if (spec >= 0.01) {
            result = (specCol);
            outval = vec4(result, 1.0);
        }
        else {
            outval = vec4(0,0,0,0);
        }
/*        else {
            discard;
        }*/
    }



/*    if (specularOnly == 1) {
        if (spec >= 0.01) {
            result = (specCol);
            outval = vec4(result, 1.0);
        }
        else {
            discard;
        }
    }
    else {
            //outval = vec4(result, 1.0);
        if (reflection == 0) {
            outval = vec4(result, 1.0);
        }
        else {
            float alf = pow(v_fragPos.y + 1.0, 1.2);
            outval = vec4(result, alpha);
        }
    }*/
    return outval;
}

void main() {
    vec4 result = vec4(0,0,0,1.0);
    for (int i = 0; i<NUM_LIGHTS; i++) {
        vec4 what = PointLight(lights[i]);
        result.x += clamp(what.x, 0.0, 1.0);
        result.y += clamp(what.y, 0.0, 1.0);
        result.z += clamp(what.z, 0.0, 1.0);

        if (reflection == 0) {
            result.w = alpha;
        }
        else {
            //float alf = pow(v_fragPos.y + 1.0, 1.2);
            //float alf = 1.0 - pow(v_fragPos.y + 1.0, 0.2); // good
            float alf = alpha;
            result.w = alf;//alf;
        }
    }
    gl_FragColor = result;
    //gl_FragColor = PointLight(lights[0]);
}



/*void main() {

    // combine
    vec4 texcol = texture2D(texture, v_texCoords);

    //vec2 uv = gl_FragCoord.xy / resolution;

    // ambient
    vec3 ambientColor = light.ambient * vec3(texcol);

    // calculate light position vector
    vec3 norm = normalize(v_normal);
    vec3 lightDir = normalize(light.position - v_fragPos);

    // calculate diffuse amount
    float diff = max(dot(norm, lightDir), 0.0);
    vec3 diffuse = diff * light.diffuse;

    // calculate camera position vector and specular
    vec3 camDir = normalize(camPos - v_fragPos);
    vec3 reflectDir = reflect(-lightDir, norm);
    float spec = pow(max(dot(camDir, reflectDir), 0.0), 32.0);
    vec3 specCol =  specStr * spec * light.specular;



    float distance    = length(light.position - v_fragPos);
    float attenuation = 1.0 / (light.constant + light.linear * distance + light.quadratic * (distance * distance));

    //vec3 result = (ambientColor + diffuse*lightStrength + specCol) * vec3(texcol) ;
    ambientColor  *= attenuation;
    diffuse   *= attenuation;
    specCol *= attenuation;

    vec3 result = vec3(0.0,0.0,0.0);
    result = (ambientColor + diffuse*light.strength + specCol) * vec3(texcol) ;
    //gl_FragColor = vec4(result, 1.0);


    if (specularOnly == 1) {
        if (spec >= 0.01) {
            result = (specCol);
            gl_FragColor = vec4(result, 1.0);
        }
        else {
            discard;
        }
    }
    else {
        if (reflection == 0) {
            gl_FragColor = vec4(result, 1.0);
        }
        else {
            float alf = pow(v_fragPos.y + 1.0, 1.2);
            gl_FragColor = vec4(result, alf);
        }
    }
}*/
