/*
 * Decompiled with CFR 0.152.
 */
package ktx.assets;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.AbsoluteFileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.ClasspathFileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.ExternalFileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.LocalFileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.PrefixFileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.ResolutionFileResolver;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import ktx.assets.ResolversKt$WhenMappings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a#\u0010\u0007\u001a\u00020\b*\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\t*\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"resolution", "Lcom/badlogic/gdx/assets/loaders/resolvers/ResolutionFileResolver$Resolution;", "width", "", "height", "folder", "", "forResolutions", "Lcom/badlogic/gdx/assets/loaders/resolvers/ResolutionFileResolver;", "Lcom/badlogic/gdx/assets/loaders/FileHandleResolver;", "resolutions", "", "(Lcom/badlogic/gdx/assets/loaders/FileHandleResolver;[Lcom/badlogic/gdx/assets/loaders/resolvers/ResolutionFileResolver$Resolution;)Lcom/badlogic/gdx/assets/loaders/resolvers/ResolutionFileResolver;", "getResolver", "Lcom/badlogic/gdx/Files$FileType;", "withPrefix", "Lcom/badlogic/gdx/assets/loaders/resolvers/PrefixFileHandleResolver;", "prefix", "ktx-assets"})
public final class ResolversKt {
    @NotNull
    public static final FileHandleResolver getResolver(@NotNull Files.FileType $receiver) {
        FileHandleResolver fileHandleResolver;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, "$receiver");
        switch (ResolversKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                fileHandleResolver = new ClasspathFileHandleResolver();
                break;
            }
            case 2: {
                fileHandleResolver = new InternalFileHandleResolver();
                break;
            }
            case 3: {
                fileHandleResolver = new LocalFileHandleResolver();
                break;
            }
            case 4: {
                fileHandleResolver = new ExternalFileHandleResolver();
                break;
            }
            case 5: {
                fileHandleResolver = new AbsoluteFileHandleResolver();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileHandleResolver;
    }

    @NotNull
    public static final PrefixFileHandleResolver withPrefix(@NotNull FileHandleResolver $receiver, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        return new PrefixFileHandleResolver($receiver, prefix);
    }

    @NotNull
    public static final ResolutionFileResolver forResolutions(@NotNull FileHandleResolver $receiver, ResolutionFileResolver.Resolution ... resolutions) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(resolutions, "resolutions");
        return new ResolutionFileResolver($receiver, Arrays.copyOf(resolutions, resolutions.length));
    }

    @NotNull
    public static final ResolutionFileResolver.Resolution resolution(int width, int height, @NotNull String folder) {
        Intrinsics.checkParameterIsNotNull(folder, "folder");
        return new ResolutionFileResolver.Resolution(width, height, folder);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ResolutionFileResolver.Resolution resolution$default(int n, int n2, String string, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string = "" + n + 'x' + n2;
        }
        return ResolversKt.resolution(n, n2, string);
    }
}

