/*
 * Decompiled with CFR 0.152.
 */
package glm.quat;

import glm.ExtensionsKt;
import glm.JavaBindsKt;
import glm.glm;
import glm.mat.QuatT;
import glm.mat3x3.Mat3;
import glm.mat3x3.Mat3d;
import glm.mat4x4.Mat4;
import glm.mat4x4.Mat4d;
import glm.quat.QuatD;
import glm.quat.quat_func;
import glm.quat.quat_operators;
import glm.vec3.Vec3;
import glm.vec3.Vec3d;
import glm.vec4.Vec4;
import glm.vec4.Vec4bool;
import glm.vec4.Vec4t;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 K2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001KB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B'\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0017\u001a\u00020\u0015\u0012\u0006\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0019B\u0013\b\u0016\u0012\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u001a\u00a2\u0006\u0002\u0010\u001bB%\u0012\u0006\u0010\u0014\u001a\u00020\u0002\u0012\u0006\u0010\u0016\u001a\u00020\u0002\u0012\u0006\u0010\u0017\u001a\u00020\u0002\u0012\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0002J\"\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\b2\b\b\u0002\u0010 \u001a\u00020\u0000H\u0007J\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\bJ\u0012\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010 \u001a\u00020\u0000H\u0007J\u0006\u0010#\u001a\u00020\u0000J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010$\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0000J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0002H\u0086\u0004J\u0011\u0010&\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0096\u0002J\u0012\u0010+\u001a\u00020\b2\b\b\u0002\u0010 \u001a\u00020\bH\u0007J\u0011\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.H\u0086\u0002J\u0012\u0010/\u001a\u00020\u00002\b\b\u0002\u0010 \u001a\u00020\u0000H\u0007J\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0002J\u0011\u00102\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0006J\u0016\u00102\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u0011\u00103\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\u0012\u00104\u001a\u00020\u00002\b\b\u0002\u0010 \u001a\u00020\u0000H\u0007J\u0006\u00105\u001a\u00020\u0000J\u0011\u00106\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0006J\u0016\u00106\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u0011\u00107\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\u0011\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0000H\u0086\u0004J&\u00108\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002J\u0019\u0010:\u001a\u00020;2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0006\u001a\u00020\u0002H\u0086\u0002J\"\u0010<\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u00022\b\b\u0002\u0010 \u001a\u00020\u0000H\u0007J\u0016\u0010>\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0002J\u0011\u0010?\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010?\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u0011\u0010?\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0086\u0006J\u0016\u0010?\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bJ\u0011\u0010?\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0010H\u0086\u0006J\u0016\u0010?\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0000J\u0011\u0010?\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010?\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0000J\u0011\u0010@\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010@\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0086\u0004J\u0011\u0010@\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0010H\u0086\u0004J\u0011\u0010@\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0002H\u0086\u0004J\u0011\u0010A\u001a\u00020B2\u0006\u0010 \u001a\u00020BH\u0086\u0004J\u0011\u0010A\u001a\u00020C2\u0006\u0010 \u001a\u00020CH\u0086\u0004J\u0006\u0010D\u001a\u00020BJ\u0006\u0010E\u001a\u00020CJ\b\u0010F\u001a\u00020GH\u0016J\t\u0010H\u001a\u00020\u0000H\u0086\u0002J\t\u0010I\u001a\u00020\u0000H\u0086\u0002J\u0012\u0010J\u001a\u00020\u00102\b\b\u0002\u0010 \u001a\u00020\u0010H\u0007\u00a8\u0006L"}, d2={"Lglm/quat/Quat;", "Lglm/mat/QuatT;", "", "()V", "q", "(Lglm/quat/Quat;)V", "s", "v", "Lglm/vec3/Vec3;", "(FLglm/vec3/Vec3;)V", "a", "b", "(Lglm/vec3/Vec3;Lglm/vec3/Vec3;)V", "eulerAngle", "(Lglm/vec3/Vec3;)V", "vec4", "Lglm/vec4/Vec4;", "(Lglm/vec4/Vec4;)V", "Lglm/quat/QuatD;", "(Lglm/quat/QuatD;)V", "w", "", "x", "y", "z", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lglm/vec4/Vec4t;", "(Lglm/vec4/Vec4t;)V", "(FFFF)V", "angle", "angleAxis", "axis", "res", "angleAxis_", "conjugate", "conjugate_", "div", "div_", "dot", "equals", "", "other", "", "eulerAngles", "get", "i", "", "inverse", "inverse_", "length", "minus", "minus_", "normalize", "normalize_", "plus", "plus_", "put", "quat", "set", "", "slerp", "interp", "slerp_", "times", "times_", "to", "Lglm/mat3x3/Mat3;", "Lglm/mat4x4/Mat4;", "toMat3", "toMat4", "toString", "", "unaryMinus", "unaryPlus", "vectorize", "Companion", "build_main"})
public final class Quat
extends QuatT<Float> {
    @JvmField
    public static final int size;
    public static final Companion Companion;

    @NotNull
    public final Mat3 to(@NotNull Mat3 res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.mat3_cast(this, res);
    }

    @NotNull
    public final Mat3 toMat3() {
        return glm.INSTANCE.mat3_cast(this, new Mat3());
    }

    @NotNull
    public final Mat4 to(@NotNull Mat4 res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.mat4_cast(this, res);
    }

    @NotNull
    public final Mat4 toMat4() {
        return glm.INSTANCE.mat4_cast(this, new Mat4());
    }

    @NotNull
    public final Quat put(float w, float x, float y, float z) {
        this.w = Float.valueOf(w);
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.z = Float.valueOf(z);
        return this;
    }

    @NotNull
    public final Quat put(@NotNull Quat quat) {
        Intrinsics.checkParameterIsNotNull(quat, "quat");
        return this.put(quat.w.floatValue(), quat.x.floatValue(), quat.y.floatValue(), quat.z.floatValue());
    }

    public final float get(int i) {
        float f;
        switch (i) {
            case 0: {
                f = this.x.floatValue();
                break;
            }
            case 1: {
                f = this.y.floatValue();
                break;
            }
            case 2: {
                f = this.z.floatValue();
                break;
            }
            case 3: {
                f = this.w.floatValue();
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException();
            }
        }
        return f;
    }

    public final void set(int i, float s) {
        switch (i) {
            case 0: {
                this.x = Float.valueOf(s);
                break;
            }
            case 1: {
                this.y = Float.valueOf(s);
                break;
            }
            case 2: {
                this.z = Float.valueOf(s);
                break;
            }
            case 3: {
                this.w = Float.valueOf(s);
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @NotNull
    public final Quat unaryPlus() {
        return this;
    }

    @NotNull
    public final Quat unaryMinus() {
        return new Quat(-this.w.floatValue(), -this.x.floatValue(), -this.y.floatValue(), -this.z.floatValue());
    }

    @NotNull
    public final Quat plus(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.plus(new Quat(), this, b);
    }

    @NotNull
    public final Quat plus(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.plus(res, this, b);
    }

    @NotNull
    public final Quat plus_(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.plus(this, this, b);
    }

    @NotNull
    public final Quat minus(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.minus(new Quat(), this, b);
    }

    @NotNull
    public final Quat minus(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.minus(res, this, b);
    }

    @NotNull
    public final Quat minus_(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.minus(this, this, b);
    }

    @NotNull
    public final Quat times(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Quat times(float b) {
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Vec3(), this, b);
    }

    @NotNull
    public final Quat times(@NotNull Vec4 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Quat times(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Quat times(float b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b, @NotNull Vec3 res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Quat times(@NotNull Vec4 b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Quat times_(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final Quat times_(float b) {
        return Companion.times(this, this, b);
    }

    @NotNull
    public final Vec3 times_(@NotNull Vec3 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(b, this, b);
    }

    @NotNull
    public final Quat times_(@NotNull Vec4 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final Quat div(float b) {
        return Companion.div(new Quat(), this, b);
    }

    @NotNull
    public final Quat div(float b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.div(res, this, b);
    }

    @NotNull
    public final Quat div_(float b) {
        return Companion.div(this, this, b);
    }

    public final float length() {
        return glm.INSTANCE.length(this);
    }

    @JvmOverloads
    @NotNull
    public final Quat normalize(@NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.normalize(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Quat normalize$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.normalize(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat normalize() {
        return Quat.normalize$default(this, null, 1, null);
    }

    @NotNull
    public final Quat normalize_() {
        return glm.INSTANCE.normalize(this, this);
    }

    public final float dot(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.dot(this, b);
    }

    @JvmOverloads
    @NotNull
    public final Quat angleAxis(float angle, @NotNull Vec3 axis, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.angleAxis(angle, axis, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Quat angleAxis$default(Quat quat, float f, Vec3 vec3, Quat quat2, int n, Object object) {
        if ((n & 4) != 0) {
            quat2 = new Quat();
        }
        return quat.angleAxis(f, vec3, quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat angleAxis(float angle, @NotNull Vec3 axis) {
        return Quat.angleAxis$default(this, angle, axis, null, 4, null);
    }

    @NotNull
    public final Quat angleAxis_(float angle, @NotNull Vec3 axis) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        return glm.INSTANCE.angleAxis(angle, axis, this);
    }

    @JvmOverloads
    @NotNull
    public final Quat conjugate(@NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.conjugate(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Quat conjugate$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.conjugate(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat conjugate() {
        return Quat.conjugate$default(this, null, 1, null);
    }

    @NotNull
    public final Quat conjugate_() {
        return glm.INSTANCE.conjugate(this, this);
    }

    @JvmOverloads
    @NotNull
    public final Quat inverse(@NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.inverse(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Quat inverse$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.inverse(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat inverse() {
        return Quat.inverse$default(this, null, 1, null);
    }

    @NotNull
    public final Quat inverse_() {
        return glm.INSTANCE.inverse(this, this);
    }

    public final float angle() {
        return glm.INSTANCE.angle(this);
    }

    @JvmOverloads
    @NotNull
    public final Vec3 eulerAngles(@NotNull Vec3 res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.eulerAngles(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Vec3 eulerAngles$default(Quat quat, Vec3 vec3, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = new Vec3();
        }
        return quat.eulerAngles(vec3);
    }

    @JvmOverloads
    @NotNull
    public final Vec3 eulerAngles() {
        return Quat.eulerAngles$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Quat slerp(@NotNull Quat b, float interp, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.slerp(this, b, interp, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Quat slerp$default(Quat quat, Quat quat2, float f, Quat quat3, int n, Object object) {
        if ((n & 4) != 0) {
            quat3 = new Quat();
        }
        return quat.slerp(quat2, f, quat3);
    }

    @JvmOverloads
    @NotNull
    public final Quat slerp(@NotNull Quat b, float interp) {
        return Quat.slerp$default(this, b, interp, null, 4, null);
    }

    @NotNull
    public final Quat slerp_(@NotNull Quat b, float interp) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.slerp(this, b, interp, this);
    }

    @NotNull
    public String toString() {
        return "(" + this.x.floatValue() + ", " + this.y.floatValue() + ", " + this.z.floatValue() + "), " + this.w.floatValue();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Quat ? this.get(0) == ((Quat)other).get(0) && this.get(1) == ((Quat)other).get(1) && this.get(2) == ((Quat)other).get(2) && this.get(3) == ((Quat)other).get(3) : false;
    }

    @JvmOverloads
    @NotNull
    public final Vec4 vectorize(@NotNull Vec4 res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return res.put(this.x, this.y, this.z, this.w);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Vec4 vectorize$default(Quat quat, Vec4 vec4, int n, Object object) {
        if ((n & 1) != 0) {
            vec4 = new Vec4();
        }
        return quat.vectorize(vec4);
    }

    @JvmOverloads
    @NotNull
    public final Vec4 vectorize() {
        return Quat.vectorize$default(this, null, 1, null);
    }

    public Quat(float w, float x, float y, float z) {
        super((Number)Float.valueOf(w), (Number)Float.valueOf(x), (Number)Float.valueOf(y), (Number)Float.valueOf(z));
    }

    public Quat() {
        this(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public Quat(@NotNull Quat q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this(q.w.floatValue(), q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
    }

    public Quat(float s, @NotNull Vec3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this(s, v.x.floatValue(), v.y.floatValue(), v.z.floatValue());
    }

    public Quat(@NotNull Vec3 a, @NotNull Vec3 b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        this();
        float cX = a.y.floatValue() * b.z.floatValue() - b.y.floatValue() * a.z.floatValue();
        float cY = a.z.floatValue() * b.x.floatValue() - b.z.floatValue() * a.x.floatValue();
        float cZ = a.x.floatValue() * b.y.floatValue() - b.x.floatValue() * a.y.floatValue();
        float dot = glm.INSTANCE.dot(a, b);
        this.put(1.0f + dot, cX, cY, cZ);
        Companion.normalize(this, this);
    }

    public Quat(@NotNull Vec3 eulerAngle) {
        Intrinsics.checkParameterIsNotNull(eulerAngle, "eulerAngle");
        this();
        float eX = eulerAngle.x.floatValue() * 0.5f;
        float eY = eulerAngle.y.floatValue() * 0.5f;
        float eZ = eulerAngle.z.floatValue() * 0.5f;
        float cX = glm.INSTANCE.cos(eX);
        float cY = glm.INSTANCE.cos(eY);
        float cZ = glm.INSTANCE.cos(eZ);
        float sX = glm.INSTANCE.sin(eX);
        float sY = glm.INSTANCE.sin(eY);
        float sZ = glm.INSTANCE.sin(eZ);
        this.w = Float.valueOf(cX * cY * cZ + sX * sY * sZ);
        this.x = Float.valueOf(sX * cY * cZ - cX * sY * sZ);
        this.y = Float.valueOf(cX * sY * cZ + sX * cY * sZ);
        this.z = Float.valueOf(cX * cY * sZ - sX * sY * cZ);
    }

    public Quat(@NotNull Vec4 vec4) {
        Intrinsics.checkParameterIsNotNull(vec4, "vec4");
        this(vec4.w.floatValue(), vec4.x.floatValue(), vec4.y.floatValue(), vec4.z.floatValue());
    }

    public Quat(@NotNull QuatD q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this(ExtensionsKt.getF(q.w), ExtensionsKt.getF(q.x), ExtensionsKt.getF(q.y), ExtensionsKt.getF(q.z));
    }

    public Quat(@NotNull Number w, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkParameterIsNotNull(w, "w");
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(y, "y");
        Intrinsics.checkParameterIsNotNull(z, "z");
        this(ExtensionsKt.getF(w), ExtensionsKt.getF(x), ExtensionsKt.getF(y), ExtensionsKt.getF(z));
    }

    public Quat(@NotNull Vec4t<?> vec4) {
        Intrinsics.checkParameterIsNotNull(vec4, "vec4");
        this(ExtensionsKt.getF(vec4.w), ExtensionsKt.getF(vec4.x), ExtensionsKt.getF(vec4.y), ExtensionsKt.getF(vec4.z));
    }

    static {
        Companion = new Companion(null);
        size = 4 * JavaBindsKt.getBYTES(FloatCompanionObject.INSTANCE);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lglm/quat/Quat$Companion;", "Lglm/quat/quat_operators;", "Lglm/quat/quat_func;", "()V", "size", "", "build_main"})
    public static final class Companion
    implements quat_operators,
    quat_func {
        private Companion() {
        }

        @Override
        @NotNull
        public Quat plus(@NotNull Quat res, @NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.plus(this, res, a, b);
        }

        @Override
        @NotNull
        public Quat minus(@NotNull Quat res, @NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.minus(this, res, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a, float b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res, @NotNull Quat a, @NotNull Vec3 b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res, @NotNull Vec3 a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a, @NotNull Vec4 b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public Quat div(@NotNull Quat res, @NotNull Quat a, float b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_operators.DefaultImpls.div(this, res, a, b);
        }

        @Override
        public float length(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.length((quat_func)this, q);
        }

        @Override
        public double length(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.length((quat_func)this, q);
        }

        @Override
        @NotNull
        public Quat normalize(@NotNull Quat q, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.normalize((quat_func)this, q, res);
        }

        @Override
        @NotNull
        public Quat normalize(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.normalize((quat_func)this, q);
        }

        @Override
        @NotNull
        public QuatD normalize(@NotNull QuatD q, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.normalize((quat_func)this, q, res);
        }

        @Override
        @NotNull
        public QuatD normalize(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.normalize((quat_func)this, q);
        }

        @Override
        public float dot(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.dot((quat_func)this, a, b);
        }

        @Override
        public double dot(@NotNull QuatD a, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.dot((quat_func)this, a, b);
        }

        @Override
        @NotNull
        public Quat mix(@NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.mix((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public Quat mix(@NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.mix((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public QuatD mix(@NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.mix((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD mix(@NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.mix((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public Quat lerp(@NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.lerp((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public Quat lerp(@NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.lerp((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public QuatD lerp(@NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.lerp((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD lerp(@NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.lerp((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public Quat slerp(@NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.slerp((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public Quat slerp(@NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.slerp((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public QuatD slerp(@NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.slerp((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD slerp(@NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.slerp((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public Quat conjugate(@NotNull Quat a, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.conjugate((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public Quat conjugate(@NotNull Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.conjugate((quat_func)this, a);
        }

        @Override
        @NotNull
        public QuatD conjugate(@NotNull QuatD a, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.conjugate((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public QuatD conjugate(@NotNull QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.conjugate((quat_func)this, a);
        }

        @Override
        @NotNull
        public Quat inverse(@NotNull Quat a, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.inverse((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public Quat inverse(@NotNull Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.inverse((quat_func)this, a);
        }

        @Override
        @NotNull
        public QuatD inverse(@NotNull QuatD a, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.inverse((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public QuatD inverse(@NotNull QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.inverse((quat_func)this, a);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, float vX, float vY, float vZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, vX, vY, vZ, res);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, float vX, float vY, float vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, vX, vY, vZ);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, @NotNull Vec3 v, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, v, res);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, @NotNull Vec3 v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, v);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, double vX, double vY, double vZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, vX, vY, vZ, res);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, double vX, double vY, double vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, vX, vY, vZ);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, @NotNull Vec3d v, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, v, res);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, @NotNull Vec3d v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, v);
        }

        @Override
        @NotNull
        public Vec3 eulerAngles(@NotNull Quat a, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.eulerAngles((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public Vec3 eulerAngles(@NotNull Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.eulerAngles((quat_func)this, a);
        }

        @Override
        @NotNull
        public Vec3d eulerAngles(@NotNull QuatD a, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.eulerAngles((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public Vec3d eulerAngles(@NotNull QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.eulerAngles((quat_func)this, a);
        }

        @Override
        public float roll(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.roll((quat_func)this, q);
        }

        @Override
        public double roll(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.roll((quat_func)this, q);
        }

        @Override
        public float pitch(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.pitch((quat_func)this, q);
        }

        @Override
        public double pitch(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.pitch((quat_func)this, q);
        }

        @Override
        public float yaw(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.yaw((quat_func)this, q);
        }

        @Override
        public double yaw(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.yaw((quat_func)this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q, @NotNull Mat3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.mat3_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.mat3_cast(this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3d_cast(@NotNull QuatD q, @NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.mat3d_cast(this, q, m);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q, @NotNull Mat4 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.mat4_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.mat4_cast(this, q);
        }

        @Override
        @NotNull
        public Mat4 mat4d_cast(@NotNull Mat4 res, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.mat4d_cast(this, res, q);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quat_cast((quat_func)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.quat_cast((quat_func)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quat_cast((quat_func)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.quat_cast((quat_func)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return quat_func.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quatD_cast((quat_func)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.quatD_cast((quat_func)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quatD_cast((quat_func)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.quatD_cast((quat_func)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return quat_func.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        public float angle(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.angle((quat_func)this, q);
        }

        @Override
        public double angle(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.angle((quat_func)this, q);
        }

        @Override
        @NotNull
        public Vec3 axis(@NotNull Quat q, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.axis((quat_func)this, q, res);
        }

        @Override
        @NotNull
        public Vec3 axis(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.axis((quat_func)this, q);
        }

        @Override
        @NotNull
        public Vec3d axis(@NotNull QuatD q, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.axis((quat_func)this, q, res);
        }

        @Override
        @NotNull
        public Vec3d axis(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.axis((quat_func)this, q);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, float axisX, float axisY, float axisZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axisX, axisY, axisZ, res);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, float axisX, float axisY, float axisZ) {
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axisX, axisY, axisZ);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, @NotNull Vec3 axis, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axis, res);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, @NotNull Vec3 axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axis);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, double axisX, double axisY, double axisZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axisX, axisY, axisZ, res);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, double axisX, double axisY, double axisZ) {
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axisX, axisY, axisZ);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, @NotNull Vec3d axis, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axis, res);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, @NotNull Vec3d axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axis);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.lessThan(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.lessThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.lessThanEqual(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.lessThanEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.greater(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.greater(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.greaterThan(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.greaterThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.equal(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.equal(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.notEqual(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.notEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.isNan(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.isNan(this, q);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.isInf(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.isInf(this, q);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

