/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.app;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u001bH\u0002J\u000e\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u0003J\u0006\u00101\u001a\u000202J(\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u000206H\u0002J&\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bJ&\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003J\u000e\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\u001bR\u0014\u0010\u0007\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\t\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\tR\u0014\u0010%\u001a\u00020\u001bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/mygdx/game/app/NetworkLights;", "", "port", "", "address", "", "(ILjava/lang/String;)V", "BLUE_OFFSET", "getBLUE_OFFSET", "()I", "GREEN_OFFSET", "getGREEN_OFFSET", "NUM_FIELDS", "getNUM_FIELDS", "NUM_LIGHTS", "getNUM_LIGHTS", "RED_OFFSET", "getRED_OFFSET", "START_BYTES", "getSTART_BYTES", "addressToSend", "Ljava/net/InetAddress;", "getAddressToSend", "()Ljava/net/InetAddress;", "setAddressToSend", "(Ljava/net/InetAddress;)V", "cumu", "", "dropAmount", "getDropAmount", "setDropAmount", "(I)V", "lightData", "", "getLightData", "()[B", "getPort", "sendRate", "getSendRate", "()F", "socket", "Ljava/net/DatagramSocket;", "getSocket", "()Ljava/net/DatagramSocket;", "time", "convertColor", "f", "getLightColor", "index", "sendAll", "", "setLight", "lightNumber", "r", "", "g", "b", "ri", "gi", "bi", "update", "delta", "core"})
public final class NetworkLights {
    private final int NUM_LIGHTS = 24;
    private final int NUM_FIELDS = 6;
    private final int START_BYTES = 7;
    private final int RED_OFFSET = 3;
    private final int GREEN_OFFSET = 4;
    private final int BLUE_OFFSET = 5;
    @NotNull
    private final DatagramSocket socket;
    @NotNull
    private final byte[] lightData;
    @NotNull
    private InetAddress addressToSend;
    private final float sendRate = 0.1f;
    private int dropAmount;
    private float time;
    private float cumu;
    private final int port;

    public final int getNUM_LIGHTS() {
        return this.NUM_LIGHTS;
    }

    public final int getNUM_FIELDS() {
        return this.NUM_FIELDS;
    }

    public final int getSTART_BYTES() {
        return this.START_BYTES;
    }

    public final int getRED_OFFSET() {
        return this.RED_OFFSET;
    }

    public final int getGREEN_OFFSET() {
        return this.GREEN_OFFSET;
    }

    public final int getBLUE_OFFSET() {
        return this.BLUE_OFFSET;
    }

    @NotNull
    public final DatagramSocket getSocket() {
        return this.socket;
    }

    @NotNull
    public final byte[] getLightData() {
        return this.lightData;
    }

    @NotNull
    public final InetAddress getAddressToSend() {
        return this.addressToSend;
    }

    public final void setAddressToSend(@NotNull InetAddress inetAddress) {
        Intrinsics.checkParameterIsNotNull(inetAddress, "<set-?>");
        this.addressToSend = inetAddress;
    }

    public final float getSendRate() {
        return this.sendRate;
    }

    private final int convertColor(float f) {
        return (int)(f * 255.0f);
    }

    public final void setLight(int lightNumber, float r, float g, float b) {
        this.setLight(lightNumber, this.convertColor(r), this.convertColor(g), this.convertColor(b));
    }

    private final void setLight(int lightNumber, byte r, byte g, byte b) {
        this.lightData[this.START_BYTES + lightNumber * this.NUM_FIELDS + this.RED_OFFSET] = r;
        this.lightData[this.START_BYTES + lightNumber * this.NUM_FIELDS + this.GREEN_OFFSET] = g;
        this.lightData[this.START_BYTES + lightNumber * this.NUM_FIELDS + this.BLUE_OFFSET] = b;
    }

    public final void setLight(int lightNumber, int ri, int gi, int bi) {
        byte r = (byte)ri;
        byte g = (byte)gi;
        byte b = (byte)bi;
        this.setLight(lightNumber, r, g, b);
    }

    @NotNull
    public final byte[] getLightColor(int index) {
        byte r = this.lightData[this.START_BYTES + index * this.NUM_FIELDS + this.RED_OFFSET];
        byte g = this.lightData[this.START_BYTES + index * this.NUM_FIELDS + this.GREEN_OFFSET];
        byte b = this.lightData[this.START_BYTES + index * this.NUM_FIELDS + this.BLUE_OFFSET];
        return new byte[]{r, g, b};
    }

    public final void sendAll() {
        DatagramPacket packet = new DatagramPacket(this.lightData, this.lightData.length, this.addressToSend, this.port);
        this.socket.send(packet);
    }

    public final int getDropAmount() {
        return this.dropAmount;
    }

    public final void setDropAmount(int n) {
        this.dropAmount = n;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(float delta) {
        float fadeAmount = delta * (float)20;
        this.cumu += fadeAmount;
        if (this.cumu >= 1.0f) {
            int n = 0;
            int n2 = this.NUM_LIGHTS - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    byte r = this.getLightColor((int)i)[0];
                    byte g = this.getLightColor((int)i)[1];
                    byte b = this.getLightColor((int)i)[2];
                    int rmin = r - this.dropAmount;
                    int gmin = g - this.dropAmount;
                    int bmin = b - this.dropAmount;
                    r = r >= 0 && r < 128 && rmin < 0 ? (byte)0 : (byte)rmin;
                    g = g >= 0 && g < 128 && gmin < 0 ? (byte)0 : (byte)gmin;
                    b = b >= 0 && b < 128 && bmin < 0 ? (byte)0 : (byte)bmin;
                    this.setLight((int)i, r, g, b);
                    if (i == n2) break;
                    ++i;
                }
            }
            this.cumu = 0.0f;
        }
        if (this.time >= this.sendRate) {
            this.sendAll();
            this.time = 0.0f;
        }
        this.time += delta;
    }

    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public NetworkLights(int port, @NotNull String address) {
        CharSequence i2;
        Object object;
        Intrinsics.checkParameterIsNotNull(address, "address");
        this.port = port;
        this.NUM_LIGHTS = 24;
        this.NUM_FIELDS = 6;
        this.START_BYTES = 7;
        this.RED_OFFSET = 3;
        this.GREEN_OFFSET = this.RED_OFFSET + 1;
        this.BLUE_OFFSET = this.GREEN_OFFSET + 1;
        this.socket = new DatagramSocket();
        this.sendRate = 0.1f;
        this.lightData = new byte[this.START_BYTES + this.NUM_FIELDS * this.NUM_LIGHTS];
        this.lightData[0] = 1;
        this.lightData[1] = 0;
        this.lightData[2] = 119;
        this.lightData[3] = 97;
        this.lightData[4] = 98;
        this.lightData[5] = 101;
        this.lightData[6] = 0;
        int lightIndex = 0;
        int n = this.START_BYTES;
        IntProgression intProgression = RangesKt.step(new IntRange(n, this.lightData.length - 1), this.NUM_FIELDS);
        int n2 = intProgression.getFirst();
        int n3 = intProgression.getLast();
        int n4 = intProgression.getStep();
        int n5 = n2;
        int n6 = n3;
        if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i2;
                this.lightData[i2] = 1;
                this.lightData[i2 + true] = (byte)lightIndex;
                this.lightData[i2 + 2] = 0;
                this.lightData[i2 + 3] = 0;
                this.lightData[i2 + 4] = 0;
                this.lightData[i2 + 5] = 0;
                ++lightIndex;
                if (i2 == n3) break;
                i2 += n4;
            }
        }
        if (!((Regex)(object = new Regex(".*\\d+.*"))).matches(i2 = (CharSequence)address)) {
            i2 = address;
            NetworkLights networkLights = this;
            String string = ((Object)StringsKt.trim(i2)).toString();
            InetAddress inetAddress = InetAddress.getByName(string);
            Intrinsics.checkExpressionValueIsNotNull(inetAddress, "InetAddress.getByName(address.trim())");
            networkLights.addressToSend = inetAddress;
        } else {
            object = address;
            List addressChunks = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)object)).toString(), new String[]{"."}, false, 0, 6, null);
            byte[] addressAsBytes = new byte[]{(byte)Integer.parseInt((String)addressChunks.get(0)), (byte)Integer.parseInt((String)addressChunks.get(1)), (byte)Integer.parseInt((String)addressChunks.get(2)), (byte)Integer.parseInt((String)addressChunks.get(3))};
            InetAddress inetAddress = InetAddress.getByAddress(addressAsBytes);
            Intrinsics.checkExpressionValueIsNotNull(inetAddress, "InetAddress.getByAddress(addressAsBytes)");
            this.addressToSend = inetAddress;
        }
        int addressChunks = 0;
        int n7 = this.NUM_LIGHTS - 1;
        if (addressChunks <= n7) {
            while (true) {
                this.setLight((int)i, 0, 0, 0);
                if (i == n7) break;
                ++i;
            }
        }
        this.setLight(0, 0, 254, 0);
        this.sendAll();
        this.dropAmount = 25;
    }
}

