/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.DrawableMesh;
import com.mygdx.game.RuntimeDemoException;
import com.mygdx.game.VertexBlock;
import glm.vec2.Vec2;
import glm.vec3.Vec3;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00172\b\b\u0002\u0010,\u001a\u00020\u0006J\b\u0010-\u001a\u00020*H\u0016J\u0018\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0016J\u0006\u00102\u001a\u00020*J\u0016\u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u00020*J\u0018\u00108\u001a\u00020*2\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0010X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R6\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0017`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR-\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u0016j\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR-\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00060\u0016j\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u0006`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00069"}, d2={"Lcom/mygdx/game/PostProcessingBuffer;", "Lcom/mygdx/game/DrawableMesh;", "cfg", "Lcom/mygdx/game/Config;", "(Lcom/mygdx/game/Config;)V", "MAX_VERTS", "", "getMAX_VERTS", "()I", "mesh", "Lcom/badlogic/gdx/graphics/Mesh;", "getMesh", "()Lcom/badlogic/gdx/graphics/Mesh;", "setMesh", "(Lcom/badlogic/gdx/graphics/Mesh;)V", "sp", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "getSp", "()Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "setSp", "(Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;)V", "texture", "Ljava/util/HashMap;", "Lcom/badlogic/gdx/graphics/Texture;", "Lkotlin/collections/HashMap;", "getTexture", "()Ljava/util/HashMap;", "setTexture", "(Ljava/util/HashMap;)V", "uniformFloats", "", "", "getUniformFloats", "uniformInts", "getUniformInts", "vertices", "Lcom/mygdx/game/VertexBlock;", "getVertices", "()Lcom/mygdx/game/VertexBlock;", "setVertices", "(Lcom/mygdx/game/VertexBlock;)V", "attachFBTexture", "", "screenTexture", "index", "dispose", "render", "delta", "cam", "Lcom/mygdx/game/Camera;", "setPoints", "setUniform", "name", "value", "", "setUniforms", "update", "core"})
public abstract class PostProcessingBuffer
extends DrawableMesh {
    @NotNull
    private HashMap<Integer, Texture> texture;
    private final int MAX_VERTS;
    @NotNull
    private Mesh mesh;
    @NotNull
    private VertexBlock vertices;
    @NotNull
    private final HashMap<String, Float> uniformFloats;
    @NotNull
    private final HashMap<String, Integer> uniformInts;

    @NotNull
    public final HashMap<Integer, Texture> getTexture() {
        return this.texture;
    }

    public final void setTexture(@NotNull HashMap<Integer, Texture> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, "<set-?>");
        this.texture = hashMap;
    }

    @Override
    public final int getMAX_VERTS() {
        return this.MAX_VERTS;
    }

    @Override
    @NotNull
    public final Mesh getMesh() {
        return this.mesh;
    }

    @Override
    public final void setMesh(@NotNull Mesh mesh) {
        Intrinsics.checkParameterIsNotNull(mesh, "<set-?>");
        this.mesh = mesh;
    }

    @Override
    @NotNull
    public final VertexBlock getVertices() {
        return this.vertices;
    }

    @Override
    public final void setVertices(@NotNull VertexBlock vertexBlock) {
        Intrinsics.checkParameterIsNotNull(vertexBlock, "<set-?>");
        this.vertices = vertexBlock;
    }

    @NotNull
    public abstract ShaderProgram getSp();

    public abstract void setSp(@NotNull ShaderProgram var1);

    @NotNull
    public final HashMap<String, Float> getUniformFloats() {
        return this.uniformFloats;
    }

    @NotNull
    public final HashMap<String, Integer> getUniformInts() {
        return this.uniformInts;
    }

    public final void setUniform(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        if (object instanceof Float) {
            Map map = this.uniformFloats;
            Object object2 = value;
            map.put(name, object2);
        } else if (object instanceof Integer) {
            Map map = this.uniformInts;
            Object object3 = value;
            map.put(name, object3);
        } else {
            throw (Throwable)new RuntimeDemoException("uniform (" + name + ") type is not supported!");
        }
    }

    public final void attachFBTexture(@NotNull Texture screenTexture, int index) {
        Intrinsics.checkParameterIsNotNull(screenTexture, "screenTexture");
        Map map = this.texture;
        Integer n = index;
        Texture texture = screenTexture;
        map.put(n, texture);
    }

    public static /* synthetic */ void attachFBTexture$default(PostProcessingBuffer postProcessingBuffer, Texture texture, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attachFBTexture");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        postProcessingBuffer.attachFBTexture(texture, n);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mesh.dispose();
    }

    public final void setPoints() {
        this.vertices.queueVertex(new Vec3(-1.0f, -1.0f, 0.0f), new Vec2((Number)0, (Number)0));
        this.vertices.queueVertex(new Vec3(1.0f, 1.0f, 0.0f), new Vec2((Number)1, (Number)1));
        this.vertices.queueVertex(new Vec3(-1.0f, 1.0f, 0.0f), new Vec2((Number)0, (Number)1));
        this.vertices.queueVertex(new Vec3(-1.0f, -1.0f, 0.0f), new Vec2((Number)0, (Number)0));
        this.vertices.queueVertex(new Vec3(1.0f, -1.0f, 0.0f), new Vec2((Number)1, (Number)0));
        this.vertices.queueVertex(new Vec3(1.0f, 1.0f, 0.0f), new Vec2((Number)1, (Number)1));
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
    }

    public final void setUniforms() {
        Object s;
        Map.Entry entry;
        Map.Entry entry2;
        Map map = this.uniformFloats;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = iterator2.next();
            s = (String)entry.getKey();
            entry = entry2;
            float f = ((Number)entry.getValue()).floatValue();
            this.getSp().setUniformf((String)s, f);
        }
        s = this.uniformInts;
        iterator2 = s.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = iterator2.next();
            s = (String)entry.getKey();
            entry = entry2;
            int f = ((Number)entry.getValue()).intValue();
            this.getSp().setUniformi((String)s, f);
        }
    }

    @Override
    public void render(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        ShaderProgram $receiver$iv = this.getSp();
        $receiver$iv.begin();
        ShaderProgram it = $receiver$iv;
        this.setUniforms();
        Texture texture = this.texture.get(0);
        if (texture == null) {
            Intrinsics.throwNpe();
        }
        texture.bind();
        VertexBlock.flush$default(this.vertices, this.mesh, this.getSp(), 4, 0, false, 0, 48, null);
        $receiver$iv.end();
    }

    public PostProcessingBuffer(@NotNull Config cfg) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        super(cfg);
        this.texture = new HashMap();
        this.MAX_VERTS = 6 * this.getPOSITION_COMPONENTS() * this.getTEXTURE_COMPONENTS();
        this.mesh = new Mesh(true, this.MAX_VERTS, 0, new VertexAttribute(1, this.getPOSITION_COMPONENTS(), "aPos"), new VertexAttribute(16, this.getTEXTURE_COMPONENTS(), "aTexCoords"));
        this.vertices = new VertexBlock(this.mesh.getMaxVertices());
        this.uniformFloats = new HashMap();
        this.uniformInts = new HashMap();
        this.setPoints();
        this.mesh.setVertices(this.vertices.getVertices());
    }
}

