/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Debug;
import com.mygdx.game.LinePoint;
import com.mygdx.game.UtilsKt;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0001)B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000fJ\u0014\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\rJ\u0014\u0010\u001a\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\rJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0012\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0002J\u0011\u0010 \u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0002J$\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&J\u0018\u0010\u0010\u001a\n '*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010(\u001a\u00020\u001eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006*"}, d2={"Lcom/mygdx/game/LineContainer;", "", "useColor", "", "useDerivates", "(ZZ)V", "baseColor", "Lcom/badlogic/gdx/graphics/Color;", "getBaseColor", "()Lcom/badlogic/gdx/graphics/Color;", "setBaseColor", "(Lcom/badlogic/gdx/graphics/Color;)V", "colors", "Lcom/badlogic/gdx/utils/Array;", "derivates", "Lglm/vec3/Vec3;", "pos", "getUseColor", "()Z", "getUseDerivates", "add", "", "p", "Lcom/mygdx/game/LinePoint;", "addAllLinePoints", "points", "addAllVec3", "clear", "color", "i", "", "derivate", "get", "getLerp", "f", "", "precise", "debug", "Lcom/mygdx/game/Debug;", "kotlin.jvm.PlatformType", "size", "Companion", "core"})
public final class LineContainer {
    private Array<Color> colors;
    private Array<Vec3> derivates;
    private final Array<Vec3> pos;
    @NotNull
    private Color baseColor;
    private final boolean useColor;
    private final boolean useDerivates;
    @NotNull
    private static final Vec3 mockVec;
    public static final Companion Companion;

    @NotNull
    public final Color getBaseColor() {
        return this.baseColor;
    }

    public final void setBaseColor(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull(color, "<set-?>");
        this.baseColor = color;
    }

    public final void clear() {
        block1: {
            this.pos.clear();
            Array<Vec3> array = this.derivates;
            if (array != null) {
                array.clear();
            }
            Array<Color> array2 = this.colors;
            if (array2 == null) break block1;
            array2.clear();
        }
    }

    public final void addAllVec3(@NotNull Array<Vec3> points) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        Iterable $receiver$iv = points;
        for (Object element$iv : $receiver$iv) {
            Vec3 it;
            Vec3 vec3 = it = (Vec3)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(vec3, "it");
            this.add(vec3);
        }
    }

    public final void addAllLinePoints(@NotNull Array<LinePoint> points) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        Iterable $receiver$iv = points;
        for (Object element$iv : $receiver$iv) {
            LinePoint it;
            LinePoint linePoint = it = (LinePoint)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(linePoint, "it");
            this.add(linePoint);
        }
    }

    public final void add(@NotNull Vec3 pos) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        this.add(new LinePoint(pos, null, null, 6, null));
    }

    public final void add(@NotNull LinePoint p2) {
        block3: {
            Intrinsics.checkParameterIsNotNull(p2, "p");
            this.pos.add(p2.getPos());
            if (this.useColor) {
                Array<Color> array = this.colors;
                if (array != null) {
                    array.add(p2.getColor());
                }
            }
            if (!this.useDerivates) break block3;
            Array<Vec3> array = this.derivates;
            if (array != null) {
                array.add(p2.getDeriv());
            }
        }
    }

    public final int size() {
        return this.pos.size;
    }

    @NotNull
    public final LinePoint get(int i) {
        Vec3 vec3 = this.pos.get(i);
        Intrinsics.checkExpressionValueIsNotNull(vec3, "pos[i]");
        return new LinePoint(vec3, this.color(i), this.derivate(i));
    }

    @NotNull
    public final LinePoint getLerp(float f, boolean precise, @Nullable Debug debug) {
        float c = MathUtils.clamp(f, 0.0f, 1.0f);
        int i = (int)(c * (float)(this.size() - 1));
        if (i >= this.size() - 2) {
            i = this.size() - 3;
        }
        if (precise) {
            float inLerp = c * (float)(this.size() - 1) - (float)i;
            inLerp = MathUtils.clamp(inLerp, 0.0f, 1.0f);
            Vec3 from = this.pos.get(i);
            Vec3 to = this.pos.get(i + 1);
            Vec3 vec3 = from;
            Intrinsics.checkExpressionValueIsNotNull(vec3, "from");
            Vec3 vec32 = from.plus(to.minus(vec3).times(inLerp));
            if (this.useDerivates) {
                Array<Vec3> array = this.derivates;
                if (array == null) {
                    Intrinsics.throwNpe();
                }
                Vec3 dfrom = Vec3.normalize$default(array.get(i + 0), null, 1, null);
                Array<Vec3> array2 = this.derivates;
                if (array2 == null) {
                    Intrinsics.throwNpe();
                }
                Vec3 dto = Vec3.normalize$default(array2.get(i + 1), null, 1, null);
                Vec3 slerpedDerivate = UtilsKt.cslerp(dfrom, Vec3.normalize$default(dto, null, 1, null), inLerp);
                Debug debug2 = debug;
                if (debug2 != null) {
                    debug2.addScreenMsg("dto", UtilsKt.vec2String(dto));
                }
                Debug debug3 = debug;
                if (debug3 != null) {
                    debug3.addScreenMsg("dfrom", UtilsKt.vec2String(dfrom));
                }
                return new LinePoint(vec32, this.color(i), slerpedDerivate);
            }
            return new LinePoint(vec32, this.color(i), this.derivate(i));
        }
        Vec3 vec3 = this.pos.get(i);
        Intrinsics.checkExpressionValueIsNotNull(vec3, "pos[i]");
        return new LinePoint(vec3, this.color(i), this.derivate(i));
    }

    @NotNull
    public static /* synthetic */ LinePoint getLerp$default(LineContainer lineContainer, float f, boolean bl, Debug debug, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            debug = null;
        }
        return lineContainer.getLerp(f, bl, debug);
    }

    private final Color color(int i) {
        Array<Color> array = this.colors;
        if (array == null || (array = array.get(i)) == null) {
            array = this.baseColor;
        }
        return array;
    }

    static /* synthetic */ Color color$default(LineContainer lineContainer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return lineContainer.color(n);
    }

    private final Vec3 pos(int i) {
        return this.pos.get(i);
    }

    private final Vec3 derivate(int i) {
        Array<Vec3> array = this.derivates;
        if (array == null || (array = array.get(i)) == null) {
            array = mockVec;
        }
        return array;
    }

    static /* synthetic */ Vec3 derivate$default(LineContainer lineContainer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return lineContainer.derivate(n);
    }

    public final boolean getUseColor() {
        return this.useColor;
    }

    public final boolean getUseDerivates() {
        return this.useDerivates;
    }

    public LineContainer(boolean useColor, boolean useDerivates) {
        this.useColor = useColor;
        this.useDerivates = useDerivates;
        this.pos = new Array();
        Color color = Color.BLACK;
        Intrinsics.checkExpressionValueIsNotNull(color, "Color.BLACK");
        this.baseColor = color;
        if (this.useColor) {
            this.colors = new Array();
        }
        if (this.useDerivates) {
            this.derivates = new Array();
        }
    }

    public /* synthetic */ LineContainer(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    public LineContainer() {
        this(false, false, 3, null);
    }

    static {
        Companion = new Companion(null);
        mockVec = new Vec3();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mygdx/game/LineContainer$Companion;", "", "()V", "mockVec", "Lglm/vec3/Vec3;", "getMockVec", "()Lglm/vec3/Vec3;", "core"})
    public static final class Companion {
        @NotNull
        public final Vec3 getMockVec() {
            return mockVec;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

