/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.GLOnlyTextureData;
import com.badlogic.gdx.utils.Disposable;
import com.mygdx.game.InitDemoException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\b\u0010%\u001a\u00020#H\u0016J\u0006\u0010&\u001a\u00020#J\u0006\u0010'\u001a\u00020#J\u0006\u0010(\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020#R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000e\u00a8\u0006*"}, d2={"Lcom/mygdx/game/CustomFramebuffer;", "Lcom/badlogic/gdx/utils/Disposable;", "format", "Lcom/badlogic/gdx/graphics/Pixmap$Format;", "width", "", "height", "hasDepth", "", "hasStencil", "existingStencil", "(Lcom/badlogic/gdx/graphics/Pixmap$Format;IIZZI)V", "depthbufferHandle", "getDepthbufferHandle", "()I", "setDepthbufferHandle", "(I)V", "framebufferHandle", "getFramebufferHandle", "setFramebufferHandle", "getHeight", "stencilbufferHandle", "getStencilbufferHandle", "setStencilbufferHandle", "texture", "Lcom/badlogic/gdx/graphics/Texture;", "getTexture", "()Lcom/badlogic/gdx/graphics/Texture;", "setTexture", "(Lcom/badlogic/gdx/graphics/Texture;)V", "texturehandle", "getTexturehandle", "setTexturehandle", "getWidth", "begin", "", "bind", "dispose", "end", "setFrameBufferViewport", "traditionalTexture", "unbind", "core"})
public final class CustomFramebuffer
implements Disposable {
    @NotNull
    public Texture texture;
    private int texturehandle;
    private int framebufferHandle;
    private int depthbufferHandle;
    private int stencilbufferHandle;
    private final int width;
    private final int height;

    @Override
    public void dispose() {
        Gdx.gl20.glDeleteBuffer(this.framebufferHandle);
    }

    @NotNull
    public final Texture getTexture() {
        Texture texture = this.texture;
        if (texture == null) {
            Intrinsics.throwUninitializedPropertyAccessException("texture");
        }
        return texture;
    }

    public final void setTexture(@NotNull Texture texture) {
        Intrinsics.checkParameterIsNotNull(texture, "<set-?>");
        this.texture = texture;
    }

    public final int getTexturehandle() {
        return this.texturehandle;
    }

    public final void setTexturehandle(int n) {
        this.texturehandle = n;
    }

    public final int getFramebufferHandle() {
        return this.framebufferHandle;
    }

    public final void setFramebufferHandle(int n) {
        this.framebufferHandle = n;
    }

    public final int getDepthbufferHandle() {
        return this.depthbufferHandle;
    }

    public final void setDepthbufferHandle(int n) {
        this.depthbufferHandle = n;
    }

    public final int getStencilbufferHandle() {
        return this.stencilbufferHandle;
    }

    public final void setStencilbufferHandle(int n) {
        this.stencilbufferHandle = n;
    }

    public final int traditionalTexture() {
        int textureHandle = Gdx.gl20.glGenTexture();
        Gdx.gl20.glBindTexture(5890, textureHandle);
        Gdx.gl20.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6407, 5121, null);
        Gdx.gl20.glTexParameteri(3553, 10241, 9729);
        Gdx.gl20.glTexParameteri(3553, 10240, 9729);
        Gdx.gl20.glBindTexture(5890, 0);
        return textureHandle;
    }

    public final void bind() {
        Gdx.gl20.glBindFramebuffer(36160, this.framebufferHandle);
    }

    public final void unbind() {
        Gdx.gl20.glBindFramebuffer(36160, 0);
    }

    public final void begin() {
        this.bind();
        this.setFrameBufferViewport();
    }

    public final void setFrameBufferViewport() {
        Gdx.gl20.glViewport(0, 0, this.width, this.height);
    }

    public final void end() {
        this.unbind();
        Gdx.gl20.glViewport(0, 0, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public CustomFramebuffer(@NotNull Pixmap.Format format, int width, int height, boolean hasDepth, boolean hasStencil, int existingStencil) {
        int status;
        Intrinsics.checkParameterIsNotNull((Object)format, "format");
        this.width = width;
        this.height = height;
        if (!hasStencil && existingStencil > 0) {
            throw (Throwable)new InitDemoException("Cannot use existing stencil if hasStencil is false!");
        }
        if (existingStencil > 0) {
            this.stencilbufferHandle = existingStencil;
        }
        this.framebufferHandle = Gdx.gl20.glGenFramebuffer();
        Gdx.gl20.glBindFramebuffer(36160, this.framebufferHandle);
        int glFormat = Pixmap.Format.toGlFormat(format);
        int glType = Pixmap.Format.toGlType(format);
        int type = 6407;
        GLOnlyTextureData data = new GLOnlyTextureData(this.width, this.height, 0, glFormat, glFormat, glType);
        Texture texture = this.texture = new Texture(data);
        if (texture == null) {
            Intrinsics.throwUninitializedPropertyAccessException("texture");
        }
        texture.bind();
        Texture texture2 = this.texture;
        if (texture2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("texture");
        }
        Gdx.gl20.glFramebufferTexture2D(36160, 36064, 3553, texture2.getTextureObjectHandle(), 0);
        if (hasDepth) {
            this.depthbufferHandle = Gdx.gl20.glGenTexture();
            Gdx.gl20.glBindTexture(3553, this.depthbufferHandle);
            Gdx.gl20.glTexImage2D(3553, 0, 33189, this.width, this.height, 0, 6402, 5121, null);
            Gdx.gl20.glTexParameteri(3553, 10242, 33071);
            Gdx.gl20.glTexParameteri(3553, 10243, 33071);
            Gdx.gl20.glTexParameteri(3553, 10240, 9728);
            Gdx.gl20.glTexParameteri(3553, 10241, 9728);
            int n = Gdx.gl20.glGetError();
            System.out.println(n);
        }
        if (hasDepth) {
            Gdx.gl20.glFramebufferTexture2D(36160, 36096, 3553, this.depthbufferHandle, 0);
        }
        if (hasStencil && existingStencil < 0) {
            this.stencilbufferHandle = Gdx.gl20.glGenTexture();
            Gdx.gl20.glBindTexture(3553, this.stencilbufferHandle);
            Gdx.gl20.glTexImage2D(3553, 0, 36168, this.width, this.height, 0, 6401, 5123, null);
            Gdx.gl20.glBindTexture(3553, 0);
        }
        if (hasStencil) {
            Gdx.gl20.glFramebufferTexture2D(36160, 36128, 3553, this.stencilbufferHandle, 0);
        }
        if ((status = Gdx.gl20.glCheckFramebufferStatus(36160)) != 36053) {
            String emsg = "Error creating framebuffer: ";
            switch (status) {
                case 36061: {
                    emsg = emsg + "unsupported framebuffer.";
                    break;
                }
                case 36054: {
                    emsg = emsg + "incomplete attachment";
                    break;
                }
                case 36055: {
                    emsg = emsg + "incomplete or missing attachment.";
                }
            }
            throw (Throwable)new InitDemoException(emsg);
        }
        Gdx.gl20.glBindRenderbuffer(36161, 0);
        Gdx.gl20.glBindTexture(5890, 0);
        Gdx.gl20.glBindFramebuffer(36160, 0);
    }

    public /* synthetic */ CustomFramebuffer(Pixmap.Format format, int n, int n2, boolean bl, boolean bl2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x20) != 0) {
            n3 = -1;
        }
        this(format, n, n2, bl, bl2, n3);
    }
}

