/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.mygdx.game.MusicService;
import com.mygdx.game.ResourceException;
import com.mygdx.game.SceneManager;
import com.mygdx.game.UtilsKt;
import com.mygdx.game.app.NetworkLights;
import java.util.Collection;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020D2\u0006\u0010P\u001a\u00020D2\u0006\u0010Q\u001a\u00020DJ\u0006\u0010R\u001a\u00020NJ\u000e\u0010S\u001a\u00020E2\u0006\u0010O\u001a\u00020DR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\u0004R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\u0004R\u001a\u0010\u001f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0006\"\u0004\b!\u0010\u0004R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\r\"\u0004\b4\u0010\u000fR\u001a\u00105\u001a\u000206X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R&\u0010<\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\r\"\u0004\b>\u0010\u000fR&\u0010?\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\r\"\u0004\bA\u0010\u000fR*\u0010B\u001a\u001e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020E0Cj\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020E`FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010G\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\r\"\u0004\bI\u0010\u000fR\u001a\u0010J\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\r\"\u0004\bL\u0010\u000f\u00a8\u0006T"}, d2={"Lcom/mygdx/game/Config;", "", "DEMOPRESENTATION", "", "(Z)V", "getDEMOPRESENTATION", "()Z", "allowMusicReset", "getAllowMusicReset", "setAllowMusicReset", "aspectRatio", "", "getAspectRatio", "()F", "setAspectRatio", "(F)V", "assetManager", "Lcom/badlogic/gdx/assets/AssetManager;", "getAssetManager", "()Lcom/badlogic/gdx/assets/AssetManager;", "setAssetManager", "(Lcom/badlogic/gdx/assets/AssetManager;)V", "bloomDiv", "getBloomDiv", "setBloomDiv", "bloomIntensity", "getBloomIntensity", "setBloomIntensity", "enableBloom", "getEnableBloom", "setEnableBloom", "enableSkybox", "getEnableSkybox", "setEnableSkybox", "inputMultiplexer", "Lcom/badlogic/gdx/InputMultiplexer;", "getInputMultiplexer", "()Lcom/badlogic/gdx/InputMultiplexer;", "music", "Lcom/mygdx/game/MusicService;", "getMusic", "()Lcom/mygdx/game/MusicService;", "setMusic", "(Lcom/mygdx/game/MusicService;)V", "networkLights", "Lcom/mygdx/game/app/NetworkLights;", "getNetworkLights", "()Lcom/mygdx/game/app/NetworkLights;", "setNetworkLights", "(Lcom/mygdx/game/app/NetworkLights;)V", "runningTime", "getRunningTime", "setRunningTime", "sceneManager", "Lcom/mygdx/game/SceneManager;", "getSceneManager", "()Lcom/mygdx/game/SceneManager;", "setSceneManager", "(Lcom/mygdx/game/SceneManager;)V", "value", "screenFadeBrightAmount", "getScreenFadeBrightAmount", "setScreenFadeBrightAmount", "screenFadeDarkAmount", "getScreenFadeDarkAmount", "setScreenFadeDarkAmount", "shaders", "Ljava/util/HashMap;", "", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "Lkotlin/collections/HashMap;", "virtualHeight", "getVirtualHeight", "setVirtualHeight", "virtualWidth", "getVirtualWidth", "setVirtualWidth", "addShader", "", "name", "vShaderPath", "fShaderPath", "disposeShaders", "getShader", "core"})
public final class Config {
    private final HashMap<String, ShaderProgram> shaders;
    @NotNull
    public SceneManager sceneManager;
    private float aspectRatio;
    @NotNull
    private final InputMultiplexer inputMultiplexer;
    @NotNull
    public AssetManager assetManager;
    private boolean allowMusicReset;
    private float runningTime;
    private float screenFadeDarkAmount;
    private float screenFadeBrightAmount;
    private float virtualWidth;
    private float virtualHeight;
    @NotNull
    public MusicService music;
    private boolean enableBloom;
    private float bloomIntensity;
    private float bloomDiv;
    private boolean enableSkybox;
    @Nullable
    private NetworkLights networkLights;
    private final boolean DEMOPRESENTATION;

    @NotNull
    public final ShaderProgram getShader(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        ShaderProgram shaderProgram = this.shaders.get(name);
        if (shaderProgram == null) {
            throw (Throwable)new ResourceException("Shader " + name + " does not exist.");
        }
        return shaderProgram;
    }

    public final void addShader(@NotNull String name, @NotNull String vShaderPath, @NotNull String fShaderPath) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(vShaderPath, "vShaderPath");
        Intrinsics.checkParameterIsNotNull(fShaderPath, "fShaderPath");
        String folder = "shaders/";
        this.shaders.put(name, UtilsKt.createMeshShader(folder + vShaderPath, folder + fShaderPath));
    }

    public final void disposeShaders() {
        Collection<ShaderProgram> collection = this.shaders.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "shaders.values");
        Iterable $receiver$iv = collection;
        for (Object element$iv : $receiver$iv) {
            ShaderProgram it = (ShaderProgram)element$iv;
            it.dispose();
        }
    }

    @NotNull
    public final SceneManager getSceneManager() {
        SceneManager sceneManager = this.sceneManager;
        if (sceneManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sceneManager");
        }
        return sceneManager;
    }

    public final void setSceneManager(@NotNull SceneManager sceneManager) {
        Intrinsics.checkParameterIsNotNull(sceneManager, "<set-?>");
        this.sceneManager = sceneManager;
    }

    public final float getAspectRatio() {
        return this.aspectRatio;
    }

    public final void setAspectRatio(float f) {
        this.aspectRatio = f;
    }

    @NotNull
    public final InputMultiplexer getInputMultiplexer() {
        return this.inputMultiplexer;
    }

    @NotNull
    public final AssetManager getAssetManager() {
        AssetManager assetManager = this.assetManager;
        if (assetManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("assetManager");
        }
        return assetManager;
    }

    public final void setAssetManager(@NotNull AssetManager assetManager) {
        Intrinsics.checkParameterIsNotNull(assetManager, "<set-?>");
        this.assetManager = assetManager;
    }

    public final boolean getAllowMusicReset() {
        return this.allowMusicReset;
    }

    public final void setAllowMusicReset(boolean bl) {
        this.allowMusicReset = bl;
    }

    public final float getRunningTime() {
        return this.runningTime;
    }

    public final void setRunningTime(float f) {
        this.runningTime = f;
    }

    public final float getScreenFadeDarkAmount() {
        return this.screenFadeDarkAmount;
    }

    public final void setScreenFadeDarkAmount(float value) {
        this.screenFadeDarkAmount = MathUtils.clamp(value, 0.0f, 1.0f);
    }

    public final float getScreenFadeBrightAmount() {
        return this.screenFadeBrightAmount;
    }

    public final void setScreenFadeBrightAmount(float value) {
        this.screenFadeBrightAmount = MathUtils.clamp(value, 0.0f, 1.0f);
    }

    public final float getVirtualWidth() {
        return this.virtualWidth;
    }

    public final void setVirtualWidth(float f) {
        this.virtualWidth = f;
    }

    public final float getVirtualHeight() {
        return this.virtualHeight;
    }

    public final void setVirtualHeight(float f) {
        this.virtualHeight = f;
    }

    @NotNull
    public final MusicService getMusic() {
        MusicService musicService = this.music;
        if (musicService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("music");
        }
        return musicService;
    }

    public final void setMusic(@NotNull MusicService musicService) {
        Intrinsics.checkParameterIsNotNull(musicService, "<set-?>");
        this.music = musicService;
    }

    public final boolean getEnableBloom() {
        return this.enableBloom;
    }

    public final void setEnableBloom(boolean bl) {
        this.enableBloom = bl;
    }

    public final float getBloomIntensity() {
        return this.bloomIntensity;
    }

    public final void setBloomIntensity(float f) {
        this.bloomIntensity = f;
    }

    public final float getBloomDiv() {
        return this.bloomDiv;
    }

    public final void setBloomDiv(float f) {
        this.bloomDiv = f;
    }

    public final boolean getEnableSkybox() {
        return this.enableSkybox;
    }

    public final void setEnableSkybox(boolean bl) {
        this.enableSkybox = bl;
    }

    @Nullable
    public final NetworkLights getNetworkLights() {
        return this.networkLights;
    }

    public final void setNetworkLights(@Nullable NetworkLights networkLights) {
        this.networkLights = networkLights;
    }

    public final boolean getDEMOPRESENTATION() {
        return this.DEMOPRESENTATION;
    }

    public Config(boolean DEMOPRESENTATION) {
        this.DEMOPRESENTATION = DEMOPRESENTATION;
        this.shaders = new HashMap();
        this.aspectRatio = 1.0f;
        this.inputMultiplexer = new InputMultiplexer();
        this.allowMusicReset = !this.DEMOPRESENTATION;
        this.screenFadeDarkAmount = 1.0f;
        this.enableBloom = true;
        this.bloomIntensity = 2.0f;
        this.bloomDiv = 4.0f;
        this.enableSkybox = true;
    }
}

